/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainComponent;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainInvalidCodeException;
import com.mmmhis.domain.DomainList;
import com.mmmhis.domain.DomainListEntry;
import com.mmmhis.domain.DomainString;
import java.util.ArrayList;

public final class DomainCodeQuery {
    private static final String KE_MODIFIER_CHAR = "-";
    private static final int EcENODE = 0;
    private static final int EcSIBLING = 1;
    private static final int EcCOMBINED = 2;
    private static final int EcEOTI = 3;
    private static final int EcCL_ENODE = 0;
    private static final int EcCL_SIBLING = 1;
    private static final int EcCL_EQUAL = 2;
    private static final int EcCL_LESS = 3;
    private static final int EcCL_GTR = 4;
    private static final int EcCL_EOT = 5;
    private static final int EcCL_DIGIT = 6;
    private static final int EcCL_ALPHA = 7;
    private static final int EcCL_CHAR = 8;
    private static final int EcCL_MCHARS = 9;
    private static final int EcCL_MATCHCHAR = 10;
    private static final int EcCL_FALSE = 0;
    private static final int EcCL_MAYBE = 1;
    private static final int EcCL_TRUE = 2;
    private ArrayList results = new ArrayList();
    private int resultsSize;
    private int index;
    private DomainEnvironment env;

    public DomainCodeQuery(DomainComponent classID, DomainEnvironment env, DomainList list, byte[] searchTree, int min, int max, int first, DomainListEntry start, DomainListEntry end, boolean reverse, boolean not, boolean notify) throws DomainInvalidCodeException {
        this.env = env;
        DomainCodeQuery.query(classID, env, this.results, list, searchTree, min, max, first, start, end, reverse, not, notify, true);
        this.resultsSize = this.results.size();
        this.index = 0;
    }

    public static DomainListEntry singleQuery(DomainComponent classID, DomainEnvironment env, DomainList list, byte[] searchTree, int min, int max, int first, DomainListEntry start, DomainListEntry end, boolean reverse, boolean not, boolean notify) throws DomainInvalidCodeException {
        DomainListEntry e = DomainCodeQuery.query(classID, env, null, list, searchTree, min, max, first, start, end, reverse, not, notify, false);
        return e;
    }

    private static DomainListEntry query(DomainComponent classID, DomainEnvironment env, ArrayList results, DomainList list, byte[] searchTree, int min, int max, int first, DomainListEntry start, DomainListEntry end, boolean reverse, boolean not, boolean notify, boolean detail) throws DomainInvalidCodeException {
        DomainListEntry currentCode = null;
        DomainListEntry match = null;
        DomainString currentCodeName = null;
        int found = 0;
        boolean isMatch = false;
        if (start == null) {
            start = reverse ? list.getLast() : list.getFirst();
        } else {
            list = start.getList();
        }
        if (start != null) {
            currentCode = start;
            while (currentCode != null) {
                int modifierPosition;
                currentCodeName = currentCode.getNameSure();
                if (env.isState(4)) {
                    modifierPosition = currentCodeName.indexOf(KE_MODIFIER_CHAR);
                    if (modifierPosition != -1) {
                        currentCodeName = new DomainString(currentCodeName.substring(0, modifierPosition));
                    }
                } else {
                    modifierPosition = -1;
                }
                boolean bl = isMatch = DomainCodeQuery.CL(currentCodeName.toByteArray(), searchTree) == not;
                if (isMatch) {
                    if (first <= 1) {
                        ++found;
                        if (notify) {
                            if (env.isState(2)) {
                                try {
                                    ((DomainInteger)currentCode.getAttribute(classID, env.getNotifyAttribute(), false)).setValue(env.getNotifyValue());
                                }
                                catch (DomainException e) {
                                    // empty catch block
                                }
                            }
                        }
                        match = currentCode;
                        if (!detail) break;
                        results.add(currentCode);
                    } else {
                        --first;
                    }
                }
                if (found < max && (currentCode = reverse ? currentCode.getPrevious() : currentCode.getNext()) != end) continue;
            }
            if (detail && found < min) {
                results.clear();
            }
        }
        env.CCP.setValue(match);
        return match;
    }

    private static boolean CL(byte[] code, byte[] searchTree) {
        int result = DomainCodeQuery.CLEval(code, 0, searchTree, 0, 0, 0, false, false);
        return result == 2;
    }

    private static int CLEval(byte[] code, int codeIndex, byte[] cl, int clIndex, int index, int state, boolean nested, boolean single) {
        boolean gotoInner = false;
        boolean gotoNext = false;
        int siblingIndex = -1;
        int[] ecCount = new int[1];
        boolean wildcard = false;
        int lcount = 0;
        if (state != 0) {
            gotoInner = true;
        }
        if (!gotoInner && nested) {
            while (cl[clIndex++] > 0) {
            }
        }
        int count = 0;
        while (clIndex >= 0 && clIndex < cl.length) {
            if (!gotoInner) {
                if (cl[clIndex] == 1) {
                    int pos = DomainEcNumber.EcGetNumber(cl, ++clIndex, ecCount);
                    siblingIndex = (clIndex += ecCount[0]) + pos;
                } else {
                    siblingIndex = -1;
                }
            }
            if (gotoInner || count == index) {
                if (!gotoInner) {
                    lcount = 0;
                }
                while (gotoInner || cl[clIndex] > 0) {
                    int result;
                    if (!gotoInner) {
                        wildcard = false;
                        state = cl[clIndex++];
                    }
                    gotoInner = false;
                    int pcodeIndex = codeIndex;
                    while (cl[clIndex] >= 5 && !gotoNext) {
                        byte codeval = code.length == codeIndex ? (byte)0 : code[codeIndex];
                        switch (cl[clIndex]) {
                            case 5: {
                                if (codeval == 0 || state == 4) {
                                    return 2;
                                }
                                if (state == 3) {
                                    return 0;
                                }
                                gotoNext = true;
                                break;
                            }
                            default: {
                                int compare = codeval - cl[clIndex];
                                if (compare < 0) {
                                    if (state == 3) {
                                        return 2;
                                    }
                                    if (wildcard) {
                                        gotoNext = true;
                                    } else {
                                        return 0;
                                    }
                                }
                                if (compare <= 0) break;
                                if (state == 4) {
                                    return 2;
                                }
                                gotoNext = true;
                                break;
                            }
                            case 6: {
                                wildcard = true;
                                if (Character.isDigit((char)codeval)) break;
                                gotoNext = true;
                                break;
                            }
                            case 7: {
                                wildcard = true;
                                if (Character.isLetter((char)codeval)) break;
                                gotoNext = true;
                                break;
                            }
                            case 8: {
                                wildcard = true;
                                if (codeval != 0) break;
                                return 0;
                            }
                            case 10: {
                                return 2;
                            }
                            case 9: {
                                wildcard = true;
                                byte[] local = code;
                                int localIndex = codeIndex;
                                while (true) {
                                    if (DomainCodeQuery.CLEval(local, localIndex, cl, clIndex + 1, index, state, true, true) == 2) {
                                        return 2;
                                    }
                                    if (localIndex == local.length) break;
                                    ++localIndex;
                                }
                                gotoNext = true;
                            }
                        }
                        if (gotoNext) continue;
                        ++clIndex;
                        ++codeIndex;
                    }
                    if (!gotoNext && (result = DomainCodeQuery.CLEval(code, codeIndex, cl, clIndex, lcount, 0, true, false)) != 1) {
                        return result;
                    }
                    gotoNext = false;
                    if (single) {
                        return 0;
                    }
                    while (cl[clIndex] > 5) {
                        ++clIndex;
                    }
                    if (cl[clIndex] == 5) {
                        ++clIndex;
                    } else {
                        ++lcount;
                    }
                    codeIndex = pcodeIndex;
                }
                return 1;
            }
            ++count;
            clIndex = siblingIndex;
        }
        return 0;
    }

    public DomainListEntry next() {
        DomainListEntry e = this.index < this.resultsSize ? (DomainListEntry)this.results.get(this.index++) : null;
        this.env.CCP.setValue(e);
        return e;
    }

    public boolean hasNext() {
        return this.index < this.resultsSize;
    }

    public int compareTo(Object o) {
        return -1;
    }

    public int count() {
        return this.resultsSize;
    }

    public DomainListEntry first() {
        return this.resultsSize > 0 ? this.results.get(0) : null;
    }

    public int delete() throws DomainInvalidCodeException {
        DomainListEntry c;
        if (this.resultsSize == 0) {
            return 130;
        }
        while ((c = this.next()) != null) {
            c.delete();
        }
        return 0;
    }

    public DomainListEntry modify40(String command, boolean dup) {
        DomainListEntry c;
        DomainListEntry e = null;
        while ((c = this.next()) != null) {
            e = c.modify40(command, dup);
        }
        return e;
    }

    public void modify(String command, boolean dup) {
        this.modify40(command, dup);
    }

    public DomainListEntry modify40(DomainString command, boolean dup) {
        return this.modify40(command.getValue(), dup);
    }

    public void modify(DomainString command, boolean dup) {
        this.modify40(command, dup);
    }

    public void resetClassAttributes(DomainComponent classID) {
        DomainListEntry c;
        while ((c = this.next()) != null) {
            c.resetClassAttributes(classID);
        }
    }

    public void resetAttributes() {
        DomainListEntry c;
        while ((c = this.next()) != null) {
            c.resetAttributes();
        }
    }

    public void removeAttribute(DomainComponent classID, int key) {
        DomainListEntry c;
        while ((c = this.next()) != null) {
            c.removeAttribute(classID, key);
        }
    }

    public DomainList getList() {
        if (this.resultsSize > 0) {
            return ((DomainListEntry)this.results.get(0)).getList();
        }
        return null;
    }

    public ArrayList getArrayList() {
        return this.results;
    }

    public boolean execute(DomainString leftover, String prefix, Object[] args) {
        DomainListEntry c;
        boolean result = false;
        while ((c = this.next()) != null) {
            result = c.execute(leftover, prefix, args);
        }
        return result;
    }
}

