/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainBit;
import com.mmmhis.domain.DomainCodeQuery;
import com.mmmhis.domain.DomainDate;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainFixedString;
import com.mmmhis.domain.DomainIeFile;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainListEntry;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainTable;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBLHandle;
import com.mmmhis.domain.db.DBLPrimitive;
import com.mmmhis.domain.table.TBLCursor;

public final class DomainCursor
extends DomainVariable {
    public static final int DT_VOID = 0;
    public static final int DT_BOOL = 1;
    public static final int DT_INTEGER = 2;
    public static final int DT_FLOAT = 3;
    public static final int DT_BITSTR = 4;
    public static final int DT_STRING = 5;
    public static final int DT_JUMP = 6;
    public static final int DT_CODE = 7;
    public static final int DT_CURSOR = 8;
    public static final int DT_LIST = 9;
    public static final int DT_DATE = 10;
    public static final int DT_CURRENCY = 11;
    public static final int DT_REF = 12;
    public static final int DT_CLASS = 13;
    public static final int DT_TABLE = 14;
    public static final int DT_ARRAY = 15;
    public static final int DT_POOL = 16;
    public static final int DT_BITMEMBER = 17;
    public static final int DT_BITLIT = 18;
    public static final int DT_AREF = 19;
    public static final int DT_REFTOLIST = 20;
    public static final int DT_CODEQUERY = 21;
    public static final int DT_STRUCT = 22;
    public static final int DT_FIXEDSTRING = 23;
    DBLHandle dblHandle;
    DomainIeFile ieFile;
    TBLCursor tableCursor;
    DBControl dbControl;
    static final String[] typelist = new String[]{"", "rcs", "tbl", "ctl", "rtm"};

    public DomainCursor() {
    }

    public DomainCursor(DBControl dbControl) {
        this.dbControl = dbControl;
    }

    public DomainCursor(DomainCursor cursor) {
        this.dblHandle = cursor.dblHandle;
        this.ieFile = cursor.ieFile;
        this.tableCursor = cursor.tableCursor;
    }

    public DomainCursor(DBControl dbControl, DomainCursor[] a, int i2) {
        this.dbControl = dbControl;
        this.DVArray = a;
        this.DVIndex = i2;
    }

    public void reset() {
        this.dblHandle = null;
        this.ieFile = null;
        this.tableCursor = null;
    }

    public boolean isTrue() {
        return this.dblHandle != null || this.ieFile != null || this.tableCursor != null;
    }

    public int compareTo(Object obj) {
        return 0;
    }

    public DomainVariable copy() {
        return new DomainCursor(this);
    }

    public TBLCursor getTableCursor() {
        return this.tableCursor;
    }

    public void setTableCursor(TBLCursor value) {
        this.tableCursor = value;
    }

    public DomainIeFile getIeFile() {
        return this.ieFile;
    }

    public void setIEFile(DomainIeFile value) {
        this.ieFile = value;
    }

    public int get(String tag, Object value, int type) {
        return this.get(tag, value, 0, type);
    }

    public int get(String tag, DomainVariable value, int type) {
        return this.get(tag, (Object)value, 0, type);
    }

    public int get(String tag, Object value, DomainInteger index, int type) {
        return this.get(tag, value, index.getValue(), type);
    }

    public int get(String tag, Object value, int index, int type) {
        DomainString localValue = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.get(tag, localValue)) : 113;
        if (status == 0) {
            this.handleDataType(localValue, value, index, type);
        }
        return status;
    }

    public int getFirst(DomainString tag, Object value, int type) {
        return this.getFirst(tag, value, 0, type);
    }

    public int getFirst(DomainString tag, DomainVariable value, int type) {
        return this.getFirst(tag, (Object)value, 0, type);
    }

    public int getFirst(DomainString tag, Object value, DomainInteger index, int type) {
        return this.getFirst(tag, value, index.getValue(), type);
    }

    public int getFirst(DomainString tag, Object value, int index, int type) {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getFirst(localTag, localValue)) : 113;
        if (status == 0) {
            if (tag != null) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int getNext(DomainString tag, Object value, int type) {
        return this.getNext(tag, value, 0, type);
    }

    public int getNext(DomainString tag, DomainVariable value, int type) {
        return this.getNext(tag, (Object)value, 0, type);
    }

    public int getNext(DomainString tag, Object value, DomainInteger index, int type) {
        return this.getNext(tag, value, index.getValue(), type);
    }

    public int getNext(DomainString tag, Object value, int index, int type) {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        if (tag != null && tag.length() > 0) {
            localTag.setValue(tag);
        }
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getNext(localTag, localValue)) : 113;
        if (status == 0) {
            if (tag != null && (tag.length() == 0 || tag.equals(""))) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int getPrev(DomainString tag, Object value, int type) {
        return this.getPrev(tag, value, 0, type);
    }

    public int getPrev(DomainString tag, DomainVariable value, int type) {
        return this.getPrev(tag, (Object)value, 0, type);
    }

    public int getPrev(DomainString tag, Object value, DomainInteger index, int type) {
        return this.getPrev(tag, value, index.getValue(), type);
    }

    public int getPrev(DomainString tag, Object value, int index, int type) {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        if (tag != null && tag.length() > 0) {
            localTag.setValue(tag);
        }
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getPrev(localTag, localValue)) : 113;
        if (status == 0) {
            if (tag != null && (tag.length() == 0 || tag.length() > 0 && tag.equals(""))) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int getLast(DomainString tag, Object value, int type) {
        return this.getLast(tag, value, 0, type);
    }

    public int getLast(DomainString tag, DomainVariable value, int type) {
        return this.getLast(tag, (Object)value, 0, type);
    }

    public int getLast(DomainString tag, Object value, DomainInteger index, int type) {
        return this.getLast(tag, value, index.getValue(), type);
    }

    public int getLast(DomainString tag, Object value, int index, int type) {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getLast(localTag, localValue)) : 113;
        if (status == 0) {
            if (tag != null) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int getAttribute(String tag, DomainString value, int index, int type) {
        return this.ieFile.domGetAttribute(tag, value);
    }

    public int getFirstAttribute(DomainString tag, DomainString value, int index, int type) {
        return this.ieFile.domGetFirstAttribute(tag, value);
    }

    public int getNextAttribute(DomainString tag, DomainString value, int index, int type) {
        return this.ieFile.domGetNextAttribute(tag, value);
    }

    public int getPreviousAttribute(DomainString tag, DomainString value, int index, int type) {
        return this.ieFile.domGetPreviousAttribute(tag, value);
    }

    public int getLastAttribute(DomainString tag, DomainString value, int index, int type) {
        return this.ieFile.domGetLastAttribute(tag, value);
    }

    public int getChild(DomainString tag, DomainString value, int index, int type) {
        return this.ieFile.getChild(tag, value);
    }

    public int getParent(DomainString tag, DomainString value, int index, int type) {
        return this.ieFile.getParent(tag, value);
    }

    public int getOpen(String path) throws DomainException {
        if (this.ieFile != null) {
            return 113;
        }
        this.ieFile = new DomainIeFile(this.dbControl, 0);
        int rtrn = this.ieFile.open(path, false);
        if (rtrn != 0) {
            this.ieFile = null;
        }
        return rtrn;
    }

    public int getClose() throws DomainException {
        if (this.ieFile == null) {
            return 113;
        }
        if (this.ieFile.type != 0) {
            return 114;
        }
        int rtrn = this.ieFile.close();
        this.ieFile = null;
        return rtrn;
    }

    public int getReset() throws DomainException {
        if (this.ieFile == null) {
            return 113;
        }
        if (this.ieFile.type != 0) {
            return 114;
        }
        return this.ieFile.reset();
    }

    public int getSection(String section) {
        if (this.ieFile != null) {
            if (this.ieFile.type != 0) {
                return 114;
            }
            return this.ieFile.getSection(section);
        }
        return 113;
    }

    public int getFirstSection(DomainString section) {
        DomainString localSection = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getFirstSection(localSection)) : 113;
        if (status == 0 && section != null) {
            section.setValue(localSection);
        }
        return status;
    }

    public int getNextSection(DomainString section) {
        DomainString localSection = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getNextSection(localSection)) : 113;
        if (status == 0 && section != null && (section.length() == 0 || section.length() > 0 && section.equals(""))) {
            section.setValue(localSection);
        }
        return status;
    }

    public int getPrevSection(DomainString section) {
        DomainString localSection = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getPrevSection(localSection)) : 113;
        if (status == 0 && section != null && (section.length() == 0 || section.length() > 0 && section.equals(""))) {
            section.setValue(localSection);
        }
        return status;
    }

    public int getLastSection(DomainString section) {
        DomainString localSection = new DomainString();
        int status = this.ieFile != null ? (this.ieFile.type != 0 ? 114 : this.ieFile.getLastSection(localSection)) : 113;
        if (status == 0 && section != null) {
            section.setValue(localSection);
        }
        return status;
    }

    public int put(String tag, String value) {
        int status = this.ieFile != null ? (this.ieFile.type != 1 ? 114 : this.ieFile.put(tag, value)) : 113;
        return status;
    }

    public int put(String name, DomainCodeQuery codeQuery) throws DomainException {
        int result = 105;
        if (this.ieFile.type == 0) {
            return 114;
        }
        DomainListEntry c = codeQuery.first();
        while (c != null) {
            result = this.put(name, c.getName().toString());
            c = codeQuery.next();
        }
        return result;
    }

    public int putInsert(String tag, String value) {
        int status = this.ieFile != null ? (this.ieFile.type != 1 ? 114 : this.ieFile.putInsert(tag, value)) : 113;
        return status;
    }

    public int putInsert(String name, DomainCodeQuery codeQuery) throws DomainException {
        int result = 105;
        if (this.ieFile.type == 0) {
            return 114;
        }
        DomainListEntry c = codeQuery.first();
        while (c != null) {
            result = this.putInsert(name, c.getName().toString());
            c = codeQuery.next();
        }
        return result;
    }

    public int putAttribute(String tag, String value) {
        return this.ieFile.domPutAttribute(tag, value);
    }

    public int putGotoParent() {
        int rc = this.ieFile.domPutGotoParent();
        if (rc == 0) {
            this.ieFile.xmlWriteSection(false);
        }
        return rc;
    }

    public int putChild(String name, String value) {
        return this.ieFile.domPutChild(name, value);
    }

    public int putGotoChild(String name) {
        return this.ieFile.putChildSectionGoto(name);
    }

    public int putOpen(String path) throws DomainException {
        if (this.ieFile != null) {
            return 113;
        }
        this.ieFile = new DomainIeFile(this.dbControl, 1);
        int status = this.ieFile.open(path, false);
        if (status != 0) {
            this.ieFile = null;
        }
        return status;
    }

    public int putClose() throws DomainException {
        if (this.ieFile == null) {
            return 113;
        }
        if (this.ieFile.type != 1) {
            return 114;
        }
        int rtrn = this.ieFile.close();
        this.ieFile = null;
        return rtrn;
    }

    public int putReset() throws DomainException {
        if (this.ieFile == null) {
            return 113;
        }
        if (this.ieFile.type == 0) {
            return 114;
        }
        return this.ieFile.reset();
    }

    public int putSection(String section) {
        int status = this.ieFile != null ? (this.ieFile.type != 1 ? 114 : this.ieFile.putSection(section)) : 113;
        return status;
    }

    public int putSectionGoto(String section) {
        int status = this.ieFile != null ? (this.ieFile.type != 1 ? 114 : this.ieFile.putSectionGoto(section)) : 113;
        return status;
    }

    public int putSectionInsert(String section) {
        int status = this.ieFile != null ? (this.ieFile.type != 1 ? 114 : this.ieFile.putSectionInsert(section)) : 113;
        return status;
    }

    public DBLHandle getDBLHandle() {
        return this.dblHandle;
    }

    public void setDBLHandle(DBLHandle value) {
        this.dblHandle = value;
    }

    private void handleDataType(DomainString localValue, Object value, int index, int type) {
        DomainEnvironment env = this.dbControl.getEnv();
        boolean needReset = false;
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: {
                ((DomainVariable)value).setValue(env, localValue);
                break;
            }
            case 13: 
            case 14: 
            case 22: {
                if (!localValue.isTrue()) {
                    this.dbControl.getEnv().LastError.setValue(4);
                    needReset = true;
                } else if (localValue.indexOf(123) == 0 && localValue.charAt(localValue.length() - 1) == '}') {
                    ((DomainVariable)value).setValue(env, localValue);
                    if (env.LastError.getValue() >= 1 && env.LastError.getValue() <= 3 || env.LastError.getValue() == 8) {
                        needReset = true;
                    }
                } else {
                    env.LastError.setValue(8);
                    needReset = true;
                }
                if (!needReset) break;
                ((DomainVariable)value).reset();
                break;
            }
            case 5: 
            case 23: {
                int i2;
                if ((this.ieFile == null || this.ieFile.ioType != 2) && (i2 = localValue.length()) > 1 && localValue.charAt(0) == '\"' && localValue.charAt(i2 - 1) == '\"') {
                    localValue = localValue.substring(1, i2 - 2);
                }
                if (value instanceof DomainString) {
                    ((DomainString)value).setValue(env, localValue);
                    break;
                }
                if (!(value instanceof DomainFixedString)) break;
                ((DomainFixedString)value).setValue(localValue);
                break;
            }
            case 10: {
                String dateFmt = this.dblHandle != null ? "%y%m%d" : env.getDateInFormat();
                ((DomainDate)value).setValue(DomainString.toDate(env, dateFmt, localValue, null));
                break;
            }
            case 15: {
                if (!localValue.isTrue()) {
                    this.dbControl.getEnv().LastError.setValue(4);
                    needReset = true;
                } else if (localValue.indexOf(123) == 0 && localValue.charAt(localValue.length() - 1) == '}') {
                    env.setValueFromString(localValue, (Object[])((DomainVariable[])value));
                    if (env.LastError.getValue() >= 1 && env.LastError.getValue() <= 3 || env.LastError.getValue() == 8) {
                        needReset = true;
                    }
                } else {
                    env.LastError.setValue(8);
                    needReset = true;
                }
                if (!needReset) break;
                for (int i3 = 0; i3 < ((DomainVariable[])value).length; ++i3) {
                    ((DomainVariable[])value)[i3].reset();
                }
                break;
            }
            case 17: {
                ((DomainBit)value).setValue(index, DomainString.toBitMemberValue(env, localValue));
                break;
            }
        }
    }

    public int loadOpen(String sectionName, boolean reopen) throws DomainException {
        int status;
        if (!this.dbControl.isOpen) {
            this.dbControl.open();
        }
        if (this.dblHandle != null) {
            if (!reopen) {
                return 113;
            }
        } else {
            this.dblHandle = new DBLHandle(this.dbControl);
            this.dblHandle.setPrimitive(new DBLPrimitive(this.dbControl));
        }
        if ((status = this.dblHandle.openLoad(sectionName, reopen)) != 0 && this.dblHandle != null) {
            this.loadClose(null, false);
        }
        return status;
    }

    public int loadClose() {
        return this.loadClose(null, false);
    }

    public int loadClose(String sectionName, boolean reopen) {
        if (this.dblHandle != null) {
            int status = this.dblHandle.closeLoad(sectionName, reopen);
            if (status == 0) {
                this.dblHandle = null;
            }
            return status;
        }
        return 113;
    }

    public int loadReset() throws DomainException {
        if (this.dblHandle != null) {
            return this.dblHandle.reset();
        }
        return 113;
    }

    public int loadSection(String section) throws DomainException {
        if (this.dblHandle != null) {
            return this.dblHandle.loadSection(section);
        }
        return 113;
    }

    public int load(String tag, Object value, int type) throws DomainException {
        return this.load(tag, value, 0, type);
    }

    public int load(String tag, DomainVariable value, int type) throws DomainException {
        return this.load(tag, (Object)value, 0, type);
    }

    public int load(String tag, Object value, DomainInteger index, int type) throws DomainException {
        return this.load(tag, value, index.getValue(), type);
    }

    public int load(String tag, Object value, int index, int type) throws DomainException {
        DomainString localValue = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.load(tag, localValue, type) : 113;
        if (status == 0) {
            this.handleDataType(localValue, value, index, type);
        }
        return status;
    }

    public int loadNext(DomainString tag, Object value, int type) throws DomainException {
        return this.loadNext(tag, value, 0, type);
    }

    public int loadNext(DomainString tag, DomainVariable value, int type) {
        return this.loadNext(tag, (Object)value, 0, type);
    }

    public int loadNext(DomainString tag, Object value, DomainInteger index, int type) {
        return this.loadNext(tag, value, index.getValue(), type);
    }

    public int loadNext(DomainString tag, Object value, int index, int type) throws DomainException {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadNext(localTag, localValue) : 113;
        if (status == 0) {
            if (tag != null) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int loadFirst(DomainString tag, Object value, int type) throws DomainException {
        return this.loadFirst(tag, value, 0, type);
    }

    public int loadFirst(DomainString tag, DomainVariable value, int type) throws DomainException {
        return this.loadFirst(tag, (Object)value, 0, type);
    }

    public int loadFirst(DomainString tag, Object value, DomainInteger index, int type) throws DomainException {
        return this.loadFirst(tag, value, index.getValue(), type);
    }

    public int loadFirst(DomainString tag, Object value, int index, int type) throws DomainException {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadFirst(localTag, localValue) : 113;
        if (status == 0) {
            if (tag != null) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int loadLast(DomainString tag, Object value, int type) throws DomainException {
        return this.loadLast(tag, value, 0, type);
    }

    public int loadLast(DomainString tag, DomainVariable value, int type) throws DomainException {
        return this.loadLast(tag, (Object)value, 0, type);
    }

    public int loadLast(DomainString tag, Object value, DomainInteger index, int type) throws DomainException {
        return this.loadLast(tag, value, index.getValue(), type);
    }

    public int loadLast(DomainString tag, Object value, int index, int type) throws DomainException {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadLast(localTag, localValue) : 113;
        if (status == 0) {
            if (tag != null) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int loadPrevious(DomainString tag, Object value, int type) throws DomainException {
        return this.loadPrevious(tag, value, 0, type);
    }

    public int loadPrevious(DomainString tag, DomainVariable value, int type) throws DomainException {
        return this.loadPrevious(tag, (Object)value, 0, type);
    }

    public int loadPrevious(DomainString tag, Object value, DomainInteger index, int type) throws DomainException {
        return this.loadPrevious(tag, value, index.getValue(), type);
    }

    public int loadPrevious(DomainString tag, Object value, int index, int type) throws DomainException {
        DomainString localValue = new DomainString();
        DomainString localTag = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadPrevious(localTag, localValue) : 113;
        if (status == 0) {
            if (tag != null) {
                tag.setValue(localTag);
            }
            if (value != null) {
                this.handleDataType(localValue, value, index, type);
            }
        }
        return status;
    }

    public int loadNextSection(DomainString section) throws DomainException {
        DomainString localSection = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadNextSection(localSection) : 113;
        if (status == 0 && section != null) {
            section.setValue(localSection);
        }
        return status;
    }

    public int loadFirstSection(DomainString section) throws DomainException {
        DomainString localSection = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadFirstSection(localSection) : 113;
        if (status == 0 && section != null) {
            section.setValue(localSection);
        }
        return status;
    }

    public int loadPrevSection(DomainString section) throws DomainException {
        DomainString localSection = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadPrevSection(localSection) : 113;
        if (status == 0 && section != null) {
            section.setValue(localSection);
        }
        return status;
    }

    public int loadLastSection(DomainString section) throws DomainException {
        DomainString localSection = new DomainString();
        int status = this.dblHandle != null ? this.dblHandle.loadLastSection(localSection) : 113;
        if (status == 0 && section != null) {
            section.setValue(localSection);
        }
        return status;
    }

    public int loadTable(String tablePath, DomainTable table) throws DomainException {
        if (this.dblHandle != null) {
            if (table.unknown) {
                table.resetValues();
            }
            return this.dblHandle.loadTable(tablePath, table);
        }
        return 113;
    }

    public DomainVariable setValue(DomainEnvironment _env, String s) {
        return null;
    }

    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        return null;
    }

    public DomainVariable setValue(DomainVariable v) {
        return null;
    }

    public int store(String tag, String value) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.store(tag.toUpperCase(), value) : 113;
        return status;
    }

    public int store(String name, DomainCodeQuery codeQuery) throws DomainException {
        int result = 105;
        DomainListEntry c = codeQuery.first();
        while (c != null) {
            result = this.store(name, c.getName().toString());
            c = codeQuery.next();
        }
        return result;
    }

    public int storeInsert(String tag, String value) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeInsert(tag.toUpperCase(), value) : 113;
        return status;
    }

    public int storeInsert(String name, DomainCodeQuery codeQuery) throws DomainException {
        int result = 105;
        DomainListEntry c = codeQuery.first();
        while (c != null) {
            result = this.storeInsert(name, c.getName().toString());
            c = codeQuery.next();
        }
        return result;
    }

    public int storeDelete(String tag) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeDelete(tag.toUpperCase()) : 113;
        return status;
    }

    public int storeRename(String oldTag, String newTag) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeRename(oldTag.toUpperCase(), newTag.toUpperCase()) : 113;
        return status;
    }

    public int storeOpen(String path) throws DomainException {
        boolean rostatus = false;
        int tblsize = 0;
        int[] iVar = new int[1];
        String[] sVar = new String[1];
        int status = 7;
        boolean shared = this.dbControl.getVarResource(path, "share", sVar, "");
        String type = sVar[0];
        this.dbControl.getVarResource(path, "Path", sVar, null);
        String orig = sVar[0];
        this.dbControl.getVarResource(path, "Type", sVar, null);
        type = sVar[0];
        this.dbControl.getVarResource(path, "backup", sVar, null);
        String local = sVar[0];
        this.dbControl.getVarResource(path, "origpath", sVar, null);
        String origpath = sVar[0];
        this.dbControl.getVarResource(path, "readonly", sVar, null);
        if (sVar[0] != null) {
            rostatus = true;
        }
        this.dbControl.getIntVarResource(path, "tblsize", iVar, 0);
        tblsize = iVar[0];
        if (this.dblHandle != null) {
            return 113;
        }
        int itype = DomainCursor.getType(type);
        if (itype == 0) {
            return 115;
        }
        this.dblHandle = new DBLHandle(this.dbControl);
        this.dblHandle.setType(itype);
        this.dblHandle.setRW(true);
        if (itype == 4) {
            this.dblHandle.attachTDFile();
            return 0;
        }
        status = this.dblHandle.openStore(orig, local, shared, origpath, tblsize, rostatus);
        if (status != 0 && status != 121) {
            this.dblHandle = null;
        }
        return status;
    }

    public int storeClose(boolean save) throws DomainException {
        if (this.dblHandle == null || !this.dblHandle.getRW()) {
            return 113;
        }
        int status = this.dblHandle.closeStore(save);
        if (status == 0) {
            this.dblHandle = null;
        }
        return status;
    }

    public int storeFlush(DomainTable DCtable) throws DomainException {
        if (this.dblHandle == null || !this.dblHandle.getRW()) {
            return 113;
        }
        int status = DCtable.getTblCursor().getTable().modifiedTable();
        if (status != 0) {
            return status;
        }
        status = this.dblHandle.flushStore();
        return status;
    }

    public int storeReset() throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeReset() : 113;
        return status;
    }

    public int storeTable(String tablePath, DomainTable table) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.loadTable(tablePath.toUpperCase(), table) : 113;
        return status;
    }

    public int storeSection(String section) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeSection(section.toUpperCase()) : 113;
        return status;
    }

    public int storeSectionDelete(String section) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeSectionDelete(section.toUpperCase()) : 113;
        return status;
    }

    public int storeSectionInsert(String section) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeSectionInsert(section.toUpperCase()) : 113;
        return status;
    }

    public int storeSectionRename(String oldSection, String newSection) throws DomainException {
        int status = this.dblHandle != null ? this.dblHandle.storeSectionRename(oldSection.toUpperCase(), newSection.toUpperCase()) : 113;
        return status;
    }

    static int getType(String str) {
        for (int i2 = 0; i2 < typelist.length; ++i2) {
            if (!typelist[i2].equalsIgnoreCase(str)) continue;
            return i2;
        }
        return 0;
    }

    public DomainVariable getNewInstance(DomainVariable[] a, int i2) {
        return new DomainCursor(this.dbControl, (DomainCursor[])a, i2);
    }
}

