/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainComponent;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainInvalidCodeException;
import com.mmmhis.domain.DomainListEntry;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import java.util.ArrayList;

public final class DomainList
extends DomainVariable
implements Comparable {
    private DomainListEntry first;
    private DomainListEntry last;
    private int count;
    private DomainEnvironment env;
    public static final int KeSTATUS_NORMAL = 0;
    public static final int KeSTATUS_CODENOTFOUND = 130;

    public DomainList(DomainEnvironment env) {
        this.env = env;
        this.last = null;
        this.first = null;
    }

    DomainList(DomainEnvironment env, DomainList list) {
        this.env = env;
        this.last = null;
        this.first = null;
        for (DomainListEntry e = list.first; e != null; e = e.getNext()) {
            this.append((DomainListEntry)e.copy());
        }
    }

    public DomainList(DomainEnvironment env, DomainList[] a, int i2) {
        this.env = env;
        this.last = null;
        this.first = null;
        this.DVArray = a;
        this.DVIndex = i2;
    }

    public DomainListEntry getFirst() {
        return this.first;
    }

    public void setFirst(DomainListEntry e) {
        this.first = e;
    }

    public DomainListEntry getLast() {
        return this.last;
    }

    public void setLast(DomainListEntry e) {
        this.last = e;
    }

    public DomainListEntry append(DomainString name) {
        if (!name.isTrue()) {
            return null;
        }
        DomainListEntry c = new DomainListEntry(name);
        return this.append(c);
    }

    public static DomainListEntry insert(DomainEnvironment env, DomainListEntry where, String name) {
        if (where != null) {
            return where.insert(name);
        }
        return env.getCurrentList().append(name);
    }

    public DomainListEntry append(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        DomainListEntry c = new DomainListEntry(name);
        return this.append(c);
    }

    DomainListEntry append(DomainListEntry e) {
        e.setPrevious(this.last);
        if (this.last != null) {
            this.last.setNext(e);
        }
        this.last = e;
        if (this.first == null) {
            this.first = e;
        }
        e.setList(this);
        e.setNext(null);
        ++this.count;
        this.setCCP(e);
        return e;
    }

    private static int copyAppend(DomainListEntry from, DomainList to, int[] attributes, DomainComponent classID) throws DomainInvalidCodeException {
        if (from == null) {
            return 130;
        }
        DomainListEntry newCode = to.append(from.getName());
        if (attributes != null) {
            for (int i2 = 0; i2 < attributes.length; ++i2) {
                Object tempAttribute = from.getAttribute(classID, attributes[i2], true);
                if (tempAttribute == null) continue;
                newCode.addAttribute(classID, attributes[i2], tempAttribute);
            }
        }
        return 0;
    }

    public static int copy(DomainListEntry from, DomainListEntry to, int[] attributes, DomainComponent classID) throws DomainInvalidCodeException {
        if (from == null) {
            return 130;
        }
        return from.copy(to, attributes, classID);
    }

    public static int copy(DomainListEntry from, DomainList to, int[] attributes, DomainComponent classID) throws DomainInvalidCodeException {
        return DomainList.copyAppend(from, to, attributes, classID);
    }

    public static int copy(ArrayList from, DomainListEntry to, int[] attributes, DomainComponent classID) throws DomainInvalidCodeException {
        if (from.size() == 0 || to == null) {
            return 130;
        }
        for (int i2 = 0; i2 < from.size(); ++i2) {
            ((DomainListEntry)from.get(i2)).copy(to, attributes, classID);
        }
        return 0;
    }

    public static int copy(ArrayList from, DomainList to, int[] attributes, DomainComponent classID) throws DomainInvalidCodeException {
        if (from.size() == 0 || to == null) {
            return 130;
        }
        for (int i2 = 0; i2 < from.size(); ++i2) {
            ((DomainListEntry)from.get(i2)).copy(to, attributes, classID);
        }
        return 0;
    }

    public DomainListEntry modify40(String command, boolean dup) {
        DomainListEntry current_entry;
        for (current_entry = this.first; current_entry != this.last; current_entry = current_entry.getNext()) {
            current_entry.modify40(command, dup);
        }
        current_entry.modify40(command, dup);
        if (dup) {
            current_entry = current_entry.getNext();
        }
        return current_entry;
    }

    public void modify(String command, boolean dup) {
        this.modify40(command, dup);
    }

    public DomainListEntry modify40(DomainString command, boolean dup) {
        DomainListEntry current_entry;
        for (current_entry = this.first; current_entry != this.last; current_entry = current_entry.getNext()) {
            current_entry.modify40(command.getValue(), dup);
        }
        current_entry.modify40(command.getValue(), dup);
        if (dup) {
            current_entry = current_entry.getNext();
        }
        return current_entry;
    }

    public void modify(DomainString command, boolean dup) {
        this.modify40(command, dup);
    }

    public static int move(DomainListEntry from, DomainListEntry to) {
        if (from == null || to == null) {
            return 130;
        }
        if (from != to) {
            from.move(to);
        }
        return 0;
    }

    public static int move(DomainListEntry from, DomainList to) {
        if (from == null || to == null) {
            return 130;
        }
        from.move(to);
        return 0;
    }

    public static int move(ArrayList from, DomainListEntry to) {
        if (from.size() == 0 || to == null) {
            return 130;
        }
        for (int i2 = 0; i2 < from.size(); ++i2) {
            ((DomainListEntry)from.get(i2)).move(to);
        }
        return 0;
    }

    public static int move(ArrayList from, DomainList to) {
        if (from.size() == 0 || to == null) {
            return 130;
        }
        for (int i2 = 0; i2 < from.size(); ++i2) {
            ((DomainListEntry)from.get(i2)).move(to);
        }
        return 0;
    }

    public int count() {
        return this.count;
    }

    public DomainList setValue(DomainList source) {
        if (source != this) {
            this.reset();
            for (DomainListEntry e = source.first; e != null; e = e.getNext()) {
                this.append((DomainListEntry)e.copy());
            }
        }
        return this;
    }

    public DomainList setValue(DomainString name) {
        this.append(name);
        return this;
    }

    public DomainVariable setValue(DomainEnvironment _env, String s) {
        _env.LastError.reset();
        if (s == null || s.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        return this.setValue(s);
    }

    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        _env.LastError.reset();
        if (s == null || s.count <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        return this.setValue(s);
    }

    public DomainList setValue(String name) {
        this.append(name);
        return this;
    }

    public DomainList setValue(DomainListEntry e) {
        if (e != null) {
            e.move(this);
        }
        return this;
    }

    public DomainVariable setValue(DomainVariable v) {
        return this.setValue((DomainList)v);
    }

    public void reset() {
        while (this.first != null) {
            this.first.delete();
        }
    }

    public int compareTo(Object o) {
        return -1;
    }

    public DomainListEntry toCode(int value) {
        if (this.first == null) {
            return null;
        }
        if (value == 0) {
            return null;
        }
        if (value > 0) {
            return this.first.plus(value - 1, false);
        }
        return this.last.plus(value + 1, false);
    }

    public DomainVariable copy() {
        return new DomainList(this.env, this);
    }

    void clear() {
        this.reset();
    }

    public boolean isTrue() {
        return this.count > 0;
    }

    public DomainEnvironment getEnv() {
        return this.env;
    }

    public void incCount() {
        ++this.count;
    }

    public void decCount() {
        --this.count;
    }

    public boolean contains(DomainListEntry e) {
        for (DomainListEntry local = this.first; local != null; local = local.getNext()) {
            if (local != e) continue;
            return true;
        }
        return false;
    }

    public DomainVariable getNewInstance(DomainVariable[] a, int i2) {
        return new DomainList(this.env, (DomainList[])a, i2);
    }

    public void setCCP(DomainListEntry e) {
        this.env.CCP.setValue(e);
    }

    public ArrayList getArrayList() {
        ArrayList<DomainListEntry> alist = new ArrayList<DomainListEntry>(this.count);
        for (DomainListEntry e = this.first; e != null; e = e.getNext()) {
            alist.add(e);
        }
        return alist;
    }
}

