/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainCodeQuery;
import com.mmmhis.domain.DomainComponent;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainList;
import com.mmmhis.domain.DomainListEntry;
import com.mmmhis.domain.DomainReference;
import com.mmmhis.domain.DomainVariable;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class DomainOrder {
    public static void simpleOrder(DomainReference a, DomainComponent classID, int elementsToSort, boolean sortOrder) {
        int index = a.index;
        DomainOrder.simpleOrder(a.array, classID, index, elementsToSort, sortOrder);
        a.value = a.array[index];
    }

    public static void simpleOrder(DomainVariable[] a, DomainComponent classID, int start, int elementsToSort, boolean sortOrder) {
        if (sortOrder) {
            DomainOrder.simpleSortForward(a, start, elementsToSort);
        } else {
            DomainOrder.simpleSortReverse(a, start, elementsToSort);
        }
        DomainOrder.fixIndices(a);
    }

    private static void simpleSortForward(DomainVariable[] a, int start, int elementsToSort) {
        int end = start + elementsToSort;
        for (int i2 = start + 1; i2 < end; ++i2) {
            DomainVariable B = a[i2];
            for (int j = i2; j > start && a[j - 1].compareTo(B) > 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = B;
        }
    }

    private static void simpleSortReverse(DomainVariable[] a, int start, int elementsToSort) {
        int end = start + elementsToSort;
        for (int i2 = start + 1; i2 < end; ++i2) {
            DomainVariable B = a[i2];
            for (int j = i2; j > start && a[j - 1].compareTo(B) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = B;
        }
    }

    public static void complexOrder(DomainReference a, DomainComponent classID, int elementsToSort, boolean sortOrder, Method compare) {
        int index = a.index;
        DomainOrder.complexOrder(a.array, classID, index, elementsToSort, sortOrder, compare);
        a.value = a.array[index];
    }

    public static void complexOrder(DomainVariable[] a, DomainComponent classID, int start, int elementsToSort, boolean sortOrder, Method compare) {
        if (sortOrder) {
            DomainOrder.sortForward(a, classID, start, elementsToSort, compare);
        } else {
            DomainOrder.sortReverse(a, classID, start, elementsToSort, compare);
        }
        DomainOrder.fixIndices(a);
    }

    private static void sortForward(DomainVariable[] a, DomainComponent classID, int start, int elementsToSort, Method compare) {
        int end = start + elementsToSort;
        try {
            for (int i2 = start + 1; i2 < end; ++i2) {
                DomainVariable B = a[i2];
                for (int j = i2; j > start && (Integer)compare.invoke((Object)classID, a[j - 1], B) > 0; --j) {
                    a[j] = a[j - 1];
                }
                a[j] = B;
            }
        }
        catch (Exception e) {
            throw new DomainException("sortForward: Invalid compare routine in order statement");
        }
    }

    private static void sortReverse(DomainVariable[] a, DomainComponent classID, int start, int elementsToSort, Method compare) {
        int end = start + elementsToSort;
        try {
            for (int i2 = start + 1; i2 < end; ++i2) {
                DomainVariable B = a[i2];
                for (int j = i2; j > start && (Integer)compare.invoke((Object)classID, a[j - 1], B) < 0; --j) {
                    a[j] = a[j - 1];
                }
                a[j] = B;
            }
        }
        catch (IllegalArgumentException e) {
            throw new DomainException("other");
        }
        catch (Exception e) {
            throw new DomainException("sortReverse: Invalid compare routine in order statement");
        }
    }

    public static void codeOrder(DomainCodeQuery l, DomainComponent classID, int key, boolean sortOrder, Method compare) {
        if (l.count() != 0) {
            DomainListEntry e;
            DomainList dest = l.getList();
            ArrayList<DomainListEntry> local = new ArrayList<DomainListEntry>(l.count());
            while ((e = l.next()) != null) {
                e.remove();
                local.add(e);
            }
            DomainOrder.codeSort(local, classID, key, sortOrder, compare);
            for (int i2 = local.size() - 1; i2 >= 0; --i2) {
                e = (DomainListEntry)local.get(i2);
                if (dest.getFirst() != null) {
                    e.insert(dest.getFirst());
                    continue;
                }
                dest.append(e);
            }
        }
    }

    public static void codeOrder(DomainList l, DomainComponent classID, int key, boolean sortOrder, Method compare) {
        if (l.count() != 0) {
            DomainListEntry e;
            ArrayList<DomainListEntry> local = new ArrayList<DomainListEntry>(l.count());
            for (e = l.getFirst(); e != null; e = e.getNext()) {
                e.remove();
                local.add(e);
            }
            DomainOrder.codeSort(local, classID, key, sortOrder, compare);
            for (int i2 = 0; i2 < local.size(); ++i2) {
                e = (DomainListEntry)local.get(i2);
                l.append(e);
            }
        }
    }

    private static void codeSort(ArrayList l, DomainComponent classID, int key, boolean sortOrder, Method compare) {
        if (compare != null) {
            if (sortOrder) {
                DomainOrder.complexCodeSortForward(l, classID, key, compare);
            } else {
                DomainOrder.complexCodeSortReverse(l, classID, key, compare);
            }
        } else if (sortOrder) {
            DomainOrder.simpleCodeSortForward(l, classID, key);
        } else {
            DomainOrder.simpleCodeSortReverse(l, classID, key);
        }
    }

    private static void simpleCodeSortForward(ArrayList l, DomainComponent classID, int key) {
        Integer ikey = DomainListEntry.instrumentAttrKey(classID._classID, key);
        int listSize = l.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            int j;
            DomainListEntry B = (DomainListEntry)l.get(i2);
            for (j = i2; j > 0 && DomainOrder.compareAttributes(classID, key, ikey, l.get(j - 1), B) > 0; --j) {
                l.set(j, l.get(j - 1));
            }
            l.set(j, B);
        }
    }

    private static void simpleCodeSortReverse(ArrayList l, DomainComponent classID, int key) {
        Integer ikey = DomainListEntry.instrumentAttrKey(classID._classID, key);
        int listSize = l.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            int j;
            DomainListEntry B = (DomainListEntry)l.get(i2);
            for (j = i2; j > 0 && DomainOrder.compareAttributes(classID, key, ikey, l.get(j - 1), B) < 0; --j) {
                l.set(j, l.get(j - 1));
            }
            l.set(j, B);
        }
    }

    private static int compareAttributes(DomainComponent comp, int key, Integer ikey, Object a, Object b) {
        DomainVariable A = (DomainVariable)((DomainListEntry)a).getAttribute(comp, key, ikey, false);
        DomainVariable B = (DomainVariable)((DomainListEntry)b).getAttribute(comp, key, ikey, false);
        return A.compareTo(B);
    }

    private static void complexCodeSortForward(ArrayList l, DomainComponent classID, int key, Method compare) {
        int listSize = l.size();
        try {
            for (int i2 = 0; i2 < listSize; ++i2) {
                int j;
                DomainListEntry B = (DomainListEntry)l.get(i2);
                for (j = i2; j > 0 && (Integer)compare.invoke((Object)classID, ((DomainListEntry)l.get(j - 1)).getAttribute(classID, key, false), B.getAttribute(classID, key, false)) > 0; --j) {
                    l.set(j, l.get(j - 1));
                }
                l.set(j, B);
            }
        }
        catch (Exception e) {
            throw new DomainException("complexCodeSortForward: Invalid compare routine in order statement");
        }
    }

    private static void complexCodeSortReverse(ArrayList l, DomainComponent classID, int key, Method compare) {
        int listSize = l.size();
        try {
            for (int i2 = 0; i2 < listSize; ++i2) {
                int j;
                DomainListEntry B = (DomainListEntry)l.get(i2);
                for (j = i2; j > 0 && (Integer)compare.invoke((Object)classID, ((DomainListEntry)l.get(j - 1)).getAttribute(classID, key, false), B.getAttribute(classID, key, false)) < 0; --j) {
                    l.set(j, l.get(j - 1));
                }
                l.set(j, B);
            }
        }
        catch (Exception e) {
            throw new DomainException("complexCodeSortReverse: Invalid compare routine in order statement");
        }
    }

    private static void fixIndices(DomainVariable[] a) {
        int length = a.length;
        for (int i2 = 0; i2 < length; ++i2) {
            a[i2].DVIndex = i2;
        }
    }
}

