/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public final class OSEnvironment {
    private static final String HOSTNAME;
    private static final String ENVPATHDEL;
    private static Properties envVars;
    private static boolean isWindows;
    private static boolean isUnix;

    private OSEnvironment() {
    }

    private static Properties readEnvironment(String cmd) {
        Process p = null;
        Properties env = new Properties();
        Runtime r = Runtime.getRuntime();
        String OS2 = System.getProperty("os.name").toLowerCase();
        try {
            p = r.exec(cmd);
        }
        catch (IOException e) {
            System.err.println("WARNING: Failure to read environment variables (cmd: '" + cmd + "')");
        }
        if (p != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    env.setProperty(key.toUpperCase(), value);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return env;
    }

    public static Properties get() {
        return (Properties)envVars.clone();
    }

    public static String getProperty(String key) {
        return envVars.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        String val = envVars.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    public static String getHostname() {
        return HOSTNAME;
    }

    public static String getEnvPathDelim() {
        return ENVPATHDEL;
    }

    public static void main(String[] args) {
        try {
            Properties p = OSEnvironment.get();
            p.list(System.out);
            System.out.println("the current value of TEMP is : " + p.getProperty("TEMP"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        String cmd;
        isWindows = false;
        isUnix = false;
        String OS2 = System.getProperty("os.name").toLowerCase();
        String ver = System.getProperty("os.version");
        if (OS2.indexOf("windows 9") > -1) {
            HOSTNAME = "win32";
            cmd = "command.com /c set";
            isWindows = true;
        } else if (OS2.indexOf("nt") > -1) {
            HOSTNAME = "win32";
            cmd = "cmd.exe /c set";
            isWindows = true;
        } else if (OS2.indexOf("2000") > -1) {
            HOSTNAME = "win32";
            cmd = "cmd.exe /c set";
            isWindows = true;
        } else if (OS2.indexOf("xp") > -1) {
            HOSTNAME = "win32";
            cmd = "cmd.exe /c set";
            isWindows = true;
        } else if (OS2.indexOf("windowsce") > -1) {
            HOSTNAME = "win32";
            cmd = "cmd.exe /c set";
            isWindows = true;
        } else if (OS2.indexOf("2003") > -1 || OS2.indexOf("2008") > -1 || OS2.indexOf("2012") > -1) {
            HOSTNAME = "win32";
            cmd = "cmd.exe /c set";
            isWindows = true;
        } else if (OS2.indexOf("vista") > -1 || OS2.indexOf("windows 7") > -1 || OS2.indexOf("windows 8") > -1) {
            HOSTNAME = "win32";
            cmd = "cmd.exe /c set";
            isWindows = true;
        } else if (OS2.indexOf("linux") > -1) {
            HOSTNAME = "Linux";
            cmd = "env";
            isUnix = true;
        } else if (OS2.indexOf("sunos") > -1) {
            HOSTNAME = "SunOS-" + ver.substring(2);
            cmd = "/bin/env";
            isUnix = true;
        } else if (OS2.indexOf("unix") > -1) {
            HOSTNAME = "Unix";
            cmd = "/bin/env";
            isUnix = true;
        } else if (OS2.indexOf("aix") > -1) {
            HOSTNAME = "AIX-" + ver;
            cmd = "/bin/env";
            isUnix = true;
        } else if (OS2.indexOf("hp-ux") > -1) {
            HOSTNAME = "HP-UX " + ver;
            cmd = "/bin/env";
            isUnix = true;
        } else {
            HOSTNAME = "Unix";
            cmd = "/bin/env";
            isUnix = true;
        }
        ENVPATHDEL = isWindows ? ";" : ":";
        envVars = OSEnvironment.readEnvironment(cmd);
    }
}

