/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.ec.EcQuark;
import com.mmmhis.domain.le.LEHandle;
import com.mmmhis.domain.table.TBLConvert;
import java.io.File;
import java.io.IOException;

public class TestCVT {
    private static final int CVT_CTL_FORMAT = 0;
    private static final int CVT_TBL_FORMAT = 1;
    private static final int ARG_ITYPE = 0;
    private static final int ARG_INPUT = 1;
    private static final int ARG_OTYPE = 2;
    private static final int ARG_OUTPUT = 3;
    private static final int ARG_COUNT = 4;

    public static void main(String[] args) {
        int rc;
        int outputType;
        int inputType;
        if (args.length < 4) {
            System.err.println("usage: {C|T} input_file {C|T} output_file");
            return;
        }
        switch (args[0].charAt(0)) {
            case 'C': 
            case 'c': {
                inputType = 0;
                break;
            }
            case 'T': 
            case 't': {
                inputType = 1;
                break;
            }
            default: {
                System.err.println("Input type " + args[0] + " not recognized");
                return;
            }
        }
        String input = args[1];
        switch (args[2].charAt(0)) {
            case 'C': 
            case 'c': {
                outputType = 0;
                break;
            }
            case 'T': 
            case 't': {
                outputType = 1;
                break;
            }
            default: {
                System.err.println("Output type " + args[2] + " not recognized");
                return;
            }
        }
        String output = args[3];
        if (inputType == outputType) {
            System.err.println("Input same type as output.  Just copy it.");
        }
        long begin = System.currentTimeMillis();
        switch (inputType) {
            case 0: {
                try {
                    File tempFile = File.createTempFile("dvm", null, new File("."));
                    rc = TBLConvert.convertCtlToTbl(input, tempFile);
                    tempFile.renameTo(new File(output));
                }
                catch (IOException ex) {
                    rc = 555;
                }
                break;
            }
            case 1: {
                rc = LEHandle.convertTblToCtl(input, output, new EcQuark());
                break;
            }
            default: {
                rc = 555;
            }
        }
        long end = System.currentTimeMillis();
        System.err.println("Total Time: " + (end - begin));
        if (rc != 0) {
            System.err.println("Input error: " + rc);
        }
    }
}

