/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainArray;
import com.mmmhis.domain.DomainBit;
import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainCode;
import com.mmmhis.domain.DomainCurrency;
import com.mmmhis.domain.DomainDate;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainFixedString;
import com.mmmhis.domain.DomainFloat;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.table.TBLLookupStack;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLTable;
import java.util.Arrays;
import java.util.Stack;

public final class TBLCursor {
    public static final int TBL_RECNO_BRANCH_LENGTH = 8;
    public static final int TblCS_FIELDS = 1;
    public static final int TblCS_LOADED = 2;
    public static final int TblCS_POSITIONED = 4;
    TBLTable table;
    TBLTable index;
    int pageoff;
    int rowoff;
    int ixpageoff;
    int ixrowoff;
    int status;
    int recno;
    int totslen;
    int newslen;
    int brbuflen;
    int valuecols;
    int row;
    byte[] unmappedRowbuf;
    DomainByteArrayFileMap mappedRowbuf;
    byte[] buffer;
    byte[] brbuf;
    DomainString[] string;
    DomainVariable[] input;
    int valueIndex;
    byte[] changed;
    public byte[] bitStrs;
    int[] xlate;
    TBLLookupStack rstack = new TBLLookupStack();

    public TBLCursor() {
    }

    public TBLCursor(TBLTable master, int[] xlate) {
        this.open(master, xlate);
    }

    public boolean isTrue() {
        return this.buffer != null;
    }

    public void open(TBLTable master, int[] xlate) {
        this.table = master;
        this.buffer = new byte[master.leafRowLen];
        this.xlate = xlate;
        int maxbrlen = 8;
        int maxncols = master.numCols;
        TBLTable index = master.nextIndex;
        while (index != null) {
            if (index.leafRowLen > maxbrlen) {
                maxbrlen = index.leafRowLen;
            }
            if (index.numCols > maxncols) {
                maxncols = index.numCols;
            }
            index = index.nextIndex;
        }
        this.brbuflen = 2 * maxbrlen;
        this.brbuf = new byte[this.brbuflen];
        this.valuecols = maxncols;
        this.input = new DomainVariable[maxncols];
        this.changed = new byte[maxncols];
        if (master.strCount != 0) {
            this.string = new DomainString[master.strCount];
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public TBLTable getTable() {
        return this.table;
    }

    public void setTable(TBLTable _table) {
        this.table = _table;
    }

    public void free() {
        this.buffer = null;
        this.brbuf = null;
        this.changed = null;
        this.string = null;
    }

    int prepare(TBLTable _table, boolean flat) {
        int depth = 0;
        int bufIndex = 0;
        int fmtIndex = 0;
        Stack<Object> depth_stack = new Stack<Object>();
        byte[] buf = (_table.tblFlags & 8) == 8 ? this.buffer : this.brbuf;
        Arrays.fill(buf, 0, _table.leafRowLen, (byte)0);
        this.valueIndex = 0;
        byte[] fmt = _table.colForm;
        int strIx = 0;
        this.totslen = 0;
        block22: do {
            switch (fmt[fmtIndex++]) {
                case 0: {
                    --depth;
                    if (flat || depth_stack.empty()) continue block22;
                    this.valueIndex = (Integer)depth_stack.pop();
                    this.input = (DomainVariable[])depth_stack.pop();
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    ((DomainBit)this.input[this.valueIndex]).getValue(buf, bufIndex);
                    ++this.valueIndex;
                    bufIndex += len;
                    len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 12: {
                    ++depth;
                    if (flat) break;
                    depth_stack.push(this.input);
                    depth_stack.push(new Integer(this.valueIndex + 1));
                    this.input = (DomainVariable[])((DomainArray)this.input[this.valueIndex]).getArray();
                    this.valueIndex = 0;
                    break;
                }
                case 11: {
                    ++depth;
                    if (flat) break;
                    depth_stack.push(this.input);
                    depth_stack.push(new Integer(this.valueIndex + 1));
                    this.input = this.input[this.valueIndex].getColumns();
                    this.valueIndex = 0;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: {
                    int iVal = this.input[this.valueIndex] != null ? ((DomainInteger)this.input[this.valueIndex]).getValue() : 0;
                    ++this.valueIndex;
                    TBLTable.putByte(buf, bufIndex, (byte)iVal);
                    ++bufIndex;
                    break;
                }
                case 2: {
                    int iVal = this.input[this.valueIndex] != null ? ((DomainInteger)this.input[this.valueIndex]).getValue() : 0;
                    ++this.valueIndex;
                    TBLTable.putShort(buf, bufIndex, (short)iVal);
                    bufIndex += 2;
                    break;
                }
                case 3: {
                    int iVal = this.input[this.valueIndex] != null ? ((DomainInteger)this.input[this.valueIndex]).getValue() : 0;
                    ++this.valueIndex;
                    TBLTable.putMedium(buf, bufIndex, iVal);
                    bufIndex += 3;
                    break;
                }
                case 7: {
                    long dVal = this.input[this.valueIndex] != null ? ((DomainDate)this.input[this.valueIndex]).getValue() : 0L;
                    ++this.valueIndex;
                    TBLTable.putLong(buf, bufIndex, dVal);
                    bufIndex += 4;
                    break;
                }
                case 4: {
                    int iVal = this.input[this.valueIndex] != null ? ((DomainInteger)this.input[this.valueIndex]).getValue() : 0;
                    ++this.valueIndex;
                    TBLTable.putLong(buf, bufIndex, (long)iVal);
                    bufIndex += 4;
                    break;
                }
                case 6: {
                    double fVal = this.input[this.valueIndex] != null ? ((DomainFloat)this.input[this.valueIndex]).getValue() : 0.0;
                    ++this.valueIndex;
                    TBLTable.putDouble(buf, bufIndex, fVal);
                    bufIndex += 8;
                    break;
                }
                case 9: {
                    double fVal = this.input[this.valueIndex] != null ? ((DomainCurrency)this.input[this.valueIndex]).getValue() : 0.0;
                    ++this.valueIndex;
                    TBLTable.putDouble(buf, bufIndex, fVal);
                    bufIndex += 8;
                    break;
                }
                case 5: 
                case 8: {
                    DomainString str = (DomainString)this.input[this.valueIndex];
                    ++this.valueIndex;
                    if (str != null) {
                        this.string[strIx] = str;
                        this.totslen += str.length() + 1;
                    } else {
                        this.string[strIx] = new DomainString("");
                        ++this.totslen;
                    }
                    ++strIx;
                    break;
                }
                case 15: {
                    double fVal = this.input[this.valueIndex] != null ? ((DomainFloat)this.input[this.valueIndex]).getValue() : 0.0;
                    ++this.valueIndex;
                    TBLTable.putLong(buf, bufIndex, (long)TBLTable.flt2Int(fVal, TBLTable.getShort(fmt, fmtIndex)));
                    fmtIndex += 6;
                    bufIndex += 4;
                    break;
                }
                case 16: {
                    int fldLen;
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 6;
                    DomainString str = (DomainString)this.input[this.valueIndex];
                    ++this.valueIndex;
                    int n = fldLen = str != null ? str.length() : 0;
                    if (fldLen > len) {
                        fldLen = len;
                    }
                    for (int i2 = 0; i2 < fldLen; ++i2) {
                        buf[bufIndex + i2] = (byte)Character.toUpperCase(str.charAt(i2));
                    }
                    if (fldLen < len) {
                        Arrays.fill(buf, bufIndex + fldLen, bufIndex + len, (byte)TBLTable.convertChar(32, this.xlate));
                    }
                    bufIndex += len;
                    break;
                }
                case 13: {
                    int fldLen;
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 2;
                    DomainString str = (DomainString)this.input[this.valueIndex];
                    ++this.valueIndex;
                    int n = fldLen = str != null ? str.length() : 0;
                    if (fldLen > len) {
                        fldLen = len;
                    }
                    if (fldLen != 0) {
                        System.arraycopy(str.toByteArray(), 0, buf, bufIndex, fldLen);
                    }
                    if (fldLen < len) {
                        Arrays.fill(buf, bufIndex + fldLen, bufIndex + len, (byte)TBLTable.convertChar(32, this.xlate));
                    }
                    bufIndex += len;
                    break;
                }
                case 21: {
                    int fldLen;
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 2;
                    DomainFixedString fstr = (DomainFixedString)this.input[this.valueIndex];
                    ++this.valueIndex;
                    int n = fldLen = fstr != null ? fstr.length() : 0;
                    if (fldLen > len) {
                        fldLen = len;
                    }
                    if (fldLen != 0) {
                        System.arraycopy(fstr.toByteArray(), 0, buf, bufIndex, fldLen);
                    }
                    if (fldLen < len) {
                        Arrays.fill(buf, bufIndex + fldLen, bufIndex + len, (byte)TBLTable.convertChar(32, this.xlate));
                    }
                    bufIndex += len;
                }
            }
        } while (depth > 0);
        this.status |= 2;
        return 0;
    }

    public int unload(DomainVariable[] variables, boolean flat) {
        int depth = 0;
        int fmtIndex = 0;
        Stack<Object> depth_stack = new Stack<Object>();
        if ((this.status & 4) == 0) {
            return 42;
        }
        int rowptr = this.row;
        this.valueIndex = 0;
        byte[] fmt = this.table.colForm;
        int strix = 0;
        block22: do {
            switch (fmt[fmtIndex++]) {
                case 0: {
                    --depth;
                    if (flat || depth_stack.empty()) continue block22;
                    this.valueIndex = (Integer)depth_stack.pop();
                    variables = (DomainVariable[])depth_stack.pop();
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    if (this.mappedRowbuf != null) {
                        ((DomainBit)variables[this.valueIndex++]).setValue(this.mappedRowbuf, rowptr);
                    } else {
                        ((DomainBit)variables[this.valueIndex++]).setValue(this.unmappedRowbuf, rowptr);
                    }
                    rowptr += TBLTable.getShort(fmt, fmtIndex);
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 12: {
                    ++depth;
                    if (flat) break;
                    depth_stack.push(variables);
                    depth_stack.push(new Integer(this.valueIndex + 1));
                    variables = (DomainVariable[])((DomainArray)variables[this.valueIndex]).getArray();
                    this.valueIndex = 0;
                    break;
                }
                case 11: {
                    ++depth;
                    if (flat) break;
                    depth_stack.push(variables);
                    depth_stack.push(new Integer(this.valueIndex + 1));
                    variables = variables[this.valueIndex].getColumns();
                    this.valueIndex = 0;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: {
                    if (this.mappedRowbuf != null) {
                        ((DomainInteger)variables[this.valueIndex++]).setValue(TBLTable.getByte(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainInteger)variables[this.valueIndex++]).setValue(TBLTable.getByte(this.unmappedRowbuf, rowptr));
                    }
                    ++rowptr;
                    break;
                }
                case 2: {
                    if (this.mappedRowbuf != null) {
                        ((DomainInteger)variables[this.valueIndex++]).setValue(TBLTable.getShort(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainInteger)variables[this.valueIndex++]).setValue(TBLTable.getShort(this.unmappedRowbuf, rowptr));
                    }
                    rowptr += 2;
                    break;
                }
                case 3: {
                    if (this.mappedRowbuf != null) {
                        ((DomainInteger)variables[this.valueIndex++]).setValue(TBLTable.getMedium(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainInteger)variables[this.valueIndex++]).setValue(TBLTable.getMedium(this.unmappedRowbuf, rowptr));
                    }
                    rowptr += 3;
                    break;
                }
                case 4: {
                    if (this.mappedRowbuf != null) {
                        ((DomainInteger)variables[this.valueIndex++]).setValue((int)TBLTable.getLong(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainInteger)variables[this.valueIndex++]).setValue((int)TBLTable.getLong(this.unmappedRowbuf, rowptr));
                    }
                    rowptr += 4;
                    break;
                }
                case 7: {
                    if (this.mappedRowbuf != null) {
                        ((DomainDate)variables[this.valueIndex++]).setValue((int)TBLTable.getLong(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainDate)variables[this.valueIndex++]).setValue((int)TBLTable.getLong(this.unmappedRowbuf, rowptr));
                    }
                    rowptr += 4;
                    break;
                }
                case 6: 
                case 9: {
                    if (this.mappedRowbuf != null) {
                        ((DomainFloat)variables[this.valueIndex++]).setValue(TBLTable.getDouble(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainFloat)variables[this.valueIndex++]).setValue(TBLTable.getDouble(this.unmappedRowbuf, rowptr));
                    }
                    rowptr += 8;
                    break;
                }
                case 5: {
                    ((DomainString)variables[this.valueIndex++]).setValue(this.string[strix]);
                    ++strix;
                    break;
                }
                case 8: {
                    ((DomainCode)variables[this.valueIndex++]).setValue(this.string[strix]);
                    ++strix;
                    break;
                }
                case 15: {
                    if (this.mappedRowbuf != null) {
                        ((DomainFloat)variables[this.valueIndex++]).setValue(TBLTable.getLong(this.mappedRowbuf, rowptr));
                    } else {
                        ((DomainFloat)variables[this.valueIndex++]).setValue(TBLTable.getLong(this.unmappedRowbuf, rowptr));
                    }
                    fmtIndex += 6;
                    rowptr += 4;
                    break;
                }
                case 16: {
                    int i2;
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 6;
                    char blank = TBLTable.convertChar(32, this.xlate);
                    if (this.mappedRowbuf != null) {
                        for (i2 = rowptr; i2 < rowptr + len && this.mappedRowbuf.getByte(i2) != blank; ++i2) {
                        }
                        ((DomainString)variables[this.valueIndex++]).setValue(this.mappedRowbuf, rowptr, i2 - rowptr);
                    } else {
                        for (i2 = rowptr; i2 < rowptr + len && this.unmappedRowbuf[i2] != blank; ++i2) {
                        }
                        ((DomainString)variables[this.valueIndex++]).setValue(this.unmappedRowbuf, rowptr, i2 - rowptr);
                    }
                    rowptr += len;
                    break;
                }
                case 13: {
                    int i2;
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 2;
                    char blank = TBLTable.convertChar(32, this.xlate);
                    if (this.mappedRowbuf != null) {
                        for (i2 = (int)len; i2 > 0 && this.mappedRowbuf.getByte(i2 + rowptr - 1) == blank; --i2) {
                        }
                        ((DomainString)variables[this.valueIndex++]).setValue(this.mappedRowbuf, rowptr, i2);
                    } else {
                        for (i2 = (int)len; i2 > 0 && this.unmappedRowbuf[i2 + rowptr - 1] == blank; --i2) {
                        }
                        ((DomainString)variables[this.valueIndex++]).setValue(this.unmappedRowbuf, rowptr, i2);
                    }
                    rowptr += len;
                    break;
                }
                case 21: {
                    short len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 2;
                    if (this.mappedRowbuf != null) {
                        ((DomainFixedString)variables[this.valueIndex++]).setValue(this.mappedRowbuf, rowptr, (int)len);
                    } else {
                        ((DomainFixedString)variables[this.valueIndex++]).setValue(this.unmappedRowbuf, rowptr, (int)len);
                    }
                    rowptr += len;
                }
            }
        } while (depth > 0);
        this.status |= 1;
        return 0;
    }

    public DomainVariable[] newVars() {
        int depth = 0;
        int fmtIndex = 0;
        DomainVariable[] variables = new DomainVariable[this.table.numCols];
        this.valueIndex = 0;
        byte[] fmt = this.table.colForm;
        do {
            switch (fmt[fmtIndex++]) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    byte len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    fmtIndex += 4;
                    int bits = 0;
                    while (fmt[fmtIndex] != 0) {
                        ++bits;
                        fmtIndex += 4 + fmt[fmtIndex + 3];
                    }
                    ++fmtIndex;
                    variables[this.valueIndex++] = new DomainBit(bits);
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    variables[this.valueIndex++] = new DomainInteger();
                    break;
                }
                case 7: {
                    variables[this.valueIndex++] = new DomainDate();
                    break;
                }
                case 6: {
                    variables[this.valueIndex++] = new DomainFloat();
                    break;
                }
                case 9: {
                    variables[this.valueIndex++] = new DomainCurrency();
                    break;
                }
                case 5: {
                    variables[this.valueIndex++] = new DomainString();
                    break;
                }
                case 8: {
                    break;
                }
                case 15: {
                    variables[this.valueIndex++] = new DomainFloat();
                    fmtIndex += 6;
                    break;
                }
                case 16: {
                    variables[this.valueIndex++] = new DomainString();
                    fmtIndex += 6;
                    break;
                }
                case 13: {
                    variables[this.valueIndex++] = new DomainString();
                    fmtIndex += 2;
                }
            }
        } while (depth > 0);
        return variables;
    }

    public int unloadType(int valueIndex) {
        return this.table.unloadType(valueIndex);
    }

    public int unloadWidth(int valueIndex) {
        return this.table.unloadWidth(valueIndex);
    }

    public int unloadFieldValue(DomainEnvironment env, DomainVariable[] variables, int valueIndex, DomainVariable var, String defdate) {
        int depth = 0;
        int fmtIndex = 0;
        int fieldIndex = 0;
        byte[] fmt = this.table.colForm;
        do {
            byte fmtval = fmt[fmtIndex++];
            switch (fmtval) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    if (fieldIndex++ == valueIndex) {
                        if (var instanceof DomainBit && ((DomainBit)var).getNumBits() == ((DomainBit)variables[valueIndex]).getNumBits()) {
                            ((DomainBit)var).setValue((DomainBit)variables[valueIndex]);
                        } else if (var instanceof DomainString) {
                            ((DomainString)var).setValue(((DomainBit)variables[valueIndex]).toString());
                        } else {
                            return 10;
                        }
                        return 0;
                    }
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainInteger) {
                        ((DomainInteger)var).setValue((DomainInteger)variables[valueIndex]);
                    } else if (var instanceof DomainString) {
                        ((DomainString)var).setValue((DomainInteger)variables[valueIndex]);
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 7: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainDate) {
                        ((DomainDate)var).setValue((DomainDate)variables[valueIndex]);
                    } else if (var instanceof DomainString) {
                        ((DomainString)var).setValue(((DomainDate)variables[valueIndex]).toString(defdate));
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 15: {
                    fmtIndex += 6;
                }
                case 6: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainFloat) {
                        ((DomainFloat)var).setValue((DomainFloat)variables[valueIndex]);
                    } else if (var instanceof DomainString) {
                        ((DomainString)var).setValue(((DomainFloat)variables[valueIndex]).toString());
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 9: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainCurrency) {
                        ((DomainCurrency)var).setValue((DomainCurrency)variables[valueIndex]);
                    } else if (var instanceof DomainString) {
                        ((DomainString)var).setValue(((DomainCurrency)variables[valueIndex]).toString());
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 5: 
                case 13: 
                case 16: {
                    if (fieldIndex++ == valueIndex) {
                        if (!(var instanceof DomainString)) {
                            return 10;
                        }
                        ((DomainString)var).setValue(env, (DomainString)variables[valueIndex]);
                        return 0;
                    }
                    if (fmtval == 16) {
                        fmtIndex += 6;
                    }
                    if (fmtval != 13) break;
                    fmtIndex += 2;
                    break;
                }
            }
        } while (depth > 0);
        return 0;
    }

    public int loadFieldValue(DomainEnvironment env, DomainVariable[] variables, int valueIndex, DomainVariable var, String defdate) {
        int depth = 0;
        int fmtIndex = 0;
        int fieldIndex = 0;
        byte[] fmt = this.table.colForm;
        if (this.bitStrs == null) {
            int count = variables.length;
            for (int idx = 0; idx < count; ++idx) {
                variables[idx].reset();
            }
            this.bitStrs = new byte[this.table.leafRowLen];
        }
        do {
            byte fmtval = fmt[fmtIndex++];
            switch (fmtval) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    if (fieldIndex++ == valueIndex) {
                        if (var instanceof DomainBit && ((DomainBit)var).getNumBits() == ((DomainBit)variables[valueIndex]).getNumBits()) {
                            ((DomainBit)variables[valueIndex]).setValue((DomainBit)var);
                        } else if (var instanceof DomainString) {
                            ((DomainBit)variables[valueIndex]).setValue(env, (DomainString)var);
                        } else {
                            return 10;
                        }
                        return 0;
                    }
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainInteger) {
                        ((DomainInteger)variables[valueIndex]).setValue((DomainInteger)var);
                    } else if (var instanceof DomainString) {
                        ((DomainInteger)variables[valueIndex]).setValue(env, (DomainString)var);
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 7: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainDate) {
                        ((DomainDate)variables[valueIndex]).setValue((DomainDate)var);
                    } else if (var instanceof DomainString) {
                        ((DomainDate)variables[valueIndex]).setValue(env, (DomainString)var, defdate);
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 15: {
                    fmtIndex += 6;
                }
                case 6: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainFloat) {
                        ((DomainFloat)variables[valueIndex]).setValue((DomainFloat)var);
                    } else if (var instanceof DomainString) {
                        ((DomainFloat)variables[valueIndex]).setValue(env, (DomainString)var);
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 9: {
                    if (fieldIndex++ != valueIndex) break;
                    if (var instanceof DomainCurrency) {
                        ((DomainCurrency)variables[valueIndex]).setValue((DomainCurrency)var);
                    } else if (var instanceof DomainString) {
                        ((DomainCurrency)variables[valueIndex]).setValue(env, (DomainString)var);
                    } else {
                        return 10;
                    }
                    return 0;
                }
                case 5: 
                case 13: 
                case 16: {
                    if (fieldIndex++ == valueIndex) {
                        if (!(var instanceof DomainString)) {
                            return 10;
                        }
                        ((DomainString)variables[valueIndex]).setValue(env, (DomainString)var);
                        return 0;
                    }
                    if (fmtval == 16) {
                        fmtIndex += 6;
                    }
                    if (fmtval != 13) break;
                    fmtIndex += 2;
                    break;
                }
            }
        } while (depth > 0);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compare(boolean flat) {
        int depth = 0;
        int fmtIndex = 0;
        int rowptr = this.row;
        this.valueIndex = 0;
        byte[] fmt = this.table.colForm;
        int strix = 0;
        int i2 = 0;
        this.newslen = 0;
        Arrays.fill(this.changed, 0, this.table.numCols, (byte)0);
        Stack<Object> depth_stack = new Stack<Object>();
        block19: do {
            int len;
            block62: {
                int j;
                byte[] bArr;
                switch (fmt[fmtIndex++]) {
                    case 0: {
                        --depth;
                        if (flat || depth_stack.empty()) continue block19;
                        this.valueIndex = (Integer)depth_stack.pop();
                        this.input = (DomainVariable[])depth_stack.pop();
                        continue block19;
                    }
                    case 18: {
                        fmtIndex += 2;
                        ++depth;
                        continue block19;
                    }
                    case 19: {
                        len = fmt[fmtIndex++];
                        fmtIndex += len;
                        continue block19;
                    }
                    case 20: {
                        fmtIndex += 4;
                        continue block19;
                    }
                    case 17: {
                        len = TBLTable.getShort(fmt, fmtIndex);
                        bArr = new byte[len];
                        ((DomainBit)this.input[this.valueIndex]).getValue(bArr, 0);
                        if (this.mappedRowbuf != null) {
                            break;
                        }
                        for (j = 0; j < len; ++j) {
                            if (bArr[j] == this.unmappedRowbuf[rowptr + j]) continue;
                            this.changed[i2] = 1;
                            break block62;
                        }
                        break block62;
                    }
                    case 11: 
                    case 12: {
                        ++depth;
                        if (flat) continue block19;
                        depth_stack.push(this.input);
                        depth_stack.push(new Integer(this.valueIndex + 1));
                        this.input = (DomainVariable[])((DomainArray)this.input[this.valueIndex]).getArray();
                        this.valueIndex = 0;
                        continue block19;
                    }
                    case 10: {
                        len = fmt[2];
                        fmtIndex += 3 + len;
                        continue block19;
                    }
                    case 1: {
                        if (this.mappedRowbuf != null) {
                            if (((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getByte(this.mappedRowbuf, rowptr)) {
                                this.changed[i2] = 1;
                            }
                        } else if (((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getByte(this.unmappedRowbuf, rowptr)) {
                            this.changed[i2] = 1;
                        }
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        ++i2;
                        ++rowptr;
                        continue block19;
                    }
                    case 2: {
                        if (this.mappedRowbuf != null) {
                            if (((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getShort(this.mappedRowbuf, rowptr)) {
                                this.changed[i2] = 1;
                            }
                        } else if (((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getShort(this.unmappedRowbuf, rowptr)) {
                            this.changed[i2] = 1;
                        }
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        ++i2;
                        rowptr += 2;
                        continue block19;
                    }
                    case 3: {
                        if (this.mappedRowbuf != null) {
                            if (((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getMedium(this.mappedRowbuf, rowptr)) {
                                this.changed[i2] = 1;
                            }
                        } else if (((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getMedium(this.unmappedRowbuf, rowptr)) {
                            this.changed[i2] = 1;
                        }
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        ++i2;
                        rowptr += 3;
                        continue block19;
                    }
                    case 4: 
                    case 7: {
                        if (this.mappedRowbuf != null) {
                            if ((long)((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getLong(this.mappedRowbuf, rowptr)) {
                                this.changed[i2] = 1;
                            }
                        } else if ((long)((DomainInteger)this.input[this.valueIndex]).getValue() != TBLTable.getLong(this.unmappedRowbuf, rowptr)) {
                            this.changed[i2] = 1;
                        }
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        ++i2;
                        rowptr += 4;
                        continue block19;
                    }
                    case 6: 
                    case 9: {
                        if (this.mappedRowbuf != null) {
                            if (((DomainFloat)this.input[this.valueIndex]).getValue() == TBLTable.getDouble(this.mappedRowbuf, rowptr)) {
                                this.changed[i2] = 1;
                            }
                        } else if (((DomainFloat)this.input[this.valueIndex]).getValue() == TBLTable.getDouble(this.unmappedRowbuf, rowptr)) {
                            this.changed[i2] = 1;
                        }
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        ++i2;
                        rowptr += 8;
                        continue block19;
                    }
                    case 5: 
                    case 8: {
                        DomainString str = (DomainString)this.input[this.valueIndex];
                        if (str.compareTo(this.string[strix]) != 0) {
                            this.changed[i2] = 1;
                            this.newslen += str.length() - this.string[strix].length();
                        }
                        ++strix;
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        ++i2;
                        continue block19;
                    }
                    case 15: {
                        fmtIndex += 6;
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        rowptr += 4;
                        continue block19;
                    }
                    case 16: {
                        len = TBLTable.getShort(fmt, fmtIndex);
                        fmtIndex += 6;
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        rowptr += len;
                        continue block19;
                    }
                    case 13: {
                        len = TBLTable.getShort(fmt, fmtIndex);
                        fmtIndex += 2;
                        DomainString str = (DomainString)this.input[this.valueIndex];
                        if (this.mappedRowbuf != null) {
                            if (TBLCursor.clipdiff(str.toByteArray(), 0, this.mappedRowbuf.getBytes(rowptr, len), 0, len, TBLTable.convertChar(32, this.xlate)) != 0) {
                                this.changed[i2] = 1;
                            }
                        } else if (TBLCursor.clipdiff(str.toByteArray(), 0, this.unmappedRowbuf, rowptr, len, TBLTable.convertChar(32, this.xlate)) != 0) {
                            this.changed[i2] = 1;
                        }
                        ++i2;
                        if (this.valueIndex < this.input.length) {
                            ++this.valueIndex;
                        }
                        rowptr += len;
                        continue block19;
                    }
                    case 21: {
                        len = TBLTable.getShort(fmt, fmtIndex);
                        fmtIndex += 2;
                        DomainString str = (DomainString)this.input[this.valueIndex];
                        if (this.mappedRowbuf != null) {
                            if (str.equals(new DomainString(new String(this.mappedRowbuf.getBytes(rowptr, len))))) {
                                this.changed[i2] = 1;
                            }
                        } else if (str.equals(new DomainString(new String(this.unmappedRowbuf, rowptr, len)))) {
                            this.changed[i2] = 1;
                        }
                        ++i2;
                        rowptr += len;
                        continue block19;
                    }
                    default: {
                        continue block19;
                    }
                }
                for (j = 0; j < len; ++j) {
                    if (bArr[j] == this.mappedRowbuf.getByte(rowptr + j)) continue;
                    this.changed[i2] = 1;
                    break;
                }
            }
            rowptr += len;
            if (this.valueIndex < this.input.length) {
                ++this.valueIndex;
            }
            ++i2;
            len = TBLTable.getShort(fmt, fmtIndex + 2);
            fmtIndex += len;
        } while (depth > 0);
        return 0;
    }

    static int clipdiff(byte[] pa, int indexA, byte[] pb, int indexB, int len, char blank) {
        while (indexA >= 0 && indexA < pa.length && pa[indexA] != 0 && indexB >= 0 && indexB < pb.length && pb[indexB] != 0 && len > 0) {
            if (pa[indexA] != pb[indexB]) {
                return 1;
            }
            ++indexA;
            ++indexB;
            --len;
        }
        while (len > 0) {
            if (indexA >= 0 && indexA < pa.length && pa[indexA] != 0) {
                if (pa[indexA] != blank) {
                    return 1;
                }
                ++indexA;
            }
            if (indexB >= 0 && indexB < pb.length && pb[indexB] != 0) {
                if (pb[indexB] != blank) {
                    return 1;
                }
                ++indexB;
            }
            --len;
        }
        return 0;
    }

    public int keyCheck(TBLTable index) {
        int depth = 0;
        int fmtIndex = 0;
        byte[] fmt = index.colForm;
        do {
            switch (fmt[fmtIndex++]) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    short i2 = TBLTable.getShort(fmt, fmtIndex + 2);
                    if (this.changed[i2] != 0) {
                        return -1;
                    }
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    short len = fmt[2];
                    fmtIndex += 3 + len;
                    break;
                }
                case 15: {
                    short i2 = TBLTable.getShort(fmt, fmtIndex + 4);
                    if (this.changed[i2] != 0) {
                        return -1;
                    }
                    fmtIndex += 6;
                    break;
                }
                case 16: {
                    short i2 = TBLTable.getShort(fmt, fmtIndex + 4);
                    if (this.changed[i2] != 0) {
                        return -1;
                    }
                    fmtIndex += 6;
                    break;
                }
                case 13: 
                case 21: {
                    fmtIndex += 2;
                    break;
                }
            }
        } while (depth > 0);
        return 0;
    }

    public int setValues(TBLTable _table, DomainVariable[] values) {
        if (_table == null) {
            _table = this.table;
        }
        System.arraycopy(values, 0, this.input, 0, values.length);
        for (int i2 = values.length; i2 < this.input.length; ++i2) {
            this.input[i2] = null;
        }
        this.status &= 0xFFFFFFFD;
        this.status |= 1;
        this.valueIndex = 0;
        byte[] fmt = _table.colForm;
        byte[] bitStr = this.bitStrs;
        if (bitStr == null) {
            this.bitStrs = bitStr = new byte[this.table.leafRowLen];
        }
        return 0;
    }

    public int first(DBControl dbControl, TBLTable _table) throws DomainException {
        if ((_table.tblFlags & 8) == 0 && (_table.master.tblFlags & 0x80) == 128) {
            _table = _table.master;
        }
        this.index = _table;
        TBLPage blk = _table.file.absolutePage(_table.rootOffset);
        if ((_table.tblFlags & 0x800) == 2048) {
            this.status = 4;
            this.ixrowoff = 0;
            this.recno = 0;
            this.row = blk.offset;
            if (blk.mappedBuffer != null) {
                this.mappedRowbuf = blk.mappedBuffer;
                int rec = this.row + _table.strOff;
                if ((blk.mappedBuffer.getByte(rec) & 0x80) == 128) {
                    return this.after(dbControl);
                }
            } else {
                this.unmappedRowbuf = blk.unmappedBuffer;
                int rec = this.row + _table.strOff;
                if ((blk.unmappedBuffer[rec] & 0x80) == 128) {
                    return this.after(dbControl);
                }
            }
            return 0;
        }
        while (true) {
            if (blk.getPageRecords() == 0) {
                this.status = 0;
                return 6;
            }
            if (blk.isLeaf()) {
                int rc;
                this.ixpageoff = _table.file.getPageOffset(blk);
                this.ixrowoff = 0;
                this.status = 4;
                if ((_table.tblFlags & 8) == 8) {
                    this.pageoff = this.ixpageoff;
                    this.rowoff = this.ixrowoff;
                    this.recno = 0;
                    rc = this.getRecordFromPage(dbControl);
                } else {
                    int rec = blk.body + this.ixrowoff;
                    this.recno = blk.mappedBuffer != null ? (int)TBLTable.getLong(blk.mappedBuffer, rec + _table.keyLen) : (int)TBLTable.getLong(blk.unmappedBuffer, rec + _table.keyLen);
                    rc = this.recno < 0 ? 5 : this.loadMaster(dbControl);
                }
                if (rc != 5) {
                    return rc;
                }
                return this.after(dbControl);
            }
            blk = _table.file.absolutePage(blk.getPageLower());
        }
    }

    public int last(DBControl dbControl, TBLTable _table) throws DomainException {
        if ((_table.tblFlags & 8) == 0 && (_table.master.tblFlags & 0x80) == 128) {
            _table = _table.master;
        }
        this.index = _table;
        TBLPage blk = _table.file.absolutePage(_table.rootOffset);
        if ((_table.tblFlags & 0x800) == 2048) {
            this.status = 4;
            this.recno = _table.recCount - 1;
            this.ixrowoff = this.recno * _table.leafRowLen;
            this.row = blk.offset + this.ixrowoff;
            if (blk.mappedBuffer != null) {
                this.mappedRowbuf = blk.mappedBuffer;
                int rec = this.row + _table.strOff;
                if ((blk.mappedBuffer.getByte(rec) & 0x80) == 128) {
                    return this.before(dbControl);
                }
            } else {
                this.unmappedRowbuf = blk.unmappedBuffer;
                int rec = this.row + _table.strOff;
                if ((blk.unmappedBuffer[rec] & 0x80) == 128) {
                    return this.before(dbControl);
                }
            }
            return 0;
        }
        while (true) {
            if (blk.getPageRecords() == 0) {
                this.status = 0;
                return 6;
            }
            if (blk.isLeaf()) {
                int rc;
                this.ixpageoff = _table.file.getPageOffset(blk);
                this.ixrowoff = blk.getPageRecords() * _table.leafRowLen - _table.leafRowLen;
                this.status = 4;
                if ((_table.tblFlags & 8) == 8) {
                    this.pageoff = this.ixpageoff;
                    this.rowoff = this.ixrowoff;
                    this.recno = _table.recCount - 1;
                    rc = this.getRecordFromPage(dbControl);
                } else {
                    this.recno = this.mappedRowbuf != null ? (int)TBLTable.getLong(blk.mappedBuffer, blk.body + this.ixrowoff + _table.keyLen) : (int)TBLTable.getLong(blk.unmappedBuffer, blk.body + this.ixrowoff + _table.keyLen);
                    rc = this.recno < 0 ? 5 : this.loadMaster(dbControl);
                }
                if (rc != 5) {
                    return rc;
                }
                return this.before(dbControl);
            }
            int rowlen = (_table.tblFlags & 0x80) == 128 ? _table.nextIndex.brRowLen : _table.brRowLen;
            int ixrow = blk.body + blk.getPageRecords() * rowlen;
            if (blk.mappedBuffer != null) {
                blk = _table.file.absolutePage((int)TBLTable.getLong(blk.mappedBuffer, ixrow - 4));
                continue;
            }
            blk = _table.file.absolutePage((int)TBLTable.getLong(blk.unmappedBuffer, ixrow - 4));
        }
    }

    public int after(DBControl dbControl) throws DomainException {
        boolean isMasterFlag;
        if ((this.status & 4) == 0) {
            return 32;
        }
        this.status = 4;
        TBLTable _table = this.index;
        this.ixrowoff += _table.leafRowLen;
        boolean bl = isMasterFlag = (_table.tblFlags & 8) == 8;
        if ((_table.tblFlags & 0x800) == 2048) {
            TBLPage blk = _table.file.absolutePage(_table.rootOffset);
            while (true) {
                int rec;
                ++this.recno;
                if (this.recno >= _table.recCount) {
                    return 15;
                }
                this.row = blk.offset + this.ixrowoff;
                if (blk.mappedBuffer != null) {
                    this.mappedRowbuf = blk.mappedBuffer;
                    rec = this.row + _table.strOff;
                    if ((blk.mappedBuffer.getByte(rec) & 0x80) == 0) {
                        return 0;
                    }
                } else {
                    this.unmappedRowbuf = blk.unmappedBuffer;
                    rec = this.row + _table.strOff;
                    if ((blk.unmappedBuffer[rec] & 0x80) == 0) {
                        return 0;
                    }
                }
                this.ixrowoff += _table.leafRowLen;
            }
        }
        while (true) {
            TBLPage blk = _table.file.absolutePage(this.ixpageoff);
            int endoff = blk.getPageRecords() * _table.leafRowLen;
            while (this.ixrowoff < endoff) {
                int rc;
                if (isMasterFlag) {
                    this.pageoff = this.ixpageoff;
                    this.rowoff = this.ixrowoff;
                    ++this.recno;
                    rc = this.getRecordFromPage(dbControl);
                } else {
                    int rec = blk.body + this.ixrowoff;
                    this.recno = blk.mappedBuffer != null ? (int)TBLTable.getLong(blk.mappedBuffer, rec + _table.keyLen) : (int)TBLTable.getLong(blk.unmappedBuffer, rec + _table.keyLen);
                    rc = this.recno < 0 ? 5 : this.loadMaster(dbControl);
                }
                if (rc != 5) {
                    return rc;
                }
                this.ixrowoff += _table.leafRowLen;
                blk = _table.file.absolutePage(this.ixpageoff);
            }
            int offset = blk.getPageForward();
            if (offset == 0) {
                this.index = null;
                this.ixrowoff = 0;
                this.ixpageoff = 0;
                this.status = 0;
                return 15;
            }
            this.ixpageoff = offset;
            this.ixrowoff = 0;
        }
    }

    public int before(DBControl dbControl) throws DomainException {
        if ((this.status & 4) == 0) {
            return 32;
        }
        this.status = 4;
        TBLTable _table = this.index;
        if ((_table.tblFlags & 0x800) == 2048) {
            TBLPage blk = _table.file.absolutePage(_table.rootOffset);
            while (true) {
                int rec;
                if (this.recno <= 0) {
                    return 15;
                }
                --this.recno;
                this.ixrowoff -= _table.leafRowLen;
                this.row = blk.offset + this.ixrowoff;
                if (blk.mappedBuffer != null) {
                    this.mappedRowbuf = blk.mappedBuffer;
                    rec = this.row + _table.strOff;
                    if ((blk.mappedBuffer.getByte(rec) & 0x80) != 0) continue;
                    return 0;
                }
                this.unmappedRowbuf = blk.unmappedBuffer;
                rec = this.row + _table.strOff;
                if ((blk.unmappedBuffer[rec] & 0x80) == 0) break;
            }
            return 0;
        }
        TBLPage blk = _table.file.absolutePage(this.ixpageoff);
        while (true) {
            if (this.ixrowoff >= _table.leafRowLen) {
                int rc;
                this.ixrowoff -= _table.leafRowLen;
                if ((_table.tblFlags & 8) == 8) {
                    this.pageoff = this.ixpageoff;
                    this.rowoff = this.ixrowoff;
                    ++this.recno;
                    rc = this.getRecordFromPage(dbControl);
                } else {
                    int rec = blk.body + this.ixrowoff;
                    this.recno = blk.mappedBuffer != null ? (int)TBLTable.getLong(blk.mappedBuffer, rec + _table.keyLen) : (int)TBLTable.getLong(blk.unmappedBuffer, rec + _table.keyLen);
                    rc = this.recno < 0 ? 5 : this.loadMaster(dbControl);
                }
                if (rc != 5) {
                    return rc;
                }
                blk = _table.file.absolutePage(this.ixpageoff);
                continue;
            }
            int offset = blk.getPageLower();
            if (offset == 0) {
                this.index = null;
                this.ixrowoff = 0;
                this.ixpageoff = 0;
                this.status = 0;
                return 15;
            }
            blk = _table.file.absolutePage(offset);
            this.ixpageoff = offset;
            this.ixrowoff = blk.getPageRecords() * this.table.leafRowLen;
        }
    }

    public int lookup(DBControl dbControl, TBLTable _table, boolean flat) throws DomainException {
        int hilo;
        int rc = 0;
        this.valueIndex = 0;
        if ((_table.tblFlags & 8) == 0 && (_table.master.tblFlags & 0x80) == 128) {
            _table = _table.master;
        }
        this.index = _table;
        if ((this.status & 2) == 0 && (this.status & 1) == 1) {
            if ((_table.tblFlags & 0x80) == 128) {
                rc = this.prepare(_table.nextIndex, flat);
                if (rc != 0) {
                    return rc;
                }
            } else if ((_table.tblFlags & 8) == 8) {
                this.recno = ((DomainInteger)this.input[this.valueIndex]).getValue();
                TBLTable.putLong(this.brbuf, 0, (long)this.recno);
                this.status |= 2;
            } else {
                rc = this.prepare(_table, flat);
                if (rc != 0) {
                    return rc;
                }
            }
        }
        if ((this.status & 2) == 0) {
            return 31;
        }
        if ((_table.tblFlags & 0x800) == 2048) {
            return _table.lookupConsolidated(this, this.brbuf);
        }
        int tblType = (_table.tblFlags & 0x80) == 128 ? _table.nextIndex.tblType : _table.tblType;
        switch (tblType) {
            case 1: {
                hilo = _table.lookupDuplicate(dbControl, this.brbuf, this.rstack, false);
                break;
            }
            case 2: {
                hilo = _table.lookupUnique(dbControl, this.brbuf, this.rstack, false);
                break;
            }
            default: {
                hilo = _table.lookupUnique(dbControl, this.brbuf, this.rstack, false);
            }
        }
        if (hilo > 2) {
            this.status = 0;
            return hilo;
        }
        this.ixpageoff = this.rstack.pageOffset[this.rstack.ix];
        this.ixrowoff = this.rstack.dataOffset[this.rstack.ix];
        this.status |= 4;
        if ((_table.tblFlags & 8) == 8) {
            this.pageoff = this.ixpageoff;
            this.rowoff = this.ixrowoff;
            rc = this.getRecordFromPage(dbControl);
        } else {
            TBLPage blk = _table.file.absolutePage(this.ixpageoff);
            int rec = blk.body + this.ixrowoff;
            this.recno = blk.mappedBuffer != null ? (int)TBLTable.getLong(blk.mappedBuffer, rec + _table.keyLen) : (int)TBLTable.getLong(blk.unmappedBuffer, rec + _table.keyLen);
            rc = this.recno < 0 ? 5 : this.loadMaster(dbControl);
        }
        if (rc == 5 && (rc = this.after(dbControl)) == 0) {
            this.status = 4;
            return 1;
        }
        if (rc != 0) {
            this.status = 0;
        } else {
            rc = hilo;
            if (hilo != 0) {
                this.status = 0;
            }
            this.status |= 4;
        }
        return rc;
    }

    int loadMaster(DBControl dbControl) throws DomainException {
        TBLTable.putLong(this.brbuf, 0, (long)this.recno);
        TBLTable master = this.table;
        int rc = master.lookupUnique(dbControl, this.brbuf, this.rstack, false);
        if (rc != 0) {
            this.status = 0;
            return rc;
        }
        this.pageoff = this.rstack.pageOffset[this.rstack.ix];
        this.rowoff = this.rstack.dataOffset[this.rstack.ix];
        rc = this.getRecordFromPage(dbControl);
        this.status = rc == 0 || rc == 5 ? 4 : 0;
        return rc;
    }

    boolean recordFitsInPage(TBLTable _table, TBLPage blk, boolean leaf) {
        int need = leaf ? _table.leafRowLen + this.totslen : ((_table.tblFlags & 0x80) == 128 ? _table.nextIndex.brRowLen : _table.brRowLen);
        int rused = blk.getPageRowData();
        int sused = blk.getPageStrings();
        int avail = blk.getPageSize() - 16 - rused - sused;
        return need <= avail;
    }

    int putRecordInPage(TBLTable _table, TBLPage blk, int location, boolean leaf) {
        byte[] recbuf;
        int tslen;
        int lrecl;
        if (leaf) {
            lrecl = _table.leafRowLen;
            if ((_table.tblFlags & 8) == 8) {
                tslen = this.totslen;
                recbuf = this.buffer;
            } else {
                tslen = 0;
                recbuf = this.brbuf;
            }
        } else {
            lrecl = (_table.tblFlags & 0x80) == 128 ? _table.nextIndex.brRowLen : _table.brRowLen;
            tslen = 0;
            recbuf = this.brbuf;
        }
        int need = lrecl + tslen;
        int nrecs = blk.getPageRecords();
        int rused = blk.getPageRowData();
        int sused = blk.getPageStrings();
        int pagel = blk.getPageSize();
        int avail = pagel - 16 - rused - sused;
        if (need > avail) {
            return 17;
        }
        int endOfBlk = blk.body + rused;
        int shift = endOfBlk - location;
        if (blk.mappedBuffer != null) {
            if (shift > 0) {
                DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, location, blk.mappedBuffer, location + lrecl, shift);
            }
            DomainByteArrayFileMap.arraycopy(recbuf, 0, blk.mappedBuffer, location, lrecl);
        } else {
            if (shift > 0) {
                System.arraycopy(blk.unmappedBuffer, location, blk.unmappedBuffer, location + lrecl, shift);
            }
            System.arraycopy(recbuf, 0, blk.unmappedBuffer, location, lrecl);
        }
        blk.setRecords(++nrecs, leaf);
        blk.setRowData(rused += lrecl);
        if (tslen != 0) {
            sused += tslen;
            int strptr = location + this.table.strOff;
            if (blk.mappedBuffer != null) {
                TBLTable.putShort(blk.mappedBuffer, strptr, (short)sused);
                TBLTable.putShort(blk.mappedBuffer, strptr + 2, (short)tslen);
                strptr = blk.offset + (pagel - sused);
                for (int i2 = 0; i2 < this.table.strCount; ++i2) {
                    int len;
                    DomainString instr = this.string[i2];
                    int n = len = instr != null ? instr.length() : 0;
                    if (len > 0) {
                        DomainByteArrayFileMap.arraycopy(instr.toByteArray(), 0, blk.mappedBuffer, strptr, len);
                    }
                    blk.mappedBuffer.putByte(strptr + len, (byte)0);
                    strptr += len + 1;
                }
                TBLTable.putShort(blk.mappedBuffer, blk.strspace, (short)sused);
            } else {
                TBLTable.putShort(blk.unmappedBuffer, strptr, (short)sused);
                TBLTable.putShort(blk.unmappedBuffer, strptr + 2, (short)tslen);
                strptr = blk.offset + (pagel - sused);
                for (int i3 = 0; i3 < this.table.strCount; ++i3) {
                    int len;
                    DomainString instr = this.string[i3];
                    int n = len = instr != null ? instr.length() : 0;
                    if (len > 0) {
                        System.arraycopy(instr.toByteArray(), 0, blk.unmappedBuffer, strptr, len);
                    }
                    blk.unmappedBuffer[strptr + len] = 0;
                    strptr += len + 1;
                }
                TBLTable.putShort(blk.unmappedBuffer, blk.strspace, (short)sused);
            }
        }
        blk.modifiedPage();
        return 0;
    }

    int getRecordFromPage(DBControl dbControl) throws DomainException {
        TBLTable _table = this.table;
        TBLPage blk = _table.file.absolutePage(this.pageoff);
        this.row = blk.body + this.rowoff;
        if (blk.mappedBuffer != null) {
            this.mappedRowbuf = blk.mappedBuffer;
            int strptr = this.row + _table.strOff;
            if ((blk.mappedBuffer.getByte(strptr) & 0x80) != 0) {
                return 5;
            }
            if (_table.strCount == 0) {
                return 0;
            }
            int soff = TBLTable.getShort(blk.mappedBuffer, strptr) & Short.MAX_VALUE;
            this.totslen = TBLTable.getShort(blk.mappedBuffer, strptr + 2);
            strptr = blk.offset + blk.getPageSize() - soff;
            for (int i2 = 0; i2 < _table.strCount; ++i2) {
                this.string[i2] = blk.mappedBuffer.getDomainString(strptr);
                strptr += this.string[i2].length() + 1;
            }
        } else {
            this.unmappedRowbuf = blk.unmappedBuffer;
            int strptr = this.row + _table.strOff;
            if ((blk.unmappedBuffer[strptr] & 0x80) != 0) {
                return 5;
            }
            if (_table.strCount == 0) {
                return 0;
            }
            int soff = TBLTable.getShort(blk.unmappedBuffer, strptr) & Short.MAX_VALUE;
            this.totslen = TBLTable.getShort(blk.unmappedBuffer, strptr + 2);
            strptr = blk.offset + blk.getPageSize() - soff;
            for (int i3 = 0; i3 < _table.strCount; ++i3) {
                int end;
                for (end = strptr; end < blk.unmappedBuffer.length && blk.unmappedBuffer[end] != 0; ++end) {
                }
                int len = end - strptr;
                this.string[i3] = new DomainString(blk.unmappedBuffer, strptr, len);
                strptr += len + 1;
            }
        }
        return 0;
    }

    boolean stringFitsInPage(TBLTable _table, TBLPage blk) {
        int need = this.newslen > 0 ? this.newslen : 0;
        int rused = blk.getPageRowData();
        int sused = blk.getPageStrings();
        int avail = blk.getPageSize() - 16 - rused - sused;
        return need <= avail;
    }

    int putStringInPage(TBLTable _table, TBLPage blk, int location) {
        int recsoff = 0;
        if (!this.stringFitsInPage(_table, blk)) {
            return 17;
        }
        if (_table.strCount > 0) {
            int sused = blk.getPageStrings();
            int pagel = blk.getPageSize();
            int strptr = location + this.table.strOff;
            if (blk.mappedBuffer != null) {
                int i2;
                int ptrrec;
                int soff = TBLTable.getShort(blk.mappedBuffer, strptr) & Short.MAX_VALUE;
                if (this.newslen > 0) {
                    ptrrec = blk.body;
                    recsoff = 0;
                    if (location != ptrrec) {
                        ptrrec = location - this.table.leafRowLen;
                        recsoff = TBLTable.getShort(blk.mappedBuffer, ptrrec + this.table.strOff) & Short.MAX_VALUE;
                    }
                    if (recsoff == 0 || recsoff > soff - this.totslen) {
                        DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, pagel - sused, blk.mappedBuffer, pagel - (sused + this.newslen), sused - soff);
                        sused += this.newslen;
                        soff += this.newslen;
                        recsoff = 0;
                    }
                }
                TBLTable.putShort(blk.mappedBuffer, strptr, (short)soff);
                TBLTable.putShort(blk.mappedBuffer, strptr + 2, (short)this.totslen);
                strptr = blk.offset + (pagel - soff);
                for (i2 = 0; i2 < this.table.strCount; ++i2) {
                    int len;
                    DomainString instr = this.string[i2];
                    int n = len = instr != null ? instr.length() : 0;
                    if (len > 0) {
                        DomainByteArrayFileMap.arraycopy(instr.toByteArray(), 0, blk.mappedBuffer, strptr, len);
                    }
                    blk.mappedBuffer.putByte(strptr + len, (byte)0);
                    strptr += len + 1;
                }
                TBLTable.putShort(blk.mappedBuffer, blk.strspace, (short)sused);
                if (this.newslen > 0 && recsoff == 0) {
                    int nrecs = blk.getPageRecords();
                    ptrrec = blk.body;
                    for (i2 = 0; i2 < nrecs; ++i2) {
                        if (location != ptrrec && (recsoff = TBLTable.getShort(blk.mappedBuffer, ptrrec + this.table.strOff) & Short.MAX_VALUE) > soff - this.newslen) {
                            TBLTable.putShort(blk.mappedBuffer, ptrrec + this.table.strOff, (short)(recsoff + this.newslen));
                        }
                        ptrrec += this.table.leafRowLen;
                    }
                }
            } else {
                int i3;
                int ptrrec;
                int soff = TBLTable.getShort(blk.unmappedBuffer, strptr) & Short.MAX_VALUE;
                if (this.newslen > 0) {
                    ptrrec = blk.body;
                    recsoff = 0;
                    if (location != ptrrec) {
                        ptrrec = location - this.table.leafRowLen;
                        recsoff = TBLTable.getShort(blk.unmappedBuffer, ptrrec + this.table.strOff) & Short.MAX_VALUE;
                    }
                    if (recsoff == 0 || recsoff > soff - this.totslen) {
                        System.arraycopy(blk.unmappedBuffer, pagel - sused, blk.unmappedBuffer, pagel - (sused + this.newslen), sused - soff);
                        sused += this.newslen;
                        soff += this.newslen;
                        recsoff = 0;
                    }
                }
                TBLTable.putShort(blk.unmappedBuffer, strptr, (short)soff);
                TBLTable.putShort(blk.unmappedBuffer, strptr + 2, (short)this.totslen);
                strptr = blk.offset + (pagel - soff);
                for (i3 = 0; i3 < this.table.strCount; ++i3) {
                    int len;
                    DomainString instr = this.string[i3];
                    int n = len = instr != null ? instr.length() : 0;
                    if (len > 0) {
                        System.arraycopy(instr.toByteArray(), 0, blk.unmappedBuffer, strptr, len);
                    }
                    blk.unmappedBuffer[strptr + len] = 0;
                    strptr += len + 1;
                }
                TBLTable.putShort(blk.unmappedBuffer, blk.strspace, (short)sused);
                if (this.newslen > 0 && recsoff == 0) {
                    int nrecs = blk.getPageRecords();
                    ptrrec = blk.body;
                    for (i3 = 0; i3 < nrecs; ++i3) {
                        if (location != ptrrec && (recsoff = TBLTable.getShort(blk.unmappedBuffer, ptrrec + this.table.strOff) & Short.MAX_VALUE) > soff - this.newslen) {
                            TBLTable.putShort(blk.unmappedBuffer, ptrrec + this.table.strOff, (short)(recsoff + this.newslen));
                        }
                        ptrrec += this.table.leafRowLen;
                    }
                }
            }
        }
        blk.modifiedPage();
        return 0;
    }

    public int getValues(byte[][] fmt) {
        if (fmt != null) {
            fmt[0] = this.table.colForm;
        }
        return 0;
    }

    public int getRecno() {
        return this.recno;
    }

    public int select(DBControl dbControl, String iName, DomainVariable[] values) throws DomainException {
        TBLTable index = this.table;
        if (iName != null && !iName.equals("row")) {
            index = index.findIndex(iName);
        }
        if (index == null) {
            return 49;
        }
        this.setValues(index, values);
        int status = this.lookup(dbControl, index, false);
        return status;
    }

    public int selectFirst(DBControl dbControl, String iName) throws DomainException {
        TBLTable local_index = this.table;
        if (iName == null && this.index != null) {
            local_index = this.index;
        } else if (iName != null && !iName.equals("row")) {
            local_index = local_index.findIndex(iName);
        }
        int status = this.first(dbControl, local_index);
        if (local_index == null) {
            return 49;
        }
        return status;
    }

    public int selectFirst(DBControl dbControl) throws DomainException {
        TBLTable index = this.table;
        int status = this.first(dbControl, index);
        if (index == null) {
            return 49;
        }
        return status;
    }

    public int selectNext(DBControl dbControl) throws DomainException {
        int status = this.after(dbControl);
        return status;
    }

    public int selectLast(DBControl dbControl, String iName) throws DomainException {
        TBLTable local_index = this.table;
        if (iName == null && this.index != null) {
            local_index = this.index;
        } else if (iName != null && !iName.equals("row")) {
            local_index = local_index.findIndex(iName);
        }
        int status = this.last(dbControl, local_index);
        if (local_index == null) {
            return 49;
        }
        return status;
    }

    public int selectLast(DBControl dbControl) throws DomainException {
        if (this.index == null) {
            this.index = this.table;
        }
        int status = this.last(dbControl, this.index);
        if (this.index == null) {
            return 49;
        }
        return status;
    }

    public int selectPrevious(DBControl dbControl) throws DomainException {
        int status = this.before(dbControl);
        return status;
    }

    public int selectClose() throws DomainException {
        int status = this.table.modifiedTable();
        if (status == 0) {
            this.free();
            this.getTable().delete();
            this.setTable(null);
        }
        return status;
    }

    public int updateReplace(DBControl dbControl, boolean flat) throws DomainException {
        return this.replace(dbControl, flat);
    }

    public int updateDelete(DBControl dbControl) throws DomainException {
        return this.delete(dbControl);
    }

    public int updateInsert(DBControl dbControl, boolean flat) throws DomainException {
        return this.insert(dbControl, flat);
    }

    public int delete(DBControl dbControl) throws DomainException {
        TBLTable master = this.table;
        if ((master.tblFlags & 2) == 2) {
            return 36;
        }
        if ((master.tblFlags & 0x80) == 128) {
            return 50;
        }
        if ((this.status & 4) == 0) {
            return 31;
        }
        TBLPage blk = master.file.absolutePage(this.pageoff);
        if (this.mappedRowbuf != null) {
            DomainByteArrayFileMap.arraycopy(this.mappedRowbuf, this.row, this.buffer, 0, master.leafRowLen);
            int pdata = master.strOff;
            int count = master.strCount != 0 ? 4 : 1;
            for (int i2 = 0; i2 < count; ++i2) {
                this.buffer[pdata + i2] = 0;
            }
            pdata = this.row + master.strOff;
            this.mappedRowbuf.putByte(pdata, (byte)(this.mappedRowbuf.getByte(pdata) | 0x80));
            blk.modifiedPage();
            TBLTable indx = master.nextIndex;
            while (indx != null && indx.master == master) {
                if (indx.tblType == 2) {
                    indx.copyKeys(this);
                    int rc = indx.lookupUnique(dbControl, this.brbuf, this.rstack, false);
                    if (rc >= 6) {
                        return rc;
                    }
                    if (rc != 0) {
                        return 35;
                    }
                    blk = master.file.absolutePage(this.rstack.pageOffset[this.rstack.ix]);
                    pdata = blk.offset + 16 + this.rstack.dataOffset[this.rstack.ix] + indx.keyLen;
                    if ((int)TBLTable.getLong(blk.mappedBuffer, pdata) != this.recno) {
                        return 35;
                    }
                    TBLTable.putLong(blk.mappedBuffer, pdata, -1L);
                    blk.modifiedPage();
                }
                indx = indx.nextIndex;
            }
        } else {
            System.arraycopy(this.unmappedRowbuf, this.row, this.buffer, 0, master.leafRowLen);
            int pdata = master.strOff;
            int count = master.strCount != 0 ? 4 : 1;
            for (int i3 = 0; i3 < count; ++i3) {
                this.buffer[pdata + i3] = 0;
            }
            pdata = this.row + master.strOff;
            this.unmappedRowbuf[pdata] = (byte)(this.unmappedRowbuf[pdata] | 0x80);
            blk.modifiedPage();
            TBLTable indx = master.nextIndex;
            while (indx != null && indx.master == master) {
                if (indx.tblType == 2) {
                    indx.copyKeys(this);
                    int rc = indx.lookupUnique(dbControl, this.brbuf, this.rstack, false);
                    if (rc >= 6) {
                        return rc;
                    }
                    if (rc != 0) {
                        return 35;
                    }
                    blk = master.file.absolutePage(this.rstack.pageOffset[this.rstack.ix]);
                    pdata = blk.offset + 16 + this.rstack.dataOffset[this.rstack.ix] + indx.keyLen;
                    if ((int)TBLTable.getLong(blk.unmappedBuffer, pdata) != this.recno) {
                        return 35;
                    }
                    TBLTable.putLong(blk.unmappedBuffer, pdata, -1L);
                    blk.modifiedPage();
                }
                indx = indx.nextIndex;
            }
        }
        ++master.delCount;
        this.status &= 0xFFFFFFFB;
        return 0;
    }

    public int replace(DBControl dbControl, boolean flat) throws DomainException {
        boolean mustDelete = false;
        int strptr = 0;
        short soff = 0;
        TBLTable master = this.table;
        if ((this.table.tblFlags & 2) == 2) {
            return 36;
        }
        if ((this.status & 4) == 0) {
            return 31;
        }
        if ((this.status & 1) == 0) {
            return 31;
        }
        int rc = this.compare(flat);
        if (rc != 0) {
            return rc;
        }
        TBLPage page = master.file.absolutePage(this.pageoff);
        if (!this.stringFitsInPage(master, page)) {
            mustDelete = true;
        } else {
            TBLTable indx = master.nextIndex;
            while (indx != null) {
                rc = this.keyCheck(indx);
                if (rc > 0) {
                    return rc;
                }
                if (rc < 0) {
                    mustDelete = true;
                    break;
                }
                indx = indx.nextIndex;
            }
        }
        if (mustDelete) {
            rc = this.delete(dbControl);
            if (rc != 0) {
                return rc;
            }
            this.status = 1;
            return this.insert(dbControl, flat);
        }
        rc = this.prepare(this.table, flat);
        if (rc != 0) {
            return rc;
        }
        this.row = page.body + this.rowoff;
        if (page.mappedBuffer != null) {
            this.mappedRowbuf = page.mappedBuffer;
            if (master.strCount != 0) {
                strptr = this.row + master.strOff;
                soff = TBLTable.getShort(this.mappedRowbuf, strptr);
            }
            DomainByteArrayFileMap.arraycopy(this.buffer, 0, this.mappedRowbuf, this.row, master.leafRowLen);
            if (master.strCount != 0) {
                TBLTable.putShort(this.mappedRowbuf, strptr, soff);
                TBLTable.putShort(this.mappedRowbuf, strptr + 2, (short)this.totslen);
                rc = this.putStringInPage(master, page, this.row);
                if (rc != 0) {
                    return rc;
                }
            }
        } else {
            this.unmappedRowbuf = page.unmappedBuffer;
            if (master.strCount != 0) {
                strptr = this.row + master.strOff;
                soff = TBLTable.getShort(this.unmappedRowbuf, strptr);
            }
            System.arraycopy(this.buffer, 0, this.unmappedRowbuf, this.row, master.leafRowLen);
            if (master.strCount != 0) {
                TBLTable.putShort(this.unmappedRowbuf, strptr, soff);
                TBLTable.putShort(this.unmappedRowbuf, strptr + 2, (short)this.totslen);
                rc = this.putStringInPage(master, page, this.row);
                if (rc != 0) {
                    return rc;
                }
            }
        }
        page.modifiedPage();
        return 0;
    }

    public int insert(DBControl dbControl, boolean flat) throws DomainException {
        int rc;
        TBLTable master = this.table;
        if ((master.tblFlags & 2) == 2) {
            return 36;
        }
        if ((this.status & 2) == 0 && (this.status & 1) == 1 && (rc = this.prepare(master, flat)) != 0) {
            return rc;
        }
        if ((this.status & 2) == 0) {
            return 31;
        }
        if ((master.tblFlags & 0x80) == 128) {
            TBLTable indx = master.nextIndex;
            indx.copyKeys(this);
            if (indx.tblType == 1) {
                rc = master.lookupDuplicate(dbControl, this.brbuf, this.rstack, true);
            } else {
                rc = master.lookupUnique(dbControl, this.brbuf, this.rstack, true);
                if (rc == 0) {
                    this.pageoff = this.rstack.pageOffset[this.rstack.ix];
                    this.rowoff = this.rstack.dataOffset[this.rstack.ix];
                    this.ixpageoff = this.pageoff;
                    this.ixrowoff = this.rowoff;
                    this.index = master;
                    this.status = 4;
                    return 4;
                }
            }
            if (rc > 6) {
                return rc;
            }
            if ((rc = master.insertBase(this, this.rstack, rc)) != 0) {
                return rc;
            }
            this.ixpageoff = this.pageoff;
            this.ixrowoff = this.rowoff;
            this.index = master;
            this.status |= 4;
            return this.getRecordFromPage(dbControl);
        }
        TBLTable indx = master.nextIndex;
        while (indx != null && indx.master == master) {
            if (indx.tblType == 2) {
                indx.copyKeys(this);
                rc = indx.lookupUnique(dbControl, this.brbuf, this.rstack, false);
                if (rc > 6) {
                    return rc;
                }
                if (rc == 0) {
                    TBLPage page = master.file.absolutePage(this.rstack.pageOffset[this.rstack.ix]);
                    this.recno = page.mappedBuffer != null ? (int)TBLTable.getLong(page.mappedBuffer, page.offset + 16 + this.rstack.dataOffset[this.rstack.ix] + indx.keyLen) : (int)TBLTable.getLong(page.unmappedBuffer, page.offset + 16 + this.rstack.dataOffset[this.rstack.ix] + indx.keyLen);
                    if (this.recno >= 0) {
                        this.index = indx;
                        this.ixpageoff = this.rstack.pageOffset[this.rstack.ix];
                        this.ixrowoff = this.rstack.dataOffset[this.rstack.ix];
                        TBLTable.putLong(this.brbuf, 0, (long)this.recno);
                        rc = master.lookupUnique(dbControl, this.brbuf, this.rstack, false);
                        if (rc != 0) {
                            return rc;
                        }
                        this.pageoff = this.rstack.pageOffset[this.rstack.ix];
                        this.rowoff = this.rstack.dataOffset[this.rstack.ix];
                        this.status = 4;
                        return 4;
                    }
                }
            }
            indx = indx.nextIndex;
        }
        this.recno = master.recCount;
        indx = master.nextIndex;
        while (indx != null && indx.master == master) {
            indx.copyKeys(this);
            rc = indx.tblType == 1 ? indx.lookupDuplicate(dbControl, this.brbuf, this.rstack, true) : indx.lookupUnique(dbControl, this.brbuf, this.rstack, true);
            if (rc > 6) {
                return rc;
            }
            if ((rc = indx.insertBase(this, this.rstack, rc)) != 0) {
                return rc;
            }
            indx = indx.nextIndex;
        }
        TBLTable.putLong(this.brbuf, 0, (long)this.recno);
        rc = master.lookupUnique(dbControl, this.brbuf, this.rstack, true);
        rc = master.insertBase(this, this.rstack, rc);
        if (rc != 0) {
            return rc;
        }
        this.ixpageoff = this.pageoff;
        this.ixrowoff = this.rowoff;
        this.index = master;
        this.status |= 4;
        return this.getRecordFromPage(dbControl);
    }

    public int numColumns() {
        return this.table.numColumns();
    }

    public int numIndices() {
        return this.table.numIndices();
    }

    public TBLTable indexFindByOffset(int index) {
        return this.table.indexFindByOffset(index);
    }

    public int recordCount() {
        if (this.table != null) {
            return this.table.recCount;
        }
        return 0;
    }

    public int rowCount() {
        if (this.table != null) {
            return this.table.recCount - this.table.delCount;
        }
        return 0;
    }

    public boolean isPositioned() {
        return (this.status & 4) != 0;
    }

    public void setIndex(TBLTable table) {
        this.index = table;
    }

    public void setFieldStatus() {
        this.status |= 1;
    }

    public byte[] getRowBuf() {
        byte[] rowBuf = null;
        rowBuf = this.mappedRowbuf != null ? this.mappedRowbuf.cacheAll() : this.unmappedRowbuf;
        return rowBuf;
    }

    public DomainByteArrayFileMap getMappedRowBuf() {
        return this.mappedRowbuf;
    }

    public byte[] getUnmappedRowBuf() {
        return this.unmappedRowbuf;
    }

    public int getRowPtr() {
        return this.row;
    }

    public DomainString getIndexString(int i2) {
        return this.string[i2];
    }
}

