/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.table.TBLPageCtl;
import com.mmmhis.domain.table.TBLTable;
import java.util.Arrays;

public final class TBLPage {
    public static final int HEADER_SIZE = 16;
    public static final int PAGE_SIZE = 4096;
    public static final int FIRST_RECORD = 16;
    public static final int DATA_SIZE = 4080;
    int offset;
    byte[] unmappedBuffer;
    DomainByteArrayFileMap mappedBuffer;
    int pagelen;
    int recspace;
    int strspace;
    int numrecs;
    int forwardpage;
    int lowerpage;
    int body;
    TBLPageCtl pageCtl;
    TBLPage mru;
    TBLPage lru;

    public TBLPage() {
        this.unmappedBuffer = new byte[4096];
        this.assignParts(this.unmappedBuffer, 0);
        this.mru = null;
        this.lru = null;
        this.initPage();
    }

    public TBLPage(boolean mapped) {
        if (mapped) {
            this.mappedBuffer = new DomainByteArrayFileMap(4096);
            this.assignParts(this.mappedBuffer, 0);
        } else {
            this.unmappedBuffer = new byte[4096];
            this.assignParts(this.unmappedBuffer, 0);
        }
    }

    public TBLPage(byte[] _buffer, int index) {
        this.unmappedBuffer = _buffer;
        this.assignParts(this.unmappedBuffer, 0);
    }

    public TBLPage(DomainByteArrayFileMap _buffer, int index) {
        this.mappedBuffer = _buffer;
        this.assignParts(this.mappedBuffer, 0);
    }

    public void assignParts(DomainByteArrayFileMap _buffer, int _offset) {
        this.mappedBuffer = _buffer;
        this.offset = _offset;
        this.pagelen = _offset;
        this.recspace = this.pagelen + 2;
        this.strspace = this.recspace + 2;
        this.numrecs = this.strspace + 2;
        this.forwardpage = this.numrecs + 2;
        this.lowerpage = this.forwardpage + 4;
        this.body = this.lowerpage + 4;
    }

    public void assignParts(byte[] _buffer, int _offset) {
        this.unmappedBuffer = _buffer;
        this.offset = _offset;
        this.pagelen = _offset;
        this.recspace = this.pagelen + 2;
        this.strspace = this.recspace + 2;
        this.numrecs = this.strspace + 2;
        this.forwardpage = this.numrecs + 2;
        this.lowerpage = this.forwardpage + 4;
        this.body = this.lowerpage + 4;
    }

    public void assignParts(int _offset) {
        if (this.mappedBuffer != null) {
            this.assignParts(this.mappedBuffer, _offset);
        } else {
            this.assignParts(this.unmappedBuffer, _offset);
        }
    }

    public void initPage() {
        this.initPage(4096);
    }

    public void initPage(int pageSize) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.fill(this.mappedBuffer, 0, pageSize, (byte)0);
            TBLTable.putShort(this.mappedBuffer, this.pagelen, (short)pageSize);
        } else {
            Arrays.fill(this.unmappedBuffer, 0, pageSize, (byte)0);
            TBLTable.putShort(this.unmappedBuffer, this.pagelen, (short)pageSize);
        }
    }

    public int getFirstRecord() {
        return 16;
    }

    public void changeHeader(DomainByteArrayFileMap newHeader, int _offset) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(newHeader, _offset, this.mappedBuffer, this.offset, 16);
        } else {
            DomainByteArrayFileMap.arraycopy(newHeader, _offset, this.unmappedBuffer, this.offset, 16);
        }
    }

    public void changeHeader(byte[] newHeader, int _offset) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(newHeader, _offset, this.mappedBuffer, this.offset, 16);
        } else {
            System.arraycopy(newHeader, _offset, this.unmappedBuffer, this.offset, 16);
        }
    }

    public TBLPageCtl getControlPart() {
        if (this.pageCtl == null) {
            this.pageCtl = this.mappedBuffer != null ? new TBLPageCtl(this.mappedBuffer, this.offset, this.pagelen) : new TBLPageCtl(this.unmappedBuffer, this.offset, this.pagelen);
            this.pageCtl.lruPtr = this.lru;
            this.pageCtl.mruPtr = this.mru;
        }
        return this.pageCtl;
    }

    public boolean isBranch() {
        if (this.mappedBuffer != null) {
            return (this.mappedBuffer.getByte(this.numrecs) & 0x80) != 0;
        }
        return (this.unmappedBuffer[this.numrecs] & 0x80) != 0;
    }

    public boolean isLeaf() {
        if (this.mappedBuffer != null) {
            return (this.mappedBuffer.getByte(this.numrecs) & 0x80) == 0;
        }
        return (this.unmappedBuffer[this.numrecs] & 0x80) == 0;
    }

    public int getPageRecords() {
        if (this.mappedBuffer != null) {
            return TBLTable.getShort(this.mappedBuffer, this.numrecs) & Short.MAX_VALUE;
        }
        return TBLTable.getShort(this.unmappedBuffer, this.numrecs) & Short.MAX_VALUE;
    }

    public int getPageSize() {
        if (this.mappedBuffer != null) {
            return TBLTable.getShort(this.mappedBuffer, this.pagelen);
        }
        return TBLTable.getShort(this.unmappedBuffer, this.pagelen);
    }

    public int getPageRowData() {
        if (this.mappedBuffer != null) {
            return TBLTable.getShort(this.mappedBuffer, this.recspace);
        }
        return TBLTable.getShort(this.unmappedBuffer, this.recspace);
    }

    public int getPageStrings() {
        if (this.mappedBuffer != null) {
            return TBLTable.getShort(this.mappedBuffer, this.strspace);
        }
        return TBLTable.getShort(this.unmappedBuffer, this.strspace);
    }

    public int getPageForward() {
        if (this.mappedBuffer != null) {
            return (int)TBLTable.getLong(this.mappedBuffer, this.forwardpage);
        }
        return (int)TBLTable.getLong(this.unmappedBuffer, this.forwardpage);
    }

    public int getPageLower() {
        if (this.mappedBuffer != null) {
            return (int)TBLTable.getLong(this.mappedBuffer, this.lowerpage);
        }
        return (int)TBLTable.getLong(this.unmappedBuffer, this.lowerpage);
    }

    public int getBodyLong(int index) {
        if (this.mappedBuffer != null) {
            return (int)TBLTable.getLong(this.mappedBuffer, this.body + index);
        }
        return (int)TBLTable.getLong(this.unmappedBuffer, this.body + index);
    }

    public int getBlockOffset() {
        TBLPageCtl ctl = this.getControlPart();
        return ctl.blkOffset;
    }

    public void setBlockOffset(int offset) {
        TBLPageCtl ctl = this.getControlPart();
        ctl.blkOffset = offset;
    }

    public void modifiedPage() {
        TBLPageCtl ctl = this.getControlPart();
        ctl.blkFlags |= 1;
    }

    public void setPageLen(int value) {
        if (this.mappedBuffer != null) {
            TBLTable.putShort(this.mappedBuffer, this.pagelen, (short)value);
        } else {
            TBLTable.putShort(this.unmappedBuffer, this.pagelen, (short)value);
        }
    }

    public void setRecords(int value, boolean leaf) {
        if (this.mappedBuffer != null) {
            TBLTable.putShort(this.mappedBuffer, this.numrecs, (short)(value | (leaf ? 0 : 32768)));
        } else {
            TBLTable.putShort(this.unmappedBuffer, this.numrecs, (short)(value | (leaf ? 0 : 32768)));
        }
    }

    public void setRowData(int value) {
        if (this.mappedBuffer != null) {
            TBLTable.putShort(this.mappedBuffer, this.recspace, (short)value);
        } else {
            TBLTable.putShort(this.unmappedBuffer, this.recspace, (short)value);
        }
    }

    public void setStrings(int value) {
        if (this.mappedBuffer != null) {
            TBLTable.putShort(this.mappedBuffer, this.strspace, (short)value);
        } else {
            TBLTable.putShort(this.unmappedBuffer, this.strspace, (short)value);
        }
    }

    public void setForward(int value) {
        if (this.mappedBuffer != null) {
            TBLTable.putLong(this.mappedBuffer, this.forwardpage, (long)value);
        } else {
            TBLTable.putLong(this.unmappedBuffer, this.forwardpage, (long)value);
        }
    }

    public void setLower(int value) {
        if (this.mappedBuffer != null) {
            TBLTable.putLong(this.mappedBuffer, this.lowerpage, (long)value);
        } else {
            TBLTable.putLong(this.unmappedBuffer, this.lowerpage, (long)value);
        }
    }

    public void setBodyBytes(DomainByteArrayFileMap from, int _offset, int len) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(from, _offset, this.mappedBuffer, this.body, len);
        } else {
            System.arraycopy(from, _offset, this.unmappedBuffer, this.body, len);
        }
    }

    public void setBodyBytes(byte[] from, int _offset, int len) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(from, _offset, this.mappedBuffer, this.body, len);
        } else {
            System.arraycopy(from, _offset, this.unmappedBuffer, this.body, len);
        }
    }

    public void setBodyBytes(DomainByteArrayFileMap from, int _offset, int to_offset, int len) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(from, _offset, this.mappedBuffer, this.body + to_offset, len);
        } else {
            DomainByteArrayFileMap.arraycopy(from, _offset, this.unmappedBuffer, this.body + to_offset, len);
        }
    }

    public void setBodyBytes(byte[] from, int _offset, int to_offset, int len) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(from, _offset, this.mappedBuffer, this.body + to_offset, len);
        } else {
            System.arraycopy(from, _offset, this.unmappedBuffer, this.body + to_offset, len);
        }
    }

    public void setBodyLong(int index, int value) {
        if (this.mappedBuffer != null) {
            TBLTable.putLong(this.mappedBuffer, this.body + index, (long)value);
        } else {
            TBLTable.putLong(this.unmappedBuffer, this.body + index, (long)value);
        }
    }

    public void zeroBodyMemory(int index, int len) {
        if (this.mappedBuffer != null) {
            DomainByteArrayFileMap.fill(this.mappedBuffer, this.body + index, this.body + index + len - 1, (byte)0);
        } else {
            Arrays.fill(this.unmappedBuffer, this.body + index, this.body + index + len - 1, (byte)0);
        }
    }
}

