/*
 * Decompiled with CFR 0.152.
 */
package com.modal;

import com.component.ComponentManager;
import com.constants.batch.BatchProcedureInput_EN;
import com.modal.Edit;
import com.util.StringUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class Procedure {
    private String lineItemActionFlagInput = " ";
    private String cbAPC = "     ";
    private String cbDenialRejection = " ";
    private String cbDiscountingFormula = " ";
    private String cbEdit1 = "   ";
    private String cbEdit2 = "   ";
    private String cbEdit3 = "   ";
    private String cbEdit4 = "   ";
    private String cbPackagingFlag = " ";
    private String cbPaymentAdjustmentFlag = "  ";
    private String cbPaymentIndicator = "  ";
    private String cbPaymentMethodFlag = " ";
    private String cbStatusIndicator = "  ";
    private String code = "     ";
    private String description;
    private String modifier1 = "  ";
    private String modifier2 = "  ";
    private String modifier3 = "  ";
    private String modifier4 = "  ";
    private String modifier5 = "  ";
    private String revenueCode = "   ";
    private String serviceDate = "        ";
    private String unitsInput = "         ";
    private String chargeInput = "          ";
    private String serviceDateRaw = "        ";
    private String userData = "";
    private String compositeAdjustmentFlag = "  ";
    private String discountFormula = " ";
    private String hcpcsAPC = "     ";
    private String lineItemActionFlagOutput = " ";
    private String lineItemDenialRejectionFlag = " ";
    private String packagingFlag = "";
    private String paymentAdjustmentFlag = " ";
    private String paymentAPC = "     ";
    private String paymentIndicator = " ";
    private String paymentMethodFlag = " ";
    private String statusIndicator = "  ";
    private String unitsOutput = "         ";
    private String chargeOutput = "          ";
    private String hcpcsModifier = "    ";
    private String codeOutput = "     ";
    private ArrayList<Edit> procedureEdits = new ArrayList();
    private ArrayList<Edit> modifierEdits = new ArrayList();
    private ArrayList<Edit> revenueEdits = new ArrayList();
    private ArrayList<Edit> dateEdits = new ArrayList();
    private Procedure procedure;

    public Procedure() {
    }

    public Procedure(String line) {
        for (BatchProcedureInput_EN v : BatchProcedureInput_EN.values()) {
            if (!line.startsWith(v.getLine())) continue;
            v.set(this, line);
        }
    }

    public Procedure(Procedure procedure) {
        this.procedure = new Procedure(procedure.code, procedure.description, procedure.modifier1, procedure.modifier2, procedure.modifier3, procedure.modifier4, procedure.modifier5, procedure.revenueCode, procedure.unitsInput, procedure.chargeInput, !procedure.getServiceDate().trim().isEmpty() ? LocalDate.parse(procedure.getServiceDate(), DateTimeFormatter.ofPattern("MMddyyyy")) : LocalDate.parse("01011990", DateTimeFormatter.ofPattern("MMddyyyy")), procedure.lineItemActionFlagInput, procedure.cbEdit1, procedure.cbEdit2, procedure.cbEdit3, procedure.cbEdit4, procedure.cbAPC, procedure.cbStatusIndicator, procedure.cbPaymentIndicator, procedure.cbDiscountingFormula, procedure.cbDenialRejection, procedure.cbPackagingFlag, procedure.cbPaymentAdjustmentFlag, procedure.cbPaymentMethodFlag);
    }

    public Procedure(String code, String description, String modifier1, String modifier2, String modifier3, String modifier4, String modifier5, String revenueCode, String units, String chargeOutput, LocalDate serviceDate, String lineItemActionFlagInput, String cbEdit1, String cbEdit2, String cbEdit3, String cbEdit4, String cbAPC, String cbStatusIndicator, String cbPaymentIndicator, String cbDiscountingFormula, String cbDenialRejection, String cbPackagingFlag, String cbPaymentAdjustmentFlag, String cbPaymentMethodFlag) {
        this.code = this.checkInput(code, 5, " ");
        this.description = description;
        this.modifier1 = this.checkInput(modifier1, 2, " ");
        this.modifier2 = this.checkInput(modifier2, 2, " ");
        this.modifier3 = this.checkInput(modifier3, 2, " ");
        this.modifier4 = this.checkInput(modifier4, 2, " ");
        this.modifier5 = this.checkInput(modifier5, 2, " ");
        this.revenueCode = this.checkInput(revenueCode, 4, " ");
        this.unitsInput = this.checkInput(units, 9, "0");
        this.chargeInput = this.checkInput(chargeOutput, 10, "0");
        this.serviceDate = serviceDate == null ? "        " : (serviceDate.toString().length() < 8 ? serviceDate.toString() : serviceDate.format(DateTimeFormatter.ofPattern("MMddyyyy")));
        this.lineItemActionFlagInput = this.checkInput(lineItemActionFlagInput, 1, "0");
        this.cbEdit1 = this.checkInput(cbEdit1, 3, " ");
        this.cbEdit2 = this.checkInput(cbEdit2, 3, " ");
        this.cbEdit3 = this.checkInput(cbEdit3, 3, " ");
        this.cbEdit4 = this.checkInput(cbEdit4, 3, " ");
        this.cbAPC = this.checkInput(cbAPC, 5, " ");
        this.cbStatusIndicator = this.checkInput(cbStatusIndicator, 2, " ");
        this.cbPaymentIndicator = this.checkInput(cbPaymentIndicator, 2, " ");
        this.cbDiscountingFormula = this.checkInput(cbDiscountingFormula, 1, " ");
        this.cbDenialRejection = this.checkInput(cbDenialRejection, 1, " ");
        this.cbPackagingFlag = this.checkInput(cbPackagingFlag, 1, " ");
        this.cbPaymentAdjustmentFlag = this.checkInput(cbPaymentAdjustmentFlag, 1, " ");
        this.cbPaymentMethodFlag = this.checkInput(cbPaymentMethodFlag, 1, " ");
    }

    private String checkInput(String value, int length, String padChar) {
        if (value == null || value.trim().isEmpty()) {
            return new String(new char[length]).replace("\u0000", padChar);
        }
        return value;
    }

    private String getFromDateDomainFormat() {
        return StringUtils.convertToDomainDate(this.serviceDate, "MMddyyyy", "yyyyMMdd");
    }

    public String toFormattedString(String date) {
        StringBuilder sb = new StringBuilder();
        String _SPACES_ = "    ";
        sb.append(this.code).append(":").append(new ComponentManager().getDescription(date, this.code, 1));
        sb.append("\n").append("    ").append("    ");
        sb.append("Modifiers: ").append(this.modifier1).append(" ").append(this.modifier2).append(" ").append(this.modifier3).append(" ").append(this.modifier4).append(" ").append(this.modifier5).append("   ");
        sb.append("Revenue Code: ").append(this.revenueCode).append("              ");
        sb.append("Date: ").append(StringUtils.convertToDomainDate(this.serviceDate, "MMddyyyy", "MM/dd/yyyy"));
        sb.append("\n").append("    ").append("    ");
        sb.append("Units: ").append(this.unitsOutput).append("            ");
        sb.append("Charges: ").append(this.chargeOutput);
        sb.append("\n").append("    ").append("    ");
        sb.append("HCPCS APC: ").append(this.hcpcsAPC).append("            ");
        sb.append("Payment APC: ").append(this.paymentAPC).append("              ");
        sb.append("HCPCS Modifier: ").append(this.hcpcsModifier);
        sb.append("\n").append("    ").append("    ");
        sb.append("Status Indicator: ").append(this.statusIndicator).append("        ");
        sb.append("Payment Indicator: ").append(this.paymentIndicator).append("           ");
        sb.append("Discounting Formula: ").append(this.discountFormula);
        sb.append("\n").append("    ").append("    ");
        sb.append("Action Flag In/Out: ").append(this.lineItemActionFlagInput).append("/").append(this.lineItemActionFlagOutput).append("     ");
        sb.append("Payment Adjustment Flag: ").append(this.paymentAdjustmentFlag).append("     ");
        sb.append("Composite Flag: ").append(this.compositeAdjustmentFlag);
        sb.append("\n").append("    ").append("    ");
        sb.append("Packaging Flag: ").append(this.packagingFlag).append("           ");
        sb.append("Payment Method Flag: ").append(this.paymentMethodFlag).append("          ");
        sb.append("Denial/Rejection Flag: ").append(this.lineItemDenialRejectionFlag);
        if (!this.cbEdit1.trim().isEmpty()) {
            sb.append("\nContractor Bypass Fields Entered");
            sb.append("\n").append("    ").append("    ");
            sb.append("Edits: ").append(this.cbEdit1).append(" ").append(this.cbEdit2).append(" ").append(this.cbEdit3).append(" ").append(this.cbEdit4).append("      ");
            sb.append("APC: ").append(this.cbAPC).append("                      ");
            sb.append("Status Indicator: ").append(this.cbStatusIndicator);
            sb.append("\n").append("    ").append("    ");
            sb.append("Payment Indicator: ").append(this.cbPaymentIndicator).append("       ");
            sb.append("Discounting Formula: ").append(this.cbDiscountingFormula).append("          ");
            sb.append("Denial/Rejection: ").append(this.cbDenialRejection);
            sb.append("\n").append("    ").append("    ");
            sb.append("Packaging: ").append(this.cbPackagingFlag).append("                ");
            sb.append("Payment Adj.: ").append(this.cbPaymentAdjustmentFlag).append("                ");
            sb.append("Payment Method: ").append(this.cbPaymentMethodFlag);
        }
        if (!this.getProcedureEdits().get(0).getEdit().trim().isEmpty()) {
            sb.append("\nProcedure Edits:\n");
            for (Edit e : this.getProcedureEdits()) {
                if (e.getEdit().trim().isEmpty()) continue;
                sb.append(e.toFormattedString(this.getFromDateDomainFormat())).append("\n");
            }
        }
        if (!this.getDateEdits().get(0).getEdit().trim().isEmpty()) {
            sb.append("\nDate Edits:\n");
            for (Edit e : this.getDateEdits()) {
                if (e.getEdit().trim().isEmpty()) continue;
                sb.append(e.toFormattedString(this.getFromDateDomainFormat())).append("\n");
            }
        }
        if (!this.getRevenueEdits().get(0).getEdit().trim().isEmpty()) {
            sb.append("\nRevenue Edits:\n");
            for (Edit e : this.getRevenueEdits()) {
                if (e.getEdit().trim().isEmpty()) continue;
                sb.append(e.toFormattedString(this.getFromDateDomainFormat())).append("\n");
            }
        }
        if (!(this.getModifierEdits().get(0).getEdit().trim().isEmpty() && this.getModifierEdits().get(1).getEdit().trim().isEmpty() && this.getModifierEdits().get(2).getEdit().trim().isEmpty() && this.getModifierEdits().get(3).getEdit().trim().isEmpty() && this.getModifierEdits().get(4).getEdit().trim().isEmpty())) {
            int modifierEditCount = 0;
            int printCount = 2;
            sb.append("\nModifier Edits ").append(1).append(":").append("\n");
            for (Edit e : this.getModifierEdits()) {
                if (modifierEditCount % 4 == 0 && modifierEditCount != 0) {
                    sb.append("Modifier Edits ").append(printCount).append(":").append("\n");
                    ++printCount;
                }
                if (!e.getEdit().trim().isEmpty()) {
                    sb.append(e.toFormattedString(this.getFromDateDomainFormat())).append("\n");
                }
                ++modifierEditCount;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toDomainString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.code);
        sb.append(this.modifier1);
        sb.append(this.modifier2);
        sb.append(this.modifier3);
        sb.append(this.modifier4);
        sb.append(this.modifier5);
        sb.append(this.getFromDateDomainFormat());
        sb.append(this.revenueCode);
        sb.append(this.getUnitsInput());
        sb.append(this.getChargeInput());
        sb.append(this.cbEdit1);
        sb.append(this.cbEdit2);
        sb.append(this.cbEdit3);
        sb.append(this.cbEdit4);
        sb.append(this.cbAPC);
        sb.append(this.cbStatusIndicator);
        sb.append(this.cbPaymentIndicator);
        sb.append(this.cbDiscountingFormula);
        sb.append(this.cbDenialRejection);
        sb.append(this.cbPackagingFlag);
        sb.append(this.cbPaymentAdjustmentFlag);
        sb.append(this.cbPaymentMethodFlag);
        sb.append(this.userData);
        return sb.toString();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getModifier1() {
        return this.modifier1;
    }

    public String getModifier2() {
        return this.modifier2;
    }

    public String getModifier3() {
        return this.modifier3;
    }

    public String getModifier4() {
        return this.modifier4;
    }

    public String getRevenueCode() {
        return this.revenueCode;
    }

    public String getUnitsOutput() {
        return this.unitsOutput;
    }

    public String getChargeOutput() {
        return this.chargeOutput;
    }

    public String getServiceDate() {
        return this.serviceDate;
    }

    public String getCbEdit1() {
        return this.cbEdit1;
    }

    public String getCbEdit2() {
        return this.cbEdit2;
    }

    public String getCbEdit3() {
        return this.cbEdit3;
    }

    public String getCbEdit4() {
        return this.cbEdit4;
    }

    public String getCbAPC() {
        return this.cbAPC;
    }

    public String getCbStatusIndicator() {
        return this.cbStatusIndicator;
    }

    public String getCbPaymentIndicator() {
        return this.cbPaymentIndicator;
    }

    public String getCbDiscountingFormula() {
        return this.cbDiscountingFormula;
    }

    public String getCbDenialRejection() {
        return this.cbDenialRejection;
    }

    public String getCbPackagingFlag() {
        return this.cbPackagingFlag;
    }

    public String getCbPaymentAdjustmentFlag() {
        return this.cbPaymentAdjustmentFlag;
    }

    public String getCbPaymentMethodFlag() {
        return this.cbPaymentMethodFlag;
    }

    public String getModifier5() {
        return this.modifier5;
    }

    public String getStatusIndicator() {
        return this.statusIndicator;
    }

    public void setStatusIndicator(String statusIndicator) {
        this.statusIndicator = statusIndicator;
    }

    public String getPaymentIndicator() {
        return this.paymentIndicator;
    }

    public void setPaymentIndicator(String paymentIndicator) {
        this.paymentIndicator = paymentIndicator;
    }

    public String getHcpcsAPC() {
        return this.hcpcsAPC;
    }

    public void setHcpcsAPC(String hcpcsAPC) {
        this.hcpcsAPC = hcpcsAPC;
    }

    public String getPaymentAPC() {
        return this.paymentAPC;
    }

    public void setPaymentAPC(String paymentAPC) {
        this.paymentAPC = paymentAPC;
    }

    public String getDiscountFormula() {
        return this.discountFormula;
    }

    public void setDiscountFormula(String discountFormula) {
        this.discountFormula = discountFormula;
    }

    public String getPaymentAdjustmentFlag() {
        return this.paymentAdjustmentFlag;
    }

    public void setPaymentAdjustmentFlag(String paymentAdjustmentFlag) {
        this.paymentAdjustmentFlag = paymentAdjustmentFlag;
    }

    public String getCompositeAdjustmentFlag() {
        return this.compositeAdjustmentFlag;
    }

    public void setCompositeAdjustmentFlag(String compositeAdjustmentFlag) {
        this.compositeAdjustmentFlag = compositeAdjustmentFlag;
    }

    public String getLineItemActionFlagOutput() {
        return this.lineItemActionFlagOutput;
    }

    public void setLineItemActionFlagOutput(String lineItemActionFlagOutput) {
        this.lineItemActionFlagOutput = lineItemActionFlagOutput;
    }

    public String getPackagingFlag() {
        return this.packagingFlag;
    }

    public void setPackagingFlag(String packagingFlag) {
        this.packagingFlag = packagingFlag;
    }

    public String getPaymentMethodFlag() {
        return this.paymentMethodFlag;
    }

    public void setPaymentMethodFlag(String paymentMethodFlag) {
        this.paymentMethodFlag = paymentMethodFlag;
    }

    public String getLineItemDenialRejectionFlag() {
        return this.lineItemDenialRejectionFlag;
    }

    public void setLineItemDenialRejectionFlag(String lineItemDenialRejectionFlag) {
        this.lineItemDenialRejectionFlag = lineItemDenialRejectionFlag;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public void setProcedure(Procedure procedure) {
        this.procedure = procedure;
    }

    public void setUnitsOutput(String unitsOutput) {
        this.unitsOutput = unitsOutput;
    }

    public void setChargeOutput(String chargeOutput) {
        this.chargeOutput = chargeOutput;
    }

    public String getHcpcsModifier() {
        return this.hcpcsModifier;
    }

    public void setHcpcsModifier(String hcpcsModifier) {
        this.hcpcsModifier = hcpcsModifier;
    }

    public ArrayList<Edit> getProcedureEdits() {
        return this.procedureEdits;
    }

    public void setProcedureEdits(ArrayList<Edit> procedureEdits) {
        this.procedureEdits = procedureEdits;
    }

    public ArrayList<Edit> getModifierEdits() {
        return this.modifierEdits;
    }

    public void setModifierEdits(ArrayList<Edit> modifierEdits) {
        this.modifierEdits = modifierEdits;
    }

    public ArrayList<Edit> getRevenueEdits() {
        return this.revenueEdits;
    }

    public void setRevenueEdits(ArrayList<Edit> revenueEdits) {
        this.revenueEdits = revenueEdits;
    }

    public ArrayList<Edit> getDateEdits() {
        return this.dateEdits;
    }

    public void setDateEdits(ArrayList<Edit> dateEdits) {
        this.dateEdits = dateEdits;
    }

    public void setCbAPC(String cbAPC) {
        this.cbAPC = cbAPC;
    }

    public void setCbDenialRejection(String cbDenialRejection) {
        this.cbDenialRejection = cbDenialRejection;
    }

    public void setCbDiscountingFormula(String cbDiscountingFormula) {
        this.cbDiscountingFormula = cbDiscountingFormula;
    }

    public void setCbEdit1(String cbEdit1) {
        this.cbEdit1 = cbEdit1;
    }

    public void setServiceDate(String serviceDate) {
        this.serviceDate = serviceDate;
    }

    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    public void setModifier5(String modifier5) {
        this.modifier5 = modifier5;
    }

    public void setModifier4(String modifier4) {
        this.modifier4 = modifier4;
    }

    public void setModifier3(String modifier3) {
        this.modifier3 = modifier3;
    }

    public void setModifier2(String modifier2) {
        this.modifier2 = modifier2;
    }

    public void setModifier1(String modifier1) {
        this.modifier1 = modifier1;
    }

    public void setCbStatusIndicator(String cbStatusIndicator) {
        this.cbStatusIndicator = cbStatusIndicator;
    }

    public void setCbPaymentMethodFlag(String cbPaymentMethodFlag) {
        this.cbPaymentMethodFlag = cbPaymentMethodFlag;
    }

    public void setCbPaymentIndicator(String cbPaymentIndicator) {
        this.cbPaymentIndicator = cbPaymentIndicator;
    }

    public void setCbPaymentAdjustmentFlag(String cbPaymentAdjustmentFlag) {
        this.cbPaymentAdjustmentFlag = cbPaymentAdjustmentFlag;
    }

    public void setCbPackagingFlag(String cbPackagingFlag) {
        this.cbPackagingFlag = cbPackagingFlag;
    }

    public void setCbEdit4(String cbEdit4) {
        this.cbEdit4 = cbEdit4;
    }

    public void setCbEdit3(String cbEdit3) {
        this.cbEdit3 = cbEdit3;
    }

    public void setCbEdit2(String cbEdit2) {
        this.cbEdit2 = cbEdit2;
    }

    public String getUnitsInput() {
        return this.unitsInput;
    }

    public void setUnitsInput(String unitsInput) {
        this.unitsInput = unitsInput;
    }

    public String getChargeInput() {
        return this.chargeInput;
    }

    public void setChargeInput(String chargeInput) {
        this.chargeInput = chargeInput;
    }

    public String getLineItemActionFlagInput() {
        return this.lineItemActionFlagInput;
    }

    public void setLineItemActionFlagInput(String lineItemActionFlagInput) {
        this.lineItemActionFlagInput = lineItemActionFlagInput;
    }

    public String getCodeOutput() {
        return this.codeOutput;
    }

    public void setCodeOutput(String codeOutput) {
        this.codeOutput = codeOutput;
    }

    public String getServiceDateRaw() {
        return this.serviceDateRaw;
    }

    public void setServiceDateRaw(String serviceDateRaw) {
        this.serviceDateRaw = serviceDateRaw;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }
}

