/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao;

import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableKeyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TableKeyBuilder.class);

    private TableKeyBuilder() {
    }

    public static final <T extends Enum<T>> Map<T, String> createTableKeyMap(Class<T> clazz) {
        EnumMap<T, Object> tableKey = new EnumMap<T, Object>(clazz);
        for (Enum key : (Enum[])clazz.getEnumConstants()) {
            tableKey.put((T)key, (Object)null);
        }
        return tableKey;
    }

    public static final <T extends Enum<T>> String createTableKey(Map<T, String> tableKey) {
        if (tableKey == null) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder();
        boolean multiple = false;
        for (Map.Entry<T, String> entry : tableKey.entrySet()) {
            if (entry.getValue() == null || "".equals(entry.getValue())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Key criteria not set for column \"{}\".", entry.getKey());
                }
                return "";
            }
            if (multiple) {
                keyBuilder.append('-');
            } else {
                multiple = true;
            }
            keyBuilder.append(entry.getValue());
        }
        return keyBuilder.toString();
    }
}

