/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.data.VersionRangeDaoImpl;
import gov.cms.oce.dao.data.DataHcpcsDao;
import gov.cms.oce.dao.data.row.DataHcpcsRowInternal;
import gov.cms.oce.dao.data.table.DataHcpcsTableInternal;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.LineItemInternalTableData;
import gov.cms.oce.model.internal.Version;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.StringUtilities;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataHcpcsDaoImpl
implements DataHcpcsDao {
    private static final Logger logger = LoggerFactory.getLogger(DataHcpcsDaoImpl.class);

    @Override
    public final DataHcpcsRowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("CPT/HCPCS parameter value is null/empty.");
            }
            return null;
        }
        Map<DataHcpcsTableInternal.DataHcpcsTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataHcpcsTableInternal.DataHcpcsTableKey.class);
        key.put(DataHcpcsTableInternal.DataHcpcsTableKey.HCPCS, value);
        DataHcpcsTableInternal table = BinaryDataProvider.getInstance().getDataHcpcsTable();
        DataHcpcsRowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("CPT/HCPCS parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataHcpcsRowInternal getRow(Hcpcs hcpcs, Short version) {
        return this.getRow(hcpcs.getValue(), version);
    }

    @Override
    public final void loadData(LineItemInternal line, Short version, ClaimDate dateEnded) {
        if (line.getFlags().anySet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No table data loaded as the CPT/HCPCS is either blank or invalid.");
            }
        } else {
            Map<DataHcpcsTableInternal.DataHcpcsTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataHcpcsTableInternal.DataHcpcsTableKey.class);
            key.put(DataHcpcsTableInternal.DataHcpcsTableKey.HCPCS, line.getHcpcs().getValue());
            DataHcpcsTableInternal table = BinaryDataProvider.getInstance().getDataHcpcsTable();
            DataHcpcsRowInternal row = table.getRowInternal(key, version);
            boolean versionBoundaryCrossed = false;
            if (row == null && dateEnded != null && line.getServiceDate().isValid()) {
                VersionRangeDaoImpl versionRangeDao = new VersionRangeDaoImpl();
                Version dateEndedVersion = versionRangeDao.getVersion(dateEnded);
                short dateEndedVersionValue = dateEndedVersion.getValue();
                Version serviceDateVersion = versionRangeDao.getVersion(line.getServiceDate());
                short serviceDateVersionValue = serviceDateVersion.getValue();
                if (dateEndedVersion != null && serviceDateVersion != null && version == dateEndedVersionValue - 1 && dateEndedVersionValue == serviceDateVersionValue) {
                    row = table.getRowInternal(key, dateEndedVersionValue);
                    versionBoundaryCrossed = true;
                }
            }
            if (row == null) {
                line.getFlags().set(LineFlags.INPUT_INVALID_HCPCS);
                if (logger.isDebugEnabled()) {
                    logger.debug("CPT/HCPCS value \"{}\" is missing from table.", (Object)line.getHcpcs().getValue());
                }
            } else if (versionBoundaryCrossed) {
                line.getFlags().set((LineFlags)new LineFlags[]{LineFlags.INPUT_INVALID_HCPCS, LineFlags.HCPCS_VALID_IN_FUTURE_VERSION});
                LineItemInternalTableData tableData = line.getTableData();
                tableData.setLowAge((byte)0);
                tableData.setHighAge((byte)124);
                tableData.setSex((byte)0);
                tableData.setMidQuarterDateEdit((short)0);
                tableData.setPartialHospitalizationDuration((byte)0);
            } else {
                FlagSet<LineFlags> flags = line.getFlags();
                if (row.isQuestionable()) {
                    flags.set(LineFlags.DATA_HCPCS_QUESTIONABLE);
                }
                if (row.isNotRecognizedMcare()) {
                    flags.set(LineFlags.DATA_HCPCS_NOT_RECOGNIZED_MCARE);
                }
                if (row.isNotRecognizedOpps()) {
                    flags.set(LineFlags.DATA_HCPCS_NOT_RECOGNIZED_OPPS);
                }
                if (row.isNonCovered()) {
                    flags.set(LineFlags.DATA_HCPCS_NON_COVERED);
                }
                if (row.isNonReportableSite()) {
                    flags.set(LineFlags.DATA_HCPCS_NON_REPORTABLE_SITE);
                }
                if (row.isBilateralConditional()) {
                    flags.set(LineFlags.DATA_HCPCS_BILATERAL_CONDITIONAL);
                }
                if (row.isBilateralIndependent()) {
                    flags.set(LineFlags.DATA_HCPCS_BILATERAL_INDEPENDENT);
                }
                if (row.isBilateralInherent()) {
                    flags.set(LineFlags.DATA_HCPCS_BILATERAL_INHERENT);
                }
                if (row.isNcciCode1()) {
                    flags.set(LineFlags.DATA_HCPCS_NCCI_CODE1);
                }
                if (row.isNcciCode2()) {
                    flags.set(LineFlags.DATA_HCPCS_NCCI_CODE2);
                }
                if (row.isVaccine()) {
                    flags.set(LineFlags.DATA_HCPCS_VACCINE);
                }
                if (row.isAntigen()) {
                    flags.set(LineFlags.DATA_HCPCS_ANTIGEN);
                }
                if (row.isSplint()) {
                    flags.set(LineFlags.DATA_HCPCS_SPLINT);
                }
                if (row.isCast()) {
                    flags.set(LineFlags.DATA_HCPCS_CAST);
                }
                if (row.isNegativePressureWoundTherapy()) {
                    flags.set(LineFlags.DATA_HCPCS_NEGATIVE_PRESSURE_WOUND_THERAPY);
                }
                if (row.isSometimesTherapy()) {
                    flags.set(LineFlags.DATA_HCPCS_SOMETIMES_THERAPY);
                }
                if (row.isActivityTherapy()) {
                    flags.set(LineFlags.DATA_HCPCS_ACTIVITY_THERAPY);
                }
                if (row.isOccupationalTherapy()) {
                    flags.set(LineFlags.DATA_HCPCS_OCCUPATIONAL_THERAPY);
                }
                if (row.isDeductibleNa()) {
                    flags.set(LineFlags.DATA_HCPCS_DEDUCTIBLE_NA);
                }
                if (row.isDeductibleCoinsNa()) {
                    flags.set(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA);
                }
                if (row.isCoinsNa()) {
                    flags.set(LineFlags.DATA_HCPCS_COINS_NA);
                }
                if (row.isBloodService()) {
                    flags.set(LineFlags.DATA_HCPCS_BLOOD_SERVICE);
                }
                if (row.isBloodProduct()) {
                    flags.set(LineFlags.DATA_HCPCS_BLOOD_PRODUCT);
                }
                if (row.isPackedRedCells()) {
                    flags.set(LineFlags.DATA_HCPCS_PACKED_RED_CELLS);
                }
                if (row.isWholeBlood()) {
                    flags.set(LineFlags.DATA_HCPCS_WHOLE_BLOOD);
                }
                if (row.isEducational()) {
                    flags.set(LineFlags.DATA_HCPCS_EDUCATIONAL);
                }
                if (row.isObservation()) {
                    flags.set(LineFlags.DATA_HCPCS_OBSERVATION);
                }
                if (row.isObservationHourly()) {
                    flags.set(LineFlags.DATA_HCPCS_OBSERVATION_HOURLY);
                }
                if (row.isObservationDirectAdmit()) {
                    flags.set(LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT);
                }
                if (row.isObservationHospitalOnly()) {
                    flags.set(LineFlags.DATA_HCPCS_OBSERVATION_HOSPITAL_ONLY);
                }
                if (row.isTraumaRevenueCode()) {
                    flags.set(LineFlags.DATA_HCPCS_TRAUMA_REVENUE_CODE);
                }
                if (row.isTraumaCriticalCare()) {
                    flags.set(LineFlags.DATA_HCPCS_TRAUMA_CRITICAL_CARE);
                }
                if (row.isCriticalCareAncillary()) {
                    flags.set(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY);
                }
                if (row.isStvPackaged()) {
                    flags.set(LineFlags.DATA_HCPCS_STV_PACKAGED);
                }
                if (row.istPackaged()) {
                    flags.set(LineFlags.DATA_HCPCS_T_PACKAGED);
                }
                if (row.isHasDevReqProc()) {
                    flags.set(LineFlags.DATA_HCPCS_HAS_DEV_REQ_PROC);
                }
                if (row.isSeparateProcedure()) {
                    flags.set(LineFlags.DATA_HCPCS_SEPARATE_PROCEDURE);
                }
                if (row.isStatutoryExclusion()) {
                    flags.set(LineFlags.DATA_HCPCS_STATUTORY_EXCLUSION);
                }
                if (row.isDmercBillableOnly()) {
                    flags.set(LineFlags.DATA_HCPCS_DMERC_BILLABLE_ONLY);
                }
                if (row.isUnclassifiedDrug()) {
                    flags.set(LineFlags.DATA_HCPCS_UNCLASSIFIED_DRUG);
                }
                if (row.isRadioPharm()) {
                    flags.set(LineFlags.DATA_HCPCS_RADIO_PHARM);
                }
                if (row.isNuclearMed()) {
                    flags.set(LineFlags.DATA_HCPCS_NUCLEAR_MED);
                }
                if (row.isNonBillableMac()) {
                    flags.set(LineFlags.DATA_HCPCS_NON_BILLABLE_MAC);
                }
                if (row.isHasDevicePair1()) {
                    flags.set(LineFlags.DATA_HCPCS_HAS_DEVICE_PAIR1);
                }
                if (row.isHasDevicePair2()) {
                    flags.set(LineFlags.DATA_HCPCS_HAS_DEVICE_PAIR2);
                }
                if (row.isPhPrimary()) {
                    flags.set(LineFlags.DATA_HCPCS_PH_PRIMARY);
                }
                if (row.isPhService()) {
                    flags.set(LineFlags.DATA_HCPCS_PH_SERVICE);
                }
                if (row.isDailyMentalHealth()) {
                    flags.set(LineFlags.DATA_HCPCS_DAILY_MENTAL_HEALTH);
                }
                if (row.isMhNotPh()) {
                    flags.set(LineFlags.DATA_HCPCS_MH_NOT_PH);
                }
                if (row.isPhNotMh()) {
                    flags.set(LineFlags.DATA_HCPCS_PH_NOT_MH);
                }
                if (row.isPhAddon()) {
                    flags.set(LineFlags.DATA_HCPCS_PH_ADDON);
                }
                if (row.isTokenChargeOnly()) {
                    flags.set(LineFlags.DATA_HCPCS_TOKEN_CHARGE_ONLY);
                }
                if (row.isSkinSubstituteSg()) {
                    flags.set(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_SG);
                }
                if (row.isSkinSubstitute()) {
                    flags.set(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE);
                }
                if (row.isCapcExclusion()) {
                    flags.set(LineFlags.DATA_HCPCS_CAPC_EXCLUSION);
                }
                if (row.isCapcSrsPlanAndPrep()) {
                    flags.set(LineFlags.DATA_HCPCS_CAPC_SRS_PLAN_AND_PREP);
                }
                if (row.isDeviceProcedure()) {
                    flags.set(LineFlags.DATA_HCPCS_DEVICE_PROCEDURE);
                }
                if (row.isDevice()) {
                    flags.set(LineFlags.DATA_HCPCS_DEVICE);
                }
                if (row.isSkinSubstituteSgLo()) {
                    flags.set(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_SG_LO);
                }
                if (row.isSkinSubstituteLo()) {
                    flags.set(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_LO);
                }
                if (row.isSkinSubstituteSgHi()) {
                    flags.set(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_SG_HI);
                }
                if (row.isSkinSubstituteHi()) {
                    flags.set(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_HI);
                }
                if (row.isLabService()) {
                    flags.set(LineFlags.DATA_HCPCS_LAB_SERVICE);
                }
                if (row.isFqhcPreventive()) {
                    flags.set(LineFlags.DATA_HCPCS_FQHC_PREVENTIVE);
                }
                if (row.isFqhcFluPpv()) {
                    flags.set(LineFlags.DATA_HCPCS_FQHC_FLU_PPV);
                }
                if (row.isFqhcNonCovered()) {
                    flags.set(LineFlags.DATA_HCPCS_FQHC_NON_COVERED);
                }
                if (row.isFqhcAddon()) {
                    flags.set(LineFlags.DATA_HCPCS_FQHC_ADDON);
                }
                if (row.isFqhcPrimary()) {
                    flags.set(LineFlags.DATA_HCPCS_FQHC_PRIMARY);
                }
                if (row.isFqhcChronicCare()) {
                    flags.set(LineFlags.DATA_HCPCS_FQHC_CHRONIC_CARE);
                }
                if (row.isRhcModifierConflict()) {
                    flags.set(LineFlags.DATA_HCPCS_RHC_MODIFIER_CONFLICT);
                }
                if (row.isBypassE72FqhcRhc()) {
                    flags.set(LineFlags.DATA_HCPCS_BYPASS_E72_FQHC_RHC);
                }
                if (row.isDevProcBypass()) {
                    flags.set(LineFlags.DATA_HCPCS_DEV_PROC_BYPASS);
                }
                if (row.isCorneaTransplant()) {
                    flags.set(LineFlags.DATA_HCPCS_CORNEA_TRANSPLANT);
                }
                if (row.isCorneaTissueProcessing()) {
                    flags.set(LineFlags.DATA_HCPCS_CORNEA_TISSUE_PROCESSING);
                }
                if (row.isAdvanceCarePlanning()) {
                    flags.set(LineFlags.DATA_HCPCS_ADVANCE_CARE_PLANNING);
                }
                if (row.isAnnualWellnessvisit()) {
                    flags.set(LineFlags.DATA_HCPCS_ANNUAL_WELLNESS_VISIT);
                }
                if (row.isTerminatedDeviceProcedure()) {
                    flags.set(LineFlags.DATA_HCPCS_TERMINATED_DEVICE_PROCEDURE);
                }
                if (row.isPassthroughDevice()) {
                    flags.set(LineFlags.DATA_HCPCS_PASSTHROUGH_DEVICE);
                }
                if (row.isPassthroughRadiopharm()) {
                    flags.set(LineFlags.DATA_HCPCS_PASSTHROUGH_RADIOPHARM);
                }
                if (row.isPassthroughSkinProduct()) {
                    flags.set(LineFlags.DATA_HCPCS_PASSTHROUGH_SKIN_PRODUCT);
                }
                if (row.isPassthroughContrast()) {
                    flags.set(LineFlags.DATA_HCPCS_PASSTHROUGH_CONTRAST);
                }
                if (row.isPassthroughStressAgent()) {
                    flags.set(LineFlags.DATA_HCPCS_PASSTHROUGH_STRESS_AGENT);
                }
                if (row.isNonStandardCtScan()) {
                    flags.set(LineFlags.DATA_HCPCS_NON_STANDARD_CT_SCAN);
                }
                if (row.isFilmXray()) {
                    flags.set(LineFlags.DATA_HCPCS_FILM_XRAY);
                }
                if (row.isAllogeneicTransplant()) {
                    flags.set(LineFlags.DATA_HCPCS_ALLOGENEIC_TRANSPLANT);
                }
                if (row.isBypassE99()) {
                    flags.set(LineFlags.DATA_HCPCS_BYPASS_E99);
                }
                if (row.isOverrideSection603()) {
                    flags.set(LineFlags.DATA_HCPCS_OVERRIDE_SECTION603);
                }
                if (row.isAddonType1()) {
                    flags.set(LineFlags.DATA_HCPCS_ADDON_TYPE1);
                }
                if (row.isAddonType2()) {
                    flags.set(LineFlags.DATA_HCPCS_ADDON_TYPE2);
                }
                if (row.isAddonType3()) {
                    flags.set(LineFlags.DATA_HCPCS_ADDON_TYPE3);
                }
                if (row.isBiosimilar()) {
                    flags.set(LineFlags.DATA_HCPCS_BIOSIMILAR);
                }
                if (row.isBundledInBiological()) {
                    flags.set(LineFlags.DATA_HCPCS_BUNDLED_IN_BIOLOGICAL);
                }
                if (row.isBypassE92Modifier()) {
                    flags.set(LineFlags.DATA_HCPCS_BYPASS_E92_MODIFIER);
                }
                if (row.isAddonDrugAdmin()) {
                    flags.set(LineFlags.DATA_HCPCS_ADDON_DRUG_ADMIN);
                }
                if (row.isInformationOnly()) {
                    flags.set(LineFlags.DATA_HCPCS_INFORMATION_ONLY);
                }
                if (row.isRadiationOncologyModel()) {
                    flags.set(LineFlags.DATA_HCPCS_RADIATION_ONCOLOGY_MODEL);
                }
                if (row.isCoinsuranceDeductibleWaiverEligible()) {
                    flags.set(LineFlags.DATA_HCPCS_COINSURANCE_DEDUCTIBLE_WAIVER_ELIGIBLE);
                }
                if (row.isAddonCovidLab()) {
                    flags.set(LineFlags.DATA_HCPCS_ADDON_COVID_LAB);
                }
                if (row.isOpioidTreatmentProgram()) {
                    flags.set(LineFlags.DATA_HCPCS_OPIOID_TREATMENT_PROGRAM);
                }
                if (row.isOpioidUseDisorder()) {
                    flags.set(LineFlags.DATA_HCPCS_OPIOID_USE_DISORDER);
                }
                if (row.isColorectalScreening()) {
                    flags.set(LineFlags.DATA_HCPCS_COLORECTAL_SCREENING);
                }
                if (row.isCmsMidQuarterTermination()) {
                    flags.set(LineFlags.DATA_HCPCS_CMS_MID_QUARTER_TERMINATION);
                }
                if (row.isCmsMidQuarterTerminationBypass()) {
                    flags.set(LineFlags.DATA_HCPCS_CMS_MID_QUARTER_TERMINATION_BYPASS);
                }
                if (row.isRemoteMentalHealth()) {
                    flags.set(LineFlags.DATA_HCPCS_REMOTE_MENTAL_HEALTH);
                }
                if (row.isAddonSaaS()) {
                    flags.set(LineFlags.DATA_HCPCS_ADDON_SAAS);
                }
                LineItemInternalTableData tableData = line.getTableData();
                tableData.setLowAge(row.getLoAge());
                tableData.setHighAge(row.getHiAge());
                tableData.setSex(row.getSex());
                tableData.setDefaultApc(row.getApc());
                tableData.setDefaultStatusIndicator(row.getStatusIndicator());
                tableData.setDefaultPaymentIndicator(row.getPaymentIndicator());
                if (0 < row.getDateApproved()) {
                    tableData.setDateApproved(String.valueOf(row.getDateApproved()));
                }
                if (0 < row.getDateTerminated()) {
                    tableData.setDateTerminated(String.valueOf(row.getDateTerminated()));
                }
                tableData.setMidQuarterDateEdit(row.getMidQuarterDateEdit());
                tableData.setPartialHospitalizationDuration(row.getPhDuration());
                line.getStatusIndicator().setValue(row.getStatusIndicator());
                line.getPaymentIndicator().setValue(row.getPaymentIndicator());
            }
        }
    }

    @Override
    public final boolean checkHardcodedHcpcsSet() {
        boolean abort = false;
        DataHcpcsTableInternal table = BinaryDataProvider.getInstance().getDataHcpcsTable();
        Map<DataHcpcsTableInternal.DataHcpcsTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataHcpcsTableInternal.DataHcpcsTableKey.class);
        for (HardcodedHcpcsSet e : HardcodedHcpcsSet.values()) {
            if (e == HardcodedHcpcsSet.SURGICAL_CODE_RANGE_START || e == HardcodedHcpcsSet.SURGICAL_CODE_RANGE_END) continue;
            key.put(DataHcpcsTableInternal.DataHcpcsTableKey.HCPCS, e.getHcpcs());
            List<DataHcpcsRowInternal> rowSet = table.getRowInternal(key);
            if (rowSet.isEmpty()) {
                abort = true;
                logger.error("Did not find any rows for HCPCS \"{}\" in the Data_HCPCS table.", (Object)e.getHcpcs());
                continue;
            }
            for (DataHcpcsRowInternal row : rowSet) {
                if (row.getLoVersion() < e.getVersionStarted()) {
                    abort = true;
                    logger.error("Earliest version of HCPCS \"{}\" in Data_HCPCS table (version \"{}\") is earlier than hardcoded APC earliest version \"{}\".", new Object[]{e.getHcpcs(), row.getLoVersion(), e.getVersionStarted()});
                }
                if (0 >= e.getVersionEnded() || e.getVersionEnded() >= row.getHiVersion()) continue;
                abort = true;
                logger.error("Latest version of HCPCS \"{}\" in Data_HCPCS table (version \"{}\") is later than hardcoded APC latest version \"{}\".", new Object[]{e.getHcpcs(), row.getHiVersion(), e.getVersionEnded()});
            }
        }
        return abort;
    }
}

