/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.DataRevenueDao;
import gov.cms.oce.dao.data.row.DataRevenueRowInternal;
import gov.cms.oce.dao.data.table.DataRevenueTableInternal;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.LineItemInternalTableData;
import gov.cms.oce.model.internal.RevenueCode;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.StringUtilities;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataRevenueDaoImpl
implements DataRevenueDao {
    private static final Logger logger = LoggerFactory.getLogger(DataRevenueDaoImpl.class);

    @Override
    public final DataRevenueRowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Revenue code parameter value is null/empty.");
            }
            return null;
        }
        Map<DataRevenueTableInternal.DataRevenueTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataRevenueTableInternal.DataRevenueTableKey.class);
        key.put(DataRevenueTableInternal.DataRevenueTableKey.REVENUE_CODE, value);
        DataRevenueTableInternal table = BinaryDataProvider.getInstance().getDataRevenueTable();
        DataRevenueRowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("Revenue code parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataRevenueRowInternal getRow(RevenueCode revenueCode, Short version) {
        return this.getRow(String.valueOf(revenueCode.getValue()), version);
    }

    @Override
    public final void loadData(LineItemInternal line, Short version) {
        if (line.getFlags().anySet(LineFlags.INPUT_EMPTY_REVENUE_CODE, LineFlags.INPUT_INVALID_REVENUE_CODE)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No table data loaded as the revenue code is either blank or invalid.");
            }
        } else {
            DataRevenueRowInternal row = this.getRow(line.getRevenueCode(), version);
            if (row == null) {
                line.getFlags().set(LineFlags.INPUT_INVALID_REVENUE_CODE);
            } else {
                FlagSet<LineFlags> flags = line.getFlags();
                if (row.isNotRecognized()) {
                    flags.set(LineFlags.DATA_REVENUE_NOT_RECOGNIZED);
                }
                if (row.isTherapy()) {
                    flags.set(LineFlags.DATA_REVENUE_THERAPY);
                }
                if (row.isBypassE48()) {
                    flags.set(LineFlags.DATA_REVENUE_BYPASS_E48);
                }
                if (row.isStatutoryExclusion()) {
                    flags.set(LineFlags.DATA_REVENUE_STATUTORY_EXCLUSION);
                }
                if (row.isBundledInBiological()) {
                    flags.set(LineFlags.DATA_REVENUE_BUNDLED_IN_BIOLOGICAL);
                }
                LineItemInternalTableData tableData = line.getTableData();
                tableData.setRevenueCodeStatusIndicator(row.getStatusIndicator());
            }
        }
    }

    @Override
    public final boolean checkHardcodedRevenueCodeSet() {
        boolean abort = false;
        DataRevenueTableInternal table = BinaryDataProvider.getInstance().getDataRevenueTable();
        Map<DataRevenueTableInternal.DataRevenueTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataRevenueTableInternal.DataRevenueTableKey.class);
        for (HardcodedRevenueCodeSet e : HardcodedRevenueCodeSet.values()) {
            key.put(DataRevenueTableInternal.DataRevenueTableKey.REVENUE_CODE, String.valueOf(e.getRevenueCode()));
            List<DataRevenueRowInternal> rowSet = table.getRowInternal(key);
            if (rowSet.isEmpty()) {
                abort = true;
                logger.error("Did not find any rows for revenue code \"{}\" in the Data_Revenue table.", (Object)e.getRevenueCode());
                continue;
            }
            for (DataRevenueRowInternal row : rowSet) {
                if (row.getLoVersion() < e.getVersionStarted()) {
                    abort = true;
                    logger.error("Earliest version of revenue code \"{}\" in Data_Revenue table (version \"{}\") is earlier than hardcoded APC earliest version \"{}\".", new Object[]{e.getRevenueCode(), row.getLoVersion(), e.getVersionStarted()});
                }
                if (0 >= e.getVersionEnded() || e.getVersionEnded() >= row.getHiVersion()) continue;
                abort = true;
                logger.error("Latest version of revenue code \"{}\" in Data_Revenue table (version \"{}\") is later than hardcoded APC latest version \"{}\".", new Object[]{e.getRevenueCode(), row.getHiVersion(), e.getVersionEnded()});
            }
        }
        return abort;
    }
}

