/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscClaimDispositionRowInternal;
import gov.cms.oce.dao.desc.table.DscClaimDispositionTableInternal;
import gov.cms.oce.dao.dsc.DscClaimDispositionDao;
import gov.cms.oce.model.internal.Disposition;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscClaimDispositionDaoImpl
implements DscClaimDispositionDao {
    private static final Logger logger = LoggerFactory.getLogger(DscClaimDispositionDaoImpl.class);

    private final DscClaimDispositionRowInternal getRow(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Edit disposition parameter is null/empty.");
            }
            return null;
        }
        Map<DscClaimDispositionTableInternal.DscClaimDispositionTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscClaimDispositionTableInternal.DscClaimDispositionTableKey.class);
        key.put(DscClaimDispositionTableInternal.DscClaimDispositionTableKey.ID, value);
        DscClaimDispositionTableInternal table = BinaryDescriptionProvider.getInstance().getDscClaimDispositionTable();
        return table.getRowInternal(key, version);
    }

    @Override
    public final String getName(String value, Short version) {
        DscClaimDispositionRowInternal row = this.getRow(value, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Name for claim disposition \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getName());
    }

    @Override
    public final String getDescription(String value, Short version) {
        DscClaimDispositionRowInternal row = this.getRow(value, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for claim disposition \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(Disposition disposition, Short version) {
        String description = this.getDescription(String.valueOf(disposition.getValue()), version);
        disposition.setDescription(description);
        return description;
    }

    private final DscClaimDispositionRowInternal getLatestRow(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Edit disposition parameter is null/empty.");
            }
            return null;
        }
        Map<DscClaimDispositionTableInternal.DscClaimDispositionTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscClaimDispositionTableInternal.DscClaimDispositionTableKey.class);
        key.put(DscClaimDispositionTableInternal.DscClaimDispositionTableKey.ID, value);
        DscClaimDispositionTableInternal table = BinaryDescriptionProvider.getInstance().getDscClaimDispositionTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscClaimDispositionRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return row;
        }
        return null;
    }

    @Override
    public final String getLatestName(String value) {
        DscClaimDispositionRowInternal row = this.getLatestRow(value);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Name for claim disposition \"{}\" is missing from table.", (Object)value);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getName());
    }

    @Override
    public final String getLatestDescription(String value) {
        DscClaimDispositionRowInternal row = this.getLatestRow(value);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for claim disposition \"{}\" is missing from table.", (Object)value);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getLatestDescription(Disposition disposition) {
        String description = this.getLatestDescription(String.valueOf(disposition.getValue()));
        disposition.setDescription(description);
        return description;
    }
}

