/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscClaimDispositionValueRowInternal;
import gov.cms.oce.dao.desc.table.DscClaimDispositionValueTableInternal;
import gov.cms.oce.dao.dsc.DscClaimDispositionValueDao;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscClaimDispositionValueDaoImpl
implements DscClaimDispositionValueDao {
    private static final Logger logger = LoggerFactory.getLogger(DscClaimDispositionValueDaoImpl.class);

    @Override
    public final String getDescription(String claimDispositionId, String value, Short version) {
        if ("".equals(claimDispositionId) || "".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Claim Disposition ID or value parameter is null/empty.");
            }
            return "";
        }
        Map<DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.class);
        key.put(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.CLAIM_DISPOSITION_ID, claimDispositionId);
        key.put(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.VALUE, value);
        DscClaimDispositionValueTableInternal table = BinaryDescriptionProvider.getInstance().getDscClaimDispositionValueTable();
        DscClaimDispositionValueRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for Claim Disposition ID/Value \"{}\"/\"{}\" is missing from table.", (Object)claimDispositionId, (Object)value);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getLatestDescription(String claimDispositionId, String value) {
        if ("".equals(claimDispositionId) || "".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Claim Disposition ID or value parameter is null/empty.");
            }
            return "";
        }
        Map<DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.class);
        key.put(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.CLAIM_DISPOSITION_ID, claimDispositionId);
        key.put(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.VALUE, value);
        DscClaimDispositionValueTableInternal table = BinaryDescriptionProvider.getInstance().getDscClaimDispositionValueTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscClaimDispositionValueRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for Claim Disposition ID/Value \"{}\"/\"{}\" is missing from table.", (Object)claimDispositionId, (Object)value);
        }
        return "";
    }
}

