/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscDiscountFormulaRowInternal;
import gov.cms.oce.dao.desc.table.DscDiscountFormulaTableInternal;
import gov.cms.oce.dao.dsc.DscDiscountFormulaDao;
import gov.cms.oce.model.internal.DiscountFormula;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscDiscountFormulaDaoImpl
implements DscDiscountFormulaDao {
    private static final Logger logger = LoggerFactory.getLogger(DscDiscountFormulaDaoImpl.class);

    @Override
    public final String getDescription(String discountFormula, Short version) {
        if ("".equals(discountFormula)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Discount key parameter is null/empty.");
            }
            return "";
        }
        Map<DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey.class);
        key.put(DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey.DISCOUNT_KEY, discountFormula);
        DscDiscountFormulaTableInternal table = BinaryDescriptionProvider.getInstance().getDscDiscountFormulaTable();
        DscDiscountFormulaRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for claim processing flag \"{}\" is missing from table for version \"{}\".", (Object)discountFormula, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(DiscountFormula discountFormula, Short version) {
        String description = this.getDescription(String.valueOf(discountFormula.getValue()), version);
        discountFormula.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String discountFormula) {
        if ("".equals(discountFormula)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Discount key parameter is null/empty.");
            }
            return "";
        }
        Map<DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey.class);
        key.put(DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey.DISCOUNT_KEY, discountFormula);
        DscDiscountFormulaTableInternal table = BinaryDescriptionProvider.getInstance().getDscDiscountFormulaTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscDiscountFormulaRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)discountFormula);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(DiscountFormula discountFormula) {
        String description = this.getLatestDescription(String.valueOf(discountFormula.getValue()));
        discountFormula.setDescription(description);
        return description;
    }
}

