/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscRevenueRowInternal;
import gov.cms.oce.dao.desc.table.DscRevenueTableInternal;
import gov.cms.oce.dao.dsc.DscRevenueDao;
import gov.cms.oce.model.internal.RevenueCode;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscRevenueDaoImpl
implements DscRevenueDao {
    private static final Logger logger = LoggerFactory.getLogger(DscRevenueDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Revenue code parameter is null/empty.");
            }
            return "";
        }
        Map<DscRevenueTableInternal.DscRevenueTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscRevenueTableInternal.DscRevenueTableKey.class);
        key.put(DscRevenueTableInternal.DscRevenueTableKey.REVENUE_CODE, value);
        DscRevenueTableInternal table = BinaryDescriptionProvider.getInstance().getDscRevenueTable();
        DscRevenueRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for revenue code \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(RevenueCode revenueCode, Short version) {
        String description = this.getDescription(String.valueOf(revenueCode.getValue()), version);
        revenueCode.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Revenue code parameter is null/empty.");
            }
            return "";
        }
        Map<DscRevenueTableInternal.DscRevenueTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscRevenueTableInternal.DscRevenueTableKey.class);
        key.put(DscRevenueTableInternal.DscRevenueTableKey.REVENUE_CODE, value);
        DscRevenueTableInternal table = BinaryDescriptionProvider.getInstance().getDscRevenueTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscRevenueRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(RevenueCode revenueCode) {
        String description = this.getLatestDescription(String.valueOf(revenueCode.getValue()));
        revenueCode.setDescription(description);
        return description;
    }
}

