/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.row;

import gov.cms.oce.model.internal.ClaimDate;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionRangeRowInternal {
    private static final Logger logger = LoggerFactory.getLogger(VersionRangeRowInternal.class);
    private final short version;
    private final int dateStarted;
    private final int dateEnded;
    private final String versionId;

    private VersionRangeRowInternal() {
        this(0, 0, 0, null);
    }

    public VersionRangeRowInternal(short version, int dateStarted, int dateEnded, String versionId) {
        this.version = version;
        this.dateStarted = dateStarted;
        this.dateEnded = dateEnded;
        this.versionId = versionId;
    }

    public final short getVersion() {
        return this.version;
    }

    public final int getDateStarted() {
        return this.dateStarted;
    }

    public final int getDateEnded() {
        return this.dateEnded;
    }

    public final String getVersionId() {
        return this.versionId;
    }

    public LocalDate getDateStartedAsDate() {
        return ClaimDate.getDateForInteger(this.dateStarted);
    }

    public LocalDate getDateEndedAsDate() {
        return ClaimDate.getDateForInteger(this.dateEnded);
    }
}

