/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.DataCapcRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataCapcTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(DataCapcTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<DataCapcRowInternal>> table;

    private DataCapcTableInternal() {
        this(null);
    }

    public DataCapcTableInternal(Map<String, List<DataCapcRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<DataCapcRowInternal> getRowInternal(Map<DataCapcTableKey, String> tableKey) {
        List<DataCapcRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final DataCapcRowInternal getRowInternal(Map<DataCapcTableKey, String> tableKey, short version) {
        for (DataCapcRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum DataCapcTableKey {
        HCPCS;

    }
}

