/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.DataDx10RowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataDx10TableInternal {
    private static final Logger logger = LoggerFactory.getLogger(DataDx10TableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<DataDx10RowInternal>> table;

    private DataDx10TableInternal() {
        this(null);
    }

    public DataDx10TableInternal(Map<String, List<DataDx10RowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<DataDx10RowInternal> getRowInternal(Map<DataDx10TableKey, String> tableKey) {
        List<DataDx10RowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final DataDx10RowInternal getRowInternal(Map<DataDx10TableKey, String> tableKey, short version) {
        for (DataDx10RowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum DataDx10TableKey {
        DIAGNOSIS;

    }
}

