/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.DataRevenueRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataRevenueTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(DataRevenueTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<DataRevenueRowInternal>> table;

    private DataRevenueTableInternal() {
        this(null);
    }

    public DataRevenueTableInternal(Map<String, List<DataRevenueRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<DataRevenueRowInternal> getRowInternal(Map<DataRevenueTableKey, String> tableKey) {
        List<DataRevenueRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final DataRevenueRowInternal getRowInternal(Map<DataRevenueTableKey, String> tableKey, short version) {
        for (DataRevenueRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum DataRevenueTableKey {
        REVENUE_CODE;

    }
}

