/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.MapCapcRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapCapcTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(MapCapcTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<MapCapcRowInternal>> table;

    private MapCapcTableInternal() {
        this(null);
    }

    public MapCapcTableInternal(Map<String, List<MapCapcRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<MapCapcRowInternal> getRowInternal(Map<MapCapcTableKey, String> tableKey) {
        List<MapCapcRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final MapCapcRowInternal getRowInternal(Map<MapCapcTableKey, String> tableKey, short version) {
        for (MapCapcRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum MapCapcTableKey {
        CODE1,
        CODE2;

    }
}

