/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.data.row.VersionRangeRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.VersionRange;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionRangeTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(VersionRangeTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private final List<VersionRangeRowInternal> table;

    private VersionRangeTableInternal() {
        this(null);
    }

    public VersionRangeTableInternal(List<VersionRangeRowInternal> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final int getRowCount() {
        return this.table == null ? 0 : this.table.size();
    }

    public final VersionRangeRowInternal getRowInternal(int index) {
        return this.table == null ? null : this.table.get(index);
    }

    public final VersionRangeRowInternal getFirstRowInternal() {
        return this.table == null ? null : this.table.get(0);
    }

    public final VersionRangeRowInternal getLastRowInternal() {
        return this.table == null || this.table.isEmpty() ? null : this.table.get(this.table.size() - 1);
    }

    public final VersionRange getVersionRange() {
        short firstVersion = 0;
        VersionRangeRowInternal firstRow = this.getFirstRowInternal();
        if (firstRow != null) {
            firstVersion = firstRow.getVersion();
        }
        short lastVersion = 0;
        VersionRangeRowInternal lastRow = this.getLastRowInternal();
        if (lastRow != null) {
            lastVersion = lastRow.getVersion();
        }
        return new VersionRange(firstVersion, lastVersion);
    }

    public final VersionRangeRowInternal getRowInternal(Map<VersionRangeTableKey, String> tableKey) {
        int targetDate = Integer.parseInt(tableKey.get((Object)VersionRangeTableKey.TARGET_DATE));
        for (VersionRangeRowInternal row : this.table) {
            if (row.getDateStarted() > targetDate || targetDate > row.getDateEnded()) continue;
            return row;
        }
        return null;
    }

    public static enum VersionRangeTableKey {
        TARGET_DATE;

    }
}

