/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.model.rsc.LogicPhaseFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.FlagSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicPhasePath
implements LogicPhasePath {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogicPhasePath.class);
    private final List<Logic> logicPath = new ArrayList<Logic>();
    private final FlagSet<LogicPhaseFlags> flags = new FlagSet<LogicPhaseFlags>(LogicPhaseFlags.class);

    protected AbstractLogicPhasePath() {
    }

    @Override
    public List<Logic> getLogicPhasePath() {
        return this.logicPath;
    }

    @Override
    public FlagSet<LogicPhaseFlags> getFlags() {
        return this.flags;
    }

    @Override
    public void reset() {
        this.flags.unset((LogicPhaseFlags)new LogicPhaseFlags[]{LogicPhaseFlags.RUN_STARTED, LogicPhaseFlags.RUN_ENDED, LogicPhaseFlags.RUN_SUCCESSFUL, LogicPhaseFlags.LOGIC_PATH_EMPTY, LogicPhaseFlags.LOGIC_PATH_CONTAINS_DUPLICATE_LOGIC_BLOCKS});
    }

    @Override
    public boolean execute(ClaimProcessor processor) {
        boolean abortRequested = false;
        for (Logic logicBlock : this.logicPath) {
            if (!abortRequested) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing \"{}\", abort status: \"{}\"", (Object)logicBlock.getClass().getSimpleName(), (Object)abortRequested);
                }
                try {
                    if (!logicBlock.apply(processor)) continue;
                    Integer returnCode = processor.getInternalClaim().getProcessingInformation().getReturnCode();
                    if (returnCode == null || returnCode.equals(ReturnCode.OK.getCode())) {
                        logger.warn("Logic block \"{}\" aborting without specifying a return code.", (Object)logicBlock.getClass().getSimpleName());
                        processor.getInternalClaim().getProcessingInformation().setReturnCode(ReturnCode.UNSPECIFIED.getCode());
                    }
                    abortRequested = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Abort requested by \"{}\"", (Object)logicBlock.getClass().getSimpleName());
                }
                catch (Exception e) {
                    processor.getInternalClaim().getProcessingInformation().setReturnCode(ReturnCode.UNSPECIFIED.getCode());
                    logger.warn("Unspecified exception thrown by logic block \"{}\". The claim output should be considered unreliable.", (Object)logicBlock.getClass().getSimpleName(), (Object)e);
                }
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Skipping non-mandatory logic \"{}\", abort status: \"{}\"", (Object)logicBlock.getClass().getSimpleName(), (Object)abortRequested);
        }
        return abortRequested;
    }
}

