/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic;

import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicPhasePathFactory;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.NoLogicPhasePathFactoryException;
import gov.cms.oce.logic.UnconfiguredLogicPhasePathException;
import gov.cms.oce.model.rsc.LogicPhaseFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.FlagSet;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicLogicProcessor
implements LogicProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BasicLogicProcessor.class);
    private final Map<LogicPhase, LogicPhasePath> logicPhasePathMap = new EnumMap<LogicPhase, LogicPhasePath>(LogicPhase.class);
    private LogicPhasePathFactory logicPhasePathFactory;

    @Override
    public final LogicPhasePath getLogicPhasePath(LogicPhase logicPhase) {
        return this.logicPhasePathMap.get((Object)logicPhase);
    }

    @Override
    public final void register(LogicPhasePathFactory logicPhasePathFactory) {
        if (this.logicPhasePathFactory == logicPhasePathFactory) {
            if (logger.isDebugEnabled()) {
                logger.debug("LogicPhasePathFactory \"{}\" already registered, reusing.", (Object)logicPhasePathFactory.getClass().getSimpleName());
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering \"{}\" LogicPhasePathFactory.", (Object)logicPhasePathFactory.getClass().getSimpleName());
            }
            this.logicPhasePathFactory = logicPhasePathFactory;
        }
    }

    @Override
    public final void configure(LogicPhase logicPhase, ClaimProcessor claimProcessor) throws NoLogicPhasePathFactoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Configuring \"{}\" phase.", (Object)logicPhase.name());
        }
        if (this.logicPhasePathFactory == null) {
            logger.error("No LogicPhasePathFactory registered with this logic process, can not create LogicPhasePath for phase \"{}\".", (Object)logicPhase);
            throw new NoLogicPhasePathFactoryException("No LogicPhasePathFactory registered with this logic process.");
        }
        LogicPhasePath logicPhasePath = this.getLogicPhasePath(logicPhase);
        if (logicPhasePath == null || logicPhasePath.getFlags().isNotSet(LogicPhaseFlags.RUN_ONCE)) {
            logicPhasePath = this.logicPhasePathFactory.createLogicPhasePath(logicPhase);
            if (logger.isTraceEnabled()) {
                logger.trace("C1. \"{}\" phase, flag states configured=\"{}\" started=\"{}\" ended=\"{}\" successful=\"{}\" run once=\"{}\" rerun=\"{}\".", new Object[]{logicPhase.name(), logicPhasePath.getFlags().isSet(LogicPhaseFlags.CONFIGURED) ? "T" : "F", logicPhasePath.getFlags().isSet(LogicPhaseFlags.RUN_ONCE) ? "T" : "F", logicPhasePath.getFlags().isSet(LogicPhaseFlags.RERUN_IF_UNSUCCESSFUL) ? "T" : "F", logicPhasePath.getFlags().isSet(LogicPhaseFlags.RUN_STARTED) ? "T" : "F", logicPhasePath.getFlags().isSet(LogicPhaseFlags.RUN_SUCCESSFUL) ? "T" : "F", logicPhasePath.getFlags().isSet(LogicPhaseFlags.RUN_ENDED) ? "T" : "F"});
            }
            this.logicPhasePathMap.put(logicPhase, logicPhasePath);
            logicPhasePath.configure(claimProcessor);
            logicPhasePath.getFlags().set(LogicPhaseFlags.CONFIGURED);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Re-using existing \"{}\" phase, the \"run-once\" flag is set.", (Object)logicPhase.name());
        }
    }

    @Override
    public final boolean execute(LogicPhase logicPhase, ClaimProcessor claimProcessor) throws UnconfiguredLogicPhasePathException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing \"{}\" phase.", (Object)logicPhase.name());
        }
        boolean abort = false;
        LogicPhasePath logicPhasePath = this.getLogicPhasePath(logicPhase);
        FlagSet<LogicPhaseFlags> flags = logicPhasePath.getFlags();
        if (logger.isTraceEnabled()) {
            logger.trace("E1. \"{}\" phase, flag states configured=\"{}\" started=\"{}\" ended=\"{}\" successful=\"{}\" run once=\"{}\" rerun=\"{}\".", new Object[]{logicPhase.name(), flags.isSet(LogicPhaseFlags.CONFIGURED) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_ONCE) ? "T" : "F", flags.isSet(LogicPhaseFlags.RERUN_IF_UNSUCCESSFUL) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_STARTED) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_SUCCESSFUL) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_ENDED) ? "T" : "F"});
        }
        if (flags.isNotSet(LogicPhaseFlags.CONFIGURED)) {
            logger.error("LogicPhasePath \"{}\" execute method called prior to configure method.", (Object)logicPhase);
            throw new UnconfiguredLogicPhasePathException("Call configure prior to executing LogicPhasePath.");
        }
        if (flags.allSet(LogicPhaseFlags.RUN_ONCE, LogicPhaseFlags.RERUN_IF_UNSUCCESSFUL) && flags.isNotSet(LogicPhaseFlags.RUN_SUCCESSFUL)) {
            logicPhasePath.reset();
        }
        if (flags.isNotSet(LogicPhaseFlags.RUN_STARTED)) {
            flags.set(LogicPhaseFlags.RUN_STARTED);
            if (logicPhasePath.execute(claimProcessor)) {
                abort = true;
            } else {
                flags.set(LogicPhaseFlags.RUN_SUCCESSFUL);
            }
            flags.set(LogicPhaseFlags.RUN_ENDED);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Skipping \"{}\" phase, either the phase was already run or the \"run-once\" flag is set and the previous run was successful.", (Object)logicPhase.name());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("E2. \"{}\" phase, flag states configured=\"{}\" started=\"{}\" ended=\"{}\" successful=\"{}\" run once=\"{}\" rerun=\"{}\".", new Object[]{logicPhase.name(), flags.isSet(LogicPhaseFlags.CONFIGURED) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_ONCE) ? "T" : "F", flags.isSet(LogicPhaseFlags.RERUN_IF_UNSUCCESSFUL) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_STARTED) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_SUCCESSFUL) ? "T" : "F", flags.isSet(LogicPhaseFlags.RUN_ENDED) ? "T" : "F"});
        }
        return abort;
    }

    @Override
    public final void configureAll(ClaimProcessor claimProcessor) throws NoLogicPhasePathFactoryException {
        for (LogicPhase logicPhase : LogicPhase.values()) {
            this.configure(logicPhase, claimProcessor);
        }
    }

    @Override
    public final boolean executeAll(ClaimProcessor claimProcessor) throws UnconfiguredLogicPhasePathException {
        boolean abort = false;
        for (LogicPhase logicPhase : LogicPhase.values()) {
            if (!this.execute(logicPhase, claimProcessor)) continue;
            abort = true;
        }
        return abort;
    }

    @Override
    public final boolean configureAndExecuteAll(ClaimProcessor claimProcessor) throws NoLogicPhasePathFactoryException, UnconfiguredLogicPhasePathException {
        boolean abort = false;
        for (LogicPhase logicPhase : LogicPhase.values()) {
            this.configure(logicPhase, claimProcessor);
            if (!this.execute(logicPhase, claimProcessor)) continue;
            abort = true;
        }
        return abort;
    }
}

