/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.PaymentAdjustmentFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaymentMethodSection603Override
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(PaymentMethodSection603Override.class);

    PaymentMethodSection603Override() {
    }

    private final boolean reduceDiscount(LineItemInternal line) {
        return !line.matchesHcpcs(HardcodedHcpcsSet.CAPC_OBS_S603_EXCLUSION) && (line.getFlags().isSet(LineFlags.DATA_HCPCS_OVERRIDE_SECTION603) || line.matchesPaymentAdjustmentFlag(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA, PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_COINS_NA, PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA));
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.isOpps() && claim.matchesBillType("13") && claim.getFlags().isSet(ClaimFlags.SECTION603_APPLICABLE)) {
            block18: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                switch (line.getStatusIndicator().getValue()) {
                    case "F": 
                    case "L": {
                        if (!line.isHcpcsModifierPresent("PN")) continue block18;
                        line.getPaymentMethodFlag().setValue("7");
                        continue block18;
                    }
                    case "A": 
                    case "B": 
                    case "C": 
                    case "E": 
                    case "E1": 
                    case "E2": 
                    case "M": 
                    case "W": 
                    case "Y": 
                    case "Z": {
                        continue block18;
                    }
                }
                if (claim.isClaimVersionAfter(73) && line.isNotPackaged() && line.isHcpcsModifierPresent("PO") && line.matchesHcpcs(HardcodedHcpcsSet.CAPC_OBS_S603_EXCLUSION)) {
                    line.getPaymentMethodFlag().setValue("A");
                    continue;
                }
                if (!line.isHcpcsModifierPresent("PN")) continue;
                if (line.matchesStatusIndicator("J1", "J2", "S", "T", "V", "Q1", "Q2", "Q3", "Q4")) {
                    line.getPaymentMethodFlag().setValue(this.reduceDiscount(line) ? "7" : "8");
                    continue;
                }
                if (line.matchesStatusIndicator("H", "R", "U")) {
                    line.getPaymentMethodFlag().setValue("7");
                    continue;
                }
                if (!line.matchesStatusIndicator("P") || !claim.isConditionCodePresent("41")) continue;
                line.getPaymentMethodFlag().setValue("7");
            }
        }
        return false;
    }
}

