/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.dao.data.DataCapcDao;
import gov.cms.oce.dao.data.DataHcpcsDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadHcpcsTableData
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(LoadHcpcsTableData.class);

    LoadHcpcsTableData() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        DataHcpcsDao hcpcsDao = processor.getResourceManager().getDataDaoFactory().getDataHcpcsDao();
        DataCapcDao capcDao = processor.getResourceManager().getDataDaoFactory().getDataCapcDao();
        OceClaimInternal claim = processor.getInternalClaim();
        short version = claim.getVersionAsPrimitive();
        ClaimDate dateEnded = claim.getDateEnded();
        block16: for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (line.getFlags().isSet(LineFlags.INPUT_EMPTY_HCPCS)) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_INVALID_REVENUE_CODE)) continue;
                String revenueCodeStatusIndicator = line.getTableData().getRevenueCodeStatusIndicator().getValue();
                if (revenueCodeStatusIndicator == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("No revenue code SI.");
                    continue;
                }
                switch (revenueCodeStatusIndicator) {
                    case "N": {
                        line.setStatusIndicator("N");
                        line.setPaymentIndicator((byte)9);
                        line.setPackagingFlag((byte)1);
                        if (!claim.getFlags().isNotSet(ClaimFlags.VALID_PROCEDURE_EXISTS)) continue block16;
                        claim.getFlags().set(ClaimFlags.VALID_PROCEDURE_EXISTS);
                        break;
                    }
                    case "E": {
                        line.setStatusIndicator("E");
                        line.setPaymentIndicator((byte)3);
                        break;
                    }
                    case "E1": {
                        line.setStatusIndicator("E1");
                        line.setPaymentIndicator((byte)3);
                        break;
                    }
                    case "E2": {
                        line.setStatusIndicator("E2");
                        line.setPaymentIndicator((byte)3);
                        break;
                    }
                    case "B": {
                        line.setStatusIndicator("B");
                        line.setPaymentIndicator((byte)3);
                        break;
                    }
                    case "F": {
                        line.setStatusIndicator("F");
                        line.setPaymentIndicator((byte)4);
                        break;
                    }
                    default: {
                        line.setStatusIndicator("Z");
                        line.setPaymentIndicator((byte)3);
                    }
                }
                continue;
            }
            hcpcsDao.loadData(line, version, dateEnded);
            if (line.getFlags().isNotSet(LineFlags.INPUT_INVALID_HCPCS)) {
                if (claim.getFlags().isNotSet(ClaimFlags.VALID_PROCEDURE_EXISTS)) {
                    claim.getFlags().set(ClaimFlags.VALID_PROCEDURE_EXISTS);
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_ANTIGEN)) {
                    claim.getFlags().set(ClaimFlags.ANTIGEN);
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_CAST)) {
                    claim.getFlags().set(ClaimFlags.CAST);
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_SPLINT)) {
                    claim.getFlags().set(ClaimFlags.SPLINT);
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_NEGATIVE_PRESSURE_WOUND_THERAPY)) {
                    claim.getFlags().set(ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY);
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_VACCINE)) {
                    claim.getFlags().set(ClaimFlags.VACCINE_ADMINISTRATION);
                }
            }
            capcDao.loadData(line, version);
        }
        return false;
    }
}

