/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapAddonCovidLabDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddonCovidPairLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AddonCovidPairLogic.class);

    AddonCovidPairLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapAddonCovidLabDao dao = processor.getResourceManager().getDataDaoFactory().getMapAddonCovidLabDao();
        short version = claim.getVersionAsPrimitive();
        for (Day day : navigator.getDayList()) {
            boolean conditionSatisfied = false;
            for (LineItemInternal line1 : day.getLineItemList()) {
                if (!line1.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line1.getFlags().isSet(LineFlags.DATA_HCPCS_ADDON_COVID_LAB)) continue;
                if (day.getLineItemList().stream().anyMatch(line2 -> !line1.equals(line2) && line2.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) && dao.getRow(line1, (LineItemInternal)line2, (Short)version) != null)) {
                    conditionSatisfied = true;
                }
                if (conditionSatisfied) continue;
                claim.assignEdit(EditValue.ADDON_COVID_LAB_MISSING_PRIMARY, line1);
            }
        }
        return false;
    }
}

