/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdvanceCarePlanningLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AdvanceCarePlanningLogic.class);

    AdvanceCarePlanningLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        ArrayList<LineItemInternal> advanceCarePlanningCodeList = new ArrayList<LineItemInternal>(5);
        for (Day day : navigator.getDayList()) {
            advanceCarePlanningCodeList.clear();
            boolean annualWellnessVisitPresent = false;
            boolean advanceCarePlanningPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!annualWellnessVisitPresent && line.getFlags().isSet(LineFlags.DATA_HCPCS_ANNUAL_WELLNESS_VISIT)) {
                    annualWellnessVisitPresent = true;
                }
                if (!line.getFlags().noneSet(LineFlags.INPATIENT_LINE, LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_ADVANCE_CARE_PLANNING)) continue;
                if (!advanceCarePlanningPresent && line.matchesHcpcs(HardcodedHcpcsSet.ADVANCE_CARE_PLANNING)) {
                    advanceCarePlanningPresent = true;
                }
                advanceCarePlanningCodeList.add(line);
            }
            if (!annualWellnessVisitPresent || !advanceCarePlanningPresent) continue;
            for (LineItemInternal line : advanceCarePlanningCodeList) {
                OceClaimUtility.setSeparatelyPayable(line);
            }
        }
        return false;
    }
}

