/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.AddonCovidPairLogic;
import gov.cms.oce.logic.processing.AddonDrugPairLogic;
import gov.cms.oce.logic.processing.AddonType1And3PairLogic;
import gov.cms.oce.logic.processing.AdvanceCarePlanningLogic;
import gov.cms.oce.logic.processing.AllogeneicTransplantLogic;
import gov.cms.oce.logic.processing.AssignDefaultApcLogic;
import gov.cms.oce.logic.processing.BilateralMultipleInherentLogic;
import gov.cms.oce.logic.processing.BilateralTerminatedLogic;
import gov.cms.oce.logic.processing.BilateralUnitsModifierConflict85xLogic;
import gov.cms.oce.logic.processing.BilateralUnitsModifierConflictLogic;
import gov.cms.oce.logic.processing.BiosimilarBundledBiologicalLogic;
import gov.cms.oce.logic.processing.BiosimilarLogic;
import gov.cms.oce.logic.processing.BloodLogic;
import gov.cms.oce.logic.processing.BloodProductRevenueCodeConflictLogic;
import gov.cms.oce.logic.processing.BloodServiceMissingProductLogic;
import gov.cms.oce.logic.processing.ClaimAgeLogic;
import gov.cms.oce.logic.processing.ClaimSexLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForDenialLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForReviewLogic;
import gov.cms.oce.logic.processing.CompositeImagingLogic;
import gov.cms.oce.logic.processing.CompositeLdrLogic;
import gov.cms.oce.logic.processing.ComprehensiveApcComplexityAdjustmentLogic;
import gov.cms.oce.logic.processing.ComprehensiveApcPackagingLogic;
import gov.cms.oce.logic.processing.ComprehensiveApcPrimaryEvaluationLogic;
import gov.cms.oce.logic.processing.ComprehensiveObservationLogic;
import gov.cms.oce.logic.processing.ConditionCode41NotAllowedLogic;
import gov.cms.oce.logic.processing.ConditionalClaimLogic;
import gov.cms.oce.logic.processing.ConditionalDayLogic;
import gov.cms.oce.logic.processing.CorneaTransplantLogic;
import gov.cms.oce.logic.processing.CriticalCareClaimLogic;
import gov.cms.oce.logic.processing.CriticalCareDayLogic;
import gov.cms.oce.logic.processing.CsModifierLogic;
import gov.cms.oce.logic.processing.DiagnosisAgeLogic;
import gov.cms.oce.logic.processing.DiagnosisEcodeLogic;
import gov.cms.oce.logic.processing.DiagnosisInvalidLogic;
import gov.cms.oce.logic.processing.DiagnosisManifestationLogic;
import gov.cms.oce.logic.processing.DiagnosisMentalHealthLogic;
import gov.cms.oce.logic.processing.DiagnosisSexLogic;
import gov.cms.oce.logic.processing.DiagnosisUnacceptablePrincipalLogic;
import gov.cms.oce.logic.processing.DirectAdmissionRequiresObservationLogic;
import gov.cms.oce.logic.processing.DmeProcedureLogic;
import gov.cms.oce.logic.processing.DrugBiologicalMissingPayableServiceLogic;
import gov.cms.oce.logic.processing.EducationalOnlyLogic;
import gov.cms.oce.logic.processing.FqhcLogic;
import gov.cms.oce.logic.processing.FqhcNonCoveredLogic;
import gov.cms.oce.logic.processing.HcpcsInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsModifierConflictLogic;
import gov.cms.oce.logic.processing.HcpcsModifierInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsModifierReportedPriorToApprovalLogic;
import gov.cms.oce.logic.processing.HcpcsSexLogic;
import gov.cms.oce.logic.processing.ImplantationDeviceInconsistencyLogic;
import gov.cms.oce.logic.processing.ImplantationDeviceProcedureMissingDevice;
import gov.cms.oce.logic.processing.ImplantationPrimaryCodeRequiredForAddonCodeLogic;
import gov.cms.oce.logic.processing.IncidentalOnlyLogic;
import gov.cms.oce.logic.processing.InformationalOnlyLogic;
import gov.cms.oce.logic.processing.InpatientComprehensiveLogic;
import gov.cms.oce.logic.processing.InpatientDayDeniedLogic;
import gov.cms.oce.logic.processing.InpatientTkaAnesthesiaLogic;
import gov.cms.oce.logic.processing.LabServiceOverrideLogic;
import gov.cms.oce.logic.processing.ManualPricingLogic;
import gov.cms.oce.logic.processing.MentalHealthCompositeLogic;
import gov.cms.oce.logic.processing.MentalHealthNotApprovedPartialHospitalizationLogic;
import gov.cms.oce.logic.processing.MentalHealthPhpNotPayableOutsidePhpLogic;
import gov.cms.oce.logic.processing.MultipleHourlyObservationLogic;
import gov.cms.oce.logic.processing.NcciLogic;
import gov.cms.oce.logic.processing.NonBillableMacLogic;
import gov.cms.oce.logic.processing.NonCoveredHcpcsLogic;
import gov.cms.oce.logic.processing.NonCoveredRevenueCodeLogic;
import gov.cms.oce.logic.processing.NonReportableSiteOfServiceLogic;
import gov.cms.oce.logic.processing.NonStandardCtScanLogic;
import gov.cms.oce.logic.processing.NotPaidByMedicareLogic;
import gov.cms.oce.logic.processing.NotRecognizedByMedicareLogic;
import gov.cms.oce.logic.processing.NotRecognizedByOppsLogic;
import gov.cms.oce.logic.processing.NotSeparatelyPayableServiceLogic;
import gov.cms.oce.logic.processing.ObservationRevenueCodeLogic;
import gov.cms.oce.logic.processing.OffsetDevicePairLogic;
import gov.cms.oce.logic.processing.OffsetDrugBiologicialLogic;
import gov.cms.oce.logic.processing.OffsetRadiopharmaceuticalLogic;
import gov.cms.oce.logic.processing.OffsetTerminatedDeviceLogic;
import gov.cms.oce.logic.processing.OpioidTreatmentLogic;
import gov.cms.oce.logic.processing.OutpatientHospitalCodeOnlyLogic;
import gov.cms.oce.logic.processing.PartialHospitalizationCodeFirstNonMentalHealthDiagnosisLogic;
import gov.cms.oce.logic.processing.PartialHospitalizationCompositeLogic;
import gov.cms.oce.logic.processing.PartialHospitalizationNonMentalHealthDiagnosisLogic;
import gov.cms.oce.logic.processing.PartialHospitalizationServiceHours1Logic;
import gov.cms.oce.logic.processing.PartialHospitalizationServiceHours2Logic;
import gov.cms.oce.logic.processing.QuestionableLogic;
import gov.cms.oce.logic.processing.ReportedAfterNcdTerminationDateLogic;
import gov.cms.oce.logic.processing.ReportedOutsideCmsApprovalPeriodLogic;
import gov.cms.oce.logic.processing.ReportedPriorToFdaApprovalDateLogic;
import gov.cms.oce.logic.processing.ReportedPriorToInitialMarketingDate;
import gov.cms.oce.logic.processing.ReportedPriorToNdaApprovalDateLogic;
import gov.cms.oce.logic.processing.RevenueCodeInvalidLogic;
import gov.cms.oce.logic.processing.RevenueCodeNotRecognizedLogic;
import gov.cms.oce.logic.processing.RevenueCodeRequiresHcpcsLogic;
import gov.cms.oce.logic.processing.RhcModifierConflictLogic;
import gov.cms.oce.logic.processing.SameDayEandMSurgeryLogic;
import gov.cms.oce.logic.processing.SameDayMultipleMedicalVisitsLogic;
import gov.cms.oce.logic.processing.Section603Edit131xLogic;
import gov.cms.oce.logic.processing.Section603Edit76xLogic;
import gov.cms.oce.logic.processing.Section603PhpLogic;
import gov.cms.oce.logic.processing.Section603ReassignmentLogic;
import gov.cms.oce.logic.processing.SeparateProcedureNotPaidLogic;
import gov.cms.oce.logic.processing.SkinSubstitute2Logic;
import gov.cms.oce.logic.processing.SometimesTherapyLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionHcpcsLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionRevenueCodeLogic;
import gov.cms.oce.logic.processing.TokenChargesDrugLogic;
import gov.cms.oce.logic.processing.TokenChargesEditLogic;
import gov.cms.oce.logic.processing.TokenChargesPackagingLogic;
import gov.cms.oce.logic.processing.TraumaResponseCodeRequiresRevenueCodeLogic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillTypeMasterLogicPath
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BillTypeMasterLogicPath.class);

    BillTypeMasterLogicPath() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        logicPath.add(new ConditionCode41NotAllowedLogic());
        logicPath.add(new ClaimSubmittedForDenialLogic());
        if (claim.isOpps()) {
            logicPath.add(new ComprehensiveApcPrimaryEvaluationLogic());
        }
        logicPath.add(new LabServiceOverrideLogic());
        logicPath.add(new NonStandardCtScanLogic());
        logicPath.add(new OutpatientHospitalCodeOnlyLogic());
        if (claim.isOpps()) {
            logicPath.add(new AssignDefaultApcLogic());
            if (claim.isClaimVersionAfter(69)) {
                logicPath.add(new InpatientTkaAnesthesiaLogic());
            }
            logicPath.add(new InpatientComprehensiveLogic());
            logicPath.add(new InpatientDayDeniedLogic());
            logicPath.add(new EducationalOnlyLogic());
        }
        logicPath.add(new IncidentalOnlyLogic());
        if (claim.isClaimVersionAfter(61)) {
            logicPath.add(new MultipleHourlyObservationLogic());
        }
        if (claim.isClaimVersionAfter(77)) {
            logicPath.add(new OpioidTreatmentLogic());
        }
        if (claim.isClaimVersionAfter(70)) {
            if (claim.isClaimVersionAfter(81)) {
                logicPath.add(new AddonCovidPairLogic());
            }
            if (claim.isNonOpps()) {
                logicPath.add(new AddonType1And3PairLogic());
                logicPath.add(new AddonDrugPairLogic());
            }
        }
        if (claim.isOpps()) {
            logicPath.add(new SometimesTherapyLogic());
            if (claim.isClaimVersionAfter(61)) {
                logicPath.add(new AdvanceCarePlanningLogic());
            }
        }
        logicPath.add(new FqhcNonCoveredLogic());
        logicPath.add(new FqhcLogic());
        logicPath.add(new RhcModifierConflictLogic());
        if (OceClaimUtility.isCsModifierApplicable(claim)) {
            logicPath.add(new CsModifierLogic());
        }
        logicPath.add(new ClaimAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new ClaimSexLogic());
        }
        logicPath.add(new DiagnosisInvalidLogic());
        logicPath.add(new DiagnosisAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new DiagnosisSexLogic());
        }
        logicPath.add(new DiagnosisEcodeLogic());
        if (claim.isOpps()) {
            logicPath.add(new DiagnosisMentalHealthLogic());
        }
        if (claim.isClaimVersionAfter(56)) {
            logicPath.add(new DiagnosisManifestationLogic());
            if (claim.isClaimVersionAfter(76)) {
                logicPath.add(new DiagnosisUnacceptablePrincipalLogic());
            }
        }
        logicPath.add(new RevenueCodeInvalidLogic());
        logicPath.add(new ObservationRevenueCodeLogic());
        logicPath.add(new RevenueCodeNotRecognizedLogic());
        if (claim.isClaimVersionAfter(61)) {
            logicPath.add(new BiosimilarLogic());
        }
        logicPath.add(new BiosimilarBundledBiologicalLogic());
        logicPath.add(new ReportedPriorToInitialMarketingDate());
        if (claim.isOpps() && claim.isClaimVersionAfter(65)) {
            logicPath.add(new Section603Edit131xLogic());
            logicPath.add(new Section603ReassignmentLogic());
        }
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new HcpcsSexLogic());
        }
        logicPath.add(new ReportedOutsideCmsApprovalPeriodLogic());
        logicPath.add(new InformationalOnlyLogic());
        logicPath.add(new NonCoveredHcpcsLogic());
        logicPath.add(new QuestionableLogic());
        if (claim.isOpps()) {
            logicPath.add(new NotPaidByMedicareLogic());
        }
        logicPath.add(new NotRecognizedByMedicareLogic());
        if (claim.isOpps()) {
            logicPath.add(new NotRecognizedByOppsLogic());
        }
        logicPath.add(new StatutoryExclusionHcpcsLogic());
        logicPath.add(new ClaimSubmittedForReviewLogic());
        logicPath.add(new BloodServiceMissingProductLogic());
        logicPath.add(new DrugBiologicalMissingPayableServiceLogic());
        logicPath.add(new RevenueCodeRequiresHcpcsLogic());
        logicPath.add(new NonCoveredRevenueCodeLogic());
        logicPath.add(new StatutoryExclusionRevenueCodeLogic());
        logicPath.add(new HcpcsInvalidLogic());
        if (claim.isClaimVersionAfter(61)) {
            logicPath.add(new CorneaTransplantLogic());
        }
        logicPath.add(new AllogeneicTransplantLogic());
        if (claim.isOpps()) {
            logicPath.add(new BloodProductRevenueCodeConflictLogic());
            logicPath.add(new BloodLogic());
        }
        logicPath.add(new HcpcsModifierInvalidLogic());
        logicPath.add(new HcpcsModifierReportedPriorToApprovalLogic());
        logicPath.add(new HcpcsModifierConflictLogic());
        if (claim.isOpps()) {
            logicPath.add(new BilateralTerminatedLogic());
            logicPath.add(new BilateralUnitsModifierConflictLogic());
        } else {
            logicPath.add(new BilateralUnitsModifierConflict85xLogic());
        }
        logicPath.add(new NcciLogic());
        if (claim.isOpps()) {
            logicPath.add(new ManualPricingLogic());
        }
        logicPath.add(new ReportedPriorToFdaApprovalDateLogic());
        logicPath.add(new ReportedPriorToNdaApprovalDateLogic());
        logicPath.add(new ReportedAfterNcdTerminationDateLogic());
        if (claim.isOpps()) {
            logicPath.add(new TraumaResponseCodeRequiresRevenueCodeLogic());
        }
        logicPath.add(new NonReportableSiteOfServiceLogic());
        if (claim.isOpps()) {
            logicPath.add(new PartialHospitalizationNonMentalHealthDiagnosisLogic());
            logicPath.add(new PartialHospitalizationCodeFirstNonMentalHealthDiagnosisLogic());
            logicPath.add(new MentalHealthNotApprovedPartialHospitalizationLogic());
            logicPath.add(new PartialHospitalizationCompositeLogic());
            if (claim.isClaimVersionAfter(75)) {
                logicPath.add(new PartialHospitalizationServiceHours2Logic());
            } else if (claim.isClaimVersionAfter(68)) {
                logicPath.add(new PartialHospitalizationServiceHours1Logic());
            }
            logicPath.add(new MentalHealthPhpNotPayableOutsidePhpLogic());
            logicPath.add(new MentalHealthCompositeLogic());
            logicPath.add(new Section603Edit76xLogic());
            logicPath.add(new Section603PhpLogic());
            if (claim.isClaimVersionBefore(66)) {
                logicPath.add(new ConditionalDayLogic());
                logicPath.add(new CriticalCareDayLogic());
            } else {
                logicPath.add(new ConditionalClaimLogic());
                logicPath.add(new CriticalCareClaimLogic());
            }
            if (claim.isClaimVersionBefore(70)) {
                logicPath.add(new CompositeLdrLogic());
            }
            logicPath.add(new CompositeImagingLogic());
            logicPath.add(new ComprehensiveApcPrimaryEvaluationLogic());
        }
        logicPath.add(new DmeProcedureLogic());
        logicPath.add(new NonBillableMacLogic());
        if (claim.isOpps()) {
            logicPath.add(new ComprehensiveObservationLogic());
            logicPath.add(new DirectAdmissionRequiresObservationLogic());
            logicPath.add(new ImplantationDeviceInconsistencyLogic());
            logicPath.add(new ImplantationDeviceProcedureMissingDevice());
            if (claim.isClaimVersionBefore(67)) {
                logicPath.add(new ImplantationPrimaryCodeRequiredForAddonCodeLogic());
            }
            logicPath.add(new TokenChargesEditLogic());
            logicPath.add(new SeparateProcedureNotPaidLogic());
            logicPath.add(new SkinSubstitute2Logic());
        }
        logicPath.add(new BilateralMultipleInherentLogic());
        if (claim.isOpps()) {
            logicPath.add(new ComprehensiveApcComplexityAdjustmentLogic());
            logicPath.add(new ComprehensiveApcPackagingLogic());
            logicPath.add(new SameDayEandMSurgeryLogic());
            if (!claim.isConditionCodePresent("G0")) {
                logicPath.add(new SameDayMultipleMedicalVisitsLogic());
            }
            logicPath.add(new TokenChargesPackagingLogic());
            if (claim.isClaimVersionAfter(83)) {
                logicPath.add(new TokenChargesDrugLogic());
            }
            if (claim.isClaimVersionAfter(61)) {
                logicPath.add(new OffsetDevicePairLogic());
                logicPath.add(new OffsetTerminatedDeviceLogic());
                logicPath.add(new OffsetRadiopharmaceuticalLogic());
                logicPath.add(new OffsetDrugBiologicialLogic());
            }
            logicPath.add(new NotSeparatelyPayableServiceLogic());
        }
        return false;
    }
}

