/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapCapcDao;
import gov.cms.oce.dao.data.row.MapCapcRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComprehensiveApcComplexityAdjustmentLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ComprehensiveApcComplexityAdjustmentLogic.class);

    ComprehensiveApcComplexityAdjustmentLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.isPrimaryComprehensiveChosen() && claim.getPrimaryComprehensive().getFlags().isSet(LineFlags.DATA_CAPC_COMPLEXITY_ADJUSTMENT) && claim.getFlags().isNotSet(ClaimFlags.SUPPRESS_COMPLEXITY_ADJUSTMENT)) {
            short version = claim.getVersionAsPrimitive();
            MapCapcDao mapCapcDao = processor.getResourceManager().getDataDaoFactory().getMapCapcDao();
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (LineItemInternal line : navigator.getLineItemList()) {
                MapCapcRowInternal row;
                if (line.equals(claim.getPrimaryComprehensive()) && !claim.getPrimaryComprehensive().isUnitsGreaterThanOne() && !claim.getPrimaryComprehensive().isHcpcsModifierPresent("50") || (row = mapCapcDao.getRow(claim.getPrimaryComprehensive(), line, (Short)version)) == null) continue;
                Apc complexityAdjustedApc = Apc.create(row.getApc());
                OceClaimUtility.assignApc(processor, claim.getPrimaryComprehensive(), complexityAdjustedApc);
                break;
            }
        }
        return false;
    }
}

