/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComprehensiveApcPackagingLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ComprehensiveApcPackagingLogic.class);

    ComprehensiveApcPackagingLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        ClaimDate midQuarterTerminationDate = this.getMidQuarterTerminationDate(claim);
        if (claim.isPrimaryComprehensiveChosen() && (claim.getPrimaryComprehensive().getFlags().isNotSet(LineFlags.OBSERVATION_VISIT) || !claim.isStatusIndicatorPresent("T"))) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (claim.getPrimaryComprehensive() == line) {
                    OceClaimUtility.reduceUnits(claim.getPrimaryComprehensive());
                } else if (line.getFlags().isSet(LineFlags.DATA_HCPCS_CAPC_SRS_PLAN_AND_PREP) && claim.getPrimaryComprehensive().getFlags().isSet(LineFlags.DATA_APC_CAPC_SRS)) {
                    if (line.matchesStatusIndicatorQ()) {
                        OceClaimUtility.assignDefaultApc(processor, line);
                    }
                } else if (HardcodedApcSet.matchesApc(claim.getPrimaryComprehensive().getPaymentApc(), HardcodedApcSet.CAPC_INPATIENT_APC) && line.matchesStatusIndicator("B", "E", "E1", "E2", "C", "M")) {
                    claim.assignEdit(EditValue.NON_COVERED_INPATIENT_SERVICE, line);
                } else if (midQuarterTerminationDate != null && line.getFlags().isSet(LineFlags.DATA_HCPCS_CMS_MID_QUARTER_TERMINATION_BYPASS) && midQuarterTerminationDate.getValueAsDate().isBefore(line.getServiceDate().getValueAsDate())) {
                    OceClaimUtility.packageLine(line);
                } else if (!(line.getFlags().anySet(LineFlags.DATA_HCPCS_CAPC_EXCLUSION, LineFlags.SEPARATELY_PAYABLE_THERAPY, LineFlags.S603_OVERRIDDEN) || line.matchesStatusIndicator("B", "C", "E", "E1", "E2", "F", "G", "H", "L", "M", "N", "U") || HardcodedRevenueCodeSet.isBloodProduct(line.getRevenueCode()) && line.getFlags().anySet(LineFlags.DATA_HCPCS_PACKED_RED_CELLS, LineFlags.DATA_HCPCS_WHOLE_BLOOD))) {
                    OceClaimUtility.packageLine(line);
                }
                if ("00".equals(line.getCompositeAdjustmentFlag().getValue())) continue;
                line.setCompositeAdjustmentFlag("00");
            }
        }
        return false;
    }

    private ClaimDate getMidQuarterTerminationDate(OceClaimInternal claim) {
        for (ValueCode code : claim.getValueCodeInputList().getValue()) {
            if (!"Z9".equals(code.getCode())) continue;
            ClaimDate date = code.getValueAsDate();
            if (!date.isValid()) {
                date = claim.getDateStarted();
            }
            return date;
        }
        return null;
    }
}

