/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CriticalCareClaimLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CriticalCareClaimLogic.class);

    CriticalCareClaimLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        boolean claimHas59OrXMod = claim.isHcpcsModifierPresent("59", "XE", "XP", "XS", "XU");
        boolean criticalCarePresent = false;
        boolean criticalCareAncillaryPresent = false;
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (line.getFlags().isSet(LineFlags.DATA_HCPCS_TRAUMA_CRITICAL_CARE)) {
                criticalCarePresent = true;
                if (!criticalCareAncillaryPresent) continue;
                break;
            }
            if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY) || !line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed()) continue;
            criticalCareAncillaryPresent = true;
            if (!criticalCarePresent) continue;
            break;
        }
        if (criticalCarePresent && criticalCareAncillaryPresent) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed()) continue;
                if (claimHas59OrXMod && line.getFlags().isNotSet(LineFlags.DATA_HCPCS_STV_PACKAGED)) {
                    OceClaimUtility.setConditionalApc(line);
                    continue;
                }
                OceClaimUtility.packageLine(line);
                line.getFlags().set(LineFlags.COMPOSITE_LINE);
            }
        } else {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed()) continue;
                OceClaimUtility.setConditionalApc(line);
            }
        }
        return false;
    }
}

