/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EducationalOnlyLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(EducationalOnlyLogic.class);

    EducationalOnlyLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            if (day.isEmpty()) continue;
            boolean educationalOnlyPresent = false;
            boolean nonEducationalPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_EDUCATIONAL)) {
                    if (educationalOnlyPresent) continue;
                    educationalOnlyPresent = true;
                    continue;
                }
                if (nonEducationalPresent) continue;
                nonEducationalPresent = true;
            }
            if (!educationalOnlyPresent || nonEducationalPresent) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                claim.assignEdit(EditValue.ONLY_MENTAL_HEALTH_EDUCATION_PRESENT, line);
            }
            if (claim.getFlags().isNotSet(ClaimFlags.HAS_EDIT_35)) {
                claim.getFlags().set(ClaimFlags.HAS_EDIT_35);
            }
            day.getFlags().set(DayFlags.HAS_EDIT_35);
        }
        return false;
    }
}

