/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapFqhcVisitDao;
import gov.cms.oce.dao.data.row.MapFqhcVisitRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.model.rsc.PaymentAdjustmentFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FqhcLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(FqhcLogic.class);

    FqhcLogic() {
    }

    private final boolean isPairingComplete(List<FqhcVisit> fqhcVisitList) {
        for (FqhcVisit fqhcVisit : fqhcVisitList) {
            if (fqhcVisit.owner != null) continue;
            return false;
        }
        return true;
    }

    private final void addFqhcVisit(List<FqhcVisit> fqhcVisitList, LineItemInternal line, int rank) {
        line.getTableData().setFqhcRank(rank);
        boolean changed = false;
        ListIterator<FqhcVisit> i = fqhcVisitList.listIterator();
        while (!changed && i.hasNext()) {
            if (rank >= i.next().line.getTableData().getFqhcRank()) continue;
            i.previous();
            i.add(new FqhcVisit(line));
            changed = true;
        }
        if (!changed) {
            fqhcVisitList.add(new FqhcVisit(line));
        }
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        short version = claim.getVersionAsPrimitive();
        MapFqhcVisitDao dao = processor.getResourceManager().getDataDaoFactory().getMapFqhcVisitDao();
        boolean grandfatheredTribalFqhc = claim.isConditionCodePresent("MG");
        for (Day day : navigator.getDayList()) {
            boolean telehealth = false;
            boolean isOpioidUseDisorder = false;
            boolean hasOfficeOpioidTreatmentCodes = false;
            boolean grandfatheredTribalDone = false;
            boolean onlyNonCoveredPresent = true;
            boolean advancedCarePlanningComponent = false;
            boolean isChronicCare = false;
            ArrayList<FqhcVisit> fqhcVisitList = new ArrayList<FqhcVisit>();
            ArrayList<QualifyingVisit> qualifyingVisitList = new ArrayList<QualifyingVisit>();
            for (LineItemInternal lineItemInternal : day.getLineItemList()) {
                QualifyingVisit qualifyingVisit;
                if (!lineItemInternal.isEditPresent(EditValue.FQHC_NON_COVERED_SERVICE)) {
                    onlyNonCoveredPresent = false;
                }
                if (claim.matchesBillType("770")) {
                    if (!lineItemInternal.matchesActionFlag(0)) continue;
                    lineItemInternal.setActionFlag((byte)5);
                    continue;
                }
                if (lineItemInternal.matchesActionFlag(5) || !lineItemInternal.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                HardcodedHcpcsSet fqhcVisitHcpcs = HardcodedHcpcsSet.getFlag(lineItemInternal.getHcpcs().getValue());
                boolean potentialQualifyingVisit = true;
                if (fqhcVisitHcpcs != null) {
                    switch (fqhcVisitHcpcs) {
                        case FQHC_MED_NEW_PATIENT: {
                            this.addFqhcVisit(fqhcVisitList, lineItemInternal, 2);
                            potentialQualifyingVisit = false;
                            break;
                        }
                        case FQHC_MED_EST_PATIENT: {
                            this.addFqhcVisit(fqhcVisitList, lineItemInternal, 3);
                            potentialQualifyingVisit = false;
                            break;
                        }
                        case FQHC_IPPE_AWE: {
                            this.addFqhcVisit(fqhcVisitList, lineItemInternal, 1);
                            potentialQualifyingVisit = false;
                            break;
                        }
                        case FQHC_MH_NEW_PATIENT: {
                            this.addFqhcVisit(fqhcVisitList, lineItemInternal, 4);
                            potentialQualifyingVisit = false;
                            break;
                        }
                        case FQHC_MH_EST_PATIENT: {
                            this.addFqhcVisit(fqhcVisitList, lineItemInternal, 5);
                            potentialQualifyingVisit = false;
                            break;
                        }
                        case TELEHEALTH_Q3041: {
                            telehealth = true;
                            break;
                        }
                        case TELEHEALTH_G2025: {
                            telehealth = true;
                            break;
                        }
                        case OPIOID_USE_DISORDER_G2172: {
                            isOpioidUseDisorder = true;
                            potentialQualifyingVisit = false;
                            break;
                        }
                        case OPIOID_USE_DISORDER_G2086: 
                        case OPIOID_USE_DISORDER_G2087: 
                        case OPIOID_USE_DISORDER_G2088: {
                            hasOfficeOpioidTreatmentCodes = true;
                            break;
                        }
                    }
                }
                if (lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_FQHC_CHRONIC_CARE)) {
                    isChronicCare = true;
                }
                if (lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_ANNUAL_WELLNESS_VISIT)) {
                    advancedCarePlanningComponent = true;
                }
                if (!potentialQualifyingVisit) continue;
                boolean exists = false;
                for (QualifyingVisit qualifyingVisit2 : qualifyingVisitList) {
                    if (!lineItemInternal.matchesHcpcs(qualifyingVisit2.line.getHcpcs())) continue;
                    qualifyingVisit2.units = qualifyingVisit2.units + lineItemInternal.getUnitsAsPrimitive();
                    exists = true;
                    break;
                }
                if (exists) continue;
                QualifyingVisit qualifyingVisit2 = qualifyingVisit = new QualifyingVisit(lineItemInternal);
                qualifyingVisit2.units = qualifyingVisit2.units + lineItemInternal.getUnitsAsPrimitive();
                qualifyingVisitList.add(qualifyingVisit);
            }
            LineItemInternal medicalVisit = null;
            LineItemInternal mentalHealthVisit = null;
            LineItemInternal additionalVisit = null;
            boolean includeAdditionalMedicalVisit = false;
            if (!fqhcVisitList.isEmpty()) {
                for (FqhcVisit fqhcVisit : fqhcVisitList) {
                    boolean found = false;
                    for (QualifyingVisit qualifyingVisit4 : qualifyingVisitList) {
                        MapFqhcVisitRowInternal row = dao.getRow(fqhcVisit.line, qualifyingVisit4.line, (Short)version);
                        if (row == null) continue;
                        qualifyingVisit4.fqhcVisitList.add(fqhcVisit);
                        found = true;
                    }
                    if (found) continue;
                    claim.assignEdit(EditValue.FQHC_QUALIFYING_VISIT_MISSING, fqhcVisit.line);
                }
                Iterator i = qualifyingVisitList.iterator();
                while (i.hasNext()) {
                    if (!((QualifyingVisit)i.next()).fqhcVisitList.isEmpty()) continue;
                    i.remove();
                }
                block17: for (QualifyingVisit qualifyingVisit : qualifyingVisitList) {
                    for (FqhcVisit fqhcVisit : qualifyingVisit.fqhcVisitList) {
                        if (fqhcVisit.owner == null && qualifyingVisit.isAvailable()) {
                            fqhcVisit.owner = qualifyingVisit;
                            qualifyingVisit.chosenFqhcVisitList.add(fqhcVisit);
                            qualifyingVisit.consume();
                        }
                        if (!this.isPairingComplete(fqhcVisitList)) continue;
                        continue block17;
                    }
                }
                for (QualifyingVisit qualifyingVisit : qualifyingVisitList) {
                    for (FqhcVisit fqhcVisit : qualifyingVisit.fqhcVisitList) {
                        if (fqhcVisit.owner != null) continue;
                        claim.assignEdit(EditValue.FQHC_QUALIFYING_VISIT_MISSING, fqhcVisit.line);
                    }
                }
                boolean j = true;
                for (FqhcVisit fqhcVisit : fqhcVisitList) {
                    if (fqhcVisit.line.getTableData().getFqhcRank() < 4) {
                        if (!grandfatheredTribalDone) {
                            if (fqhcVisit.line.isHcpcsModifierPresent("59") && !grandfatheredTribalFqhc) {
                                fqhcVisit.line.setCompositeAdjustmentFlag("03");
                            } else {
                                fqhcVisit.line.setCompositeAdjustmentFlag("01");
                            }
                        }
                        if (fqhcVisit.line.getFlags().isNotSet(LineFlags.INPUT_INVALID_REVENUE_CODE) && !HardcodedRevenueCodeSet.isFqhcMedicalVisit(fqhcVisit.line.getRevenueCode())) {
                            claim.assignEdit(EditValue.FQHC_VISIT_REVENUE_CODE_CONFLICT, fqhcVisit.line);
                            continue;
                        }
                        if (fqhcVisit.line.isEditPresent(EditValue.FQHC_QUALIFYING_VISIT_MISSING) || grandfatheredTribalDone) continue;
                        if (medicalVisit == null) {
                            if (grandfatheredTribalFqhc) {
                                fqhcVisit.line.setPaymentIndicator((byte)14);
                                grandfatheredTribalDone = true;
                            } else if (j && (fqhcVisit.line.getTableData().getFqhcRank() == 1 || fqhcVisit.line.getTableData().getFqhcRank() == 2)) {
                                fqhcVisit.line.setPaymentIndicator((byte)13);
                                j = false;
                            } else {
                                fqhcVisit.line.setPaymentIndicator((byte)10);
                            }
                            medicalVisit = fqhcVisit.line;
                            if (!fqhcVisit.line.isHcpcsModifierPresent("59") || fqhcVisit.line.getTableData().getFqhcRank() != 3) continue;
                            includeAdditionalMedicalVisit = true;
                            continue;
                        }
                        if (grandfatheredTribalFqhc || additionalVisit != null || !includeAdditionalMedicalVisit && !fqhcVisit.line.isHcpcsModifierPresent("59") || fqhcVisit.line.getTableData().getFqhcRank() != 3) continue;
                        fqhcVisit.line.setPaymentIndicator((byte)10);
                        additionalVisit = fqhcVisit.line;
                        continue;
                    }
                    if (fqhcVisit.line.getTableData().getFqhcRank() >= 6) continue;
                    if (!grandfatheredTribalDone) {
                        if (fqhcVisit.line.isHcpcsModifierPresent("59") && !grandfatheredTribalFqhc) {
                            fqhcVisit.line.setCompositeAdjustmentFlag("03");
                        } else {
                            fqhcVisit.line.setCompositeAdjustmentFlag("02");
                        }
                    }
                    if (fqhcVisit.line.getFlags().isNotSet(LineFlags.INPUT_INVALID_REVENUE_CODE) && !HardcodedRevenueCodeSet.isFqhcMentalHealthVisit(fqhcVisit.line.getRevenueCode())) {
                        claim.assignEdit(EditValue.FQHC_VISIT_REVENUE_CODE_CONFLICT, fqhcVisit.line);
                        continue;
                    }
                    if (mentalHealthVisit != null || fqhcVisit.line.isEditPresent(EditValue.FQHC_QUALIFYING_VISIT_MISSING) || grandfatheredTribalDone) continue;
                    if (grandfatheredTribalFqhc) {
                        fqhcVisit.line.setPaymentIndicator((byte)14);
                        grandfatheredTribalDone = true;
                    } else if (j && fqhcVisit.line.getTableData().getFqhcRank() == 4) {
                        fqhcVisit.line.setPaymentIndicator((byte)13);
                        j = false;
                    } else {
                        fqhcVisit.line.setPaymentIndicator((byte)10);
                    }
                    mentalHealthVisit = fqhcVisit.line;
                }
            } else if (!claim.matchesBillType("770") && !telehealth && !isChronicCare && !onlyNonCoveredPresent && !isOpioidUseDisorder || isOpioidUseDisorder && hasOfficeOpioidTreatmentCodes) {
                claim.assignEdit(EditValue.FQHC_VISIT_MISSING);
            }
            for (LineItemInternal lineItemInternal : day.getLineItemList()) {
                if (lineItemInternal.matchesActionFlag(5) || !lineItemInternal.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || lineItemInternal.equals(medicalVisit) || lineItemInternal.equals(mentalHealthVisit) || lineItemInternal.equals(additionalVisit) || lineItemInternal.matchesHcpcs(HardcodedHcpcsSet.TELEHEALTH_Q3041, HardcodedHcpcsSet.TELEHEALTH_G2025, HardcodedHcpcsSet.OPIOID_USE_DISORDER_G2172)) continue;
                if (lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_FQHC_CHRONIC_CARE)) {
                    lineItemInternal.setPaymentIndicator((byte)2);
                    continue;
                }
                if (lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_FQHC_FLU_PPV)) {
                    lineItemInternal.setPaymentIndicator((byte)11);
                    continue;
                }
                OceClaimUtility.packageLine(lineItemInternal);
                lineItemInternal.setPaymentIndicator((byte)12);
                if (lineItemInternal.getFlags().anySet(LineFlags.DATA_HCPCS_FQHC_PREVENTIVE, LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA) || advancedCarePlanningComponent && lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_ADVANCE_CARE_PLANNING) && medicalVisit != null && medicalVisit.matchesHcpcs(HardcodedHcpcsSet.FQHC_IPPE_AWE) || lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_OPIOID_USE_DISORDER) && claim.isConditionCodePresent("M5") && claim.isClaimVersionAfter(82)) {
                    lineItemInternal.setPackagingFlag((byte)6);
                    continue;
                }
                lineItemInternal.setPackagingFlag((byte)5);
            }
            for (FqhcVisit fqhcVisit : fqhcVisitList) {
                if (fqhcVisit.line.getPaymentIndicator().getValue().intValue() == 12 || !fqhcVisit.line.isUnitsGreaterThanOne()) continue;
                fqhcVisit.line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_UNITS_REDUCED_TO_ONE.getValue());
                fqhcVisit.line.setUnits(1);
            }
        }
        return false;
    }

    private final class FqhcVisit {
        private final LineItemInternal line;
        private QualifyingVisit owner;

        private FqhcVisit(LineItemInternal line) {
            this.line = line;
        }
    }

    private final class QualifyingVisit {
        private final LineItemInternal line;
        private final List<FqhcVisit> fqhcVisitList = new ArrayList<FqhcVisit>();
        private final List<FqhcVisit> chosenFqhcVisitList = new ArrayList<FqhcVisit>();
        private int units = 0;

        private QualifyingVisit(LineItemInternal line) {
            this.line = line;
        }

        private final boolean isAvailable() {
            return this.units >= 1;
        }

        private final boolean consume() {
            if (this.units <= 0) {
                return false;
            }
            --this.units;
            return true;
        }
    }
}

