/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InpatientTkaAnesthesiaLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InpatientTkaAnesthesiaLogic.class);

    InpatientTkaAnesthesiaLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.matchesHcpcs(HardcodedHcpcsSet.TKA)) continue;
            claim.getFlags().set(ClaimFlags.TOTAL_KNEE_ARTHROPLASTY);
            break;
        }
        if (claim.getFlags().isSet(ClaimFlags.TOTAL_KNEE_ARTHROPLASTY)) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.isNotPackaged() || !line.matchesHcpcs(HardcodedHcpcsSet.TKA_ANESTHESIA)) continue;
                OceClaimUtility.packageLine(line);
            }
        }
        return false;
    }
}

