/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapNcciDao;
import gov.cms.oce.dao.data.row.MapNcciRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ModifierFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NcciLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(NcciLogic.class);

    NcciLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        short version = claim.getVersionAsPrimitive();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapNcciDao dao = processor.getResourceManager().getDataDaoFactory().getMapNcciDao();
        for (Day day : navigator.getDayList()) {
            for (LineItemInternal line1 : day.getLineItemList()) {
                if (!line1.getFlags().isSet(LineFlags.DATA_HCPCS_NCCI_CODE1) || !line1.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                for (LineItemInternal line2 : day.getLineItemList()) {
                    MapNcciRowInternal row;
                    if (line1.equals(line2) || !line2.getFlags().isSet(LineFlags.DATA_HCPCS_NCCI_CODE2) || !line2.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || (row = dao.getData(line1, line2, version)) == null || !this.eligibleForEdit(claim, row, line1, line2)) continue;
                    if (row.getModIndicator()) {
                        if (!this.isRequiredModifierMissing(line1, line2)) continue;
                        claim.assignEdit(EditValue.BYPASSABLE_NCCI_CONFLICT, line2);
                        continue;
                    }
                    claim.assignEdit(EditValue.UNBYPASSABLE_NCCI_CONFLICT, line2);
                }
            }
        }
        return false;
    }

    private final boolean eligibleForEdit(OceClaimInternal claim, MapNcciRowInternal row, LineItemInternal line1, LineItemInternal line2) {
        return claim.isClaimVersionInsideRange(row.getLoVersion(), row.getHiVersion()) && (!claim.matchesBillType("85") || HardcodedRevenueCodeSet.isProfessionalService(line1.getRevenueCode()) == HardcodedRevenueCodeSet.isProfessionalService(line2.getRevenueCode()));
    }

    private final boolean isRequiredModifierMissing(LineItemInternal line1, LineItemInternal line2) {
        return !line1.isHcpcsModifierFlagSet(ModifierFlags.DATA_MODIFIER_NCCI) && !line2.isHcpcsModifierFlagSet(ModifierFlags.DATA_MODIFIER_NCCI);
    }
}

