/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Section603Edit131xLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(Section603Edit131xLogic.class);

    Section603Edit131xLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean exists = false;
        boolean edited = false;
        boolean observation = false;
        if (claim.isPrimaryComprehensiveChosen() && claim.getPrimaryComprehensive().matchesInitialStatusIndicator("J2")) {
            observation = true;
        }
        boolean section603E101Candidate = false;
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.isHcpcsModifierPresent("PN") && (!claim.isClaimVersionAfter(73) || !line.isHcpcsModifierPresent("PO") || !line.matchesHcpcs(HardcodedHcpcsSet.CAPC_OBS_S603_EXCLUSION))) continue;
            section603E101Candidate = claim.isClaimVersionAfter(65) && line.matchesInitialStatusIndicator("J2") && !line.matchesHcpcs(HardcodedHcpcsSet.CAPC_OBS_S603_EXCLUSION);
            if (section603E101Candidate && !observation && !line.matchesHcpcs(HardcodedHcpcsSet.CAPC_OBS_S603_EXCLUSION)) {
                claim.assignEdit(EditValue.NON_EXEMPT_HCPCS_MODIFIER_PN_CONFLICT, line);
                if (edited) continue;
                edited = true;
                continue;
            }
            if (exists || line.isPackaged()) continue;
            exists = true;
        }
        if (exists && !edited) {
            claim.getFlags().set(ClaimFlags.SECTION603_APPLICABLE);
        }
        return false;
    }
}

