/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapS603OverrideDao;
import gov.cms.oce.dao.data.row.MapS603OverrideRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Section603ReassignmentLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(Section603ReassignmentLogic.class);

    Section603ReassignmentLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (claim.getFlags().isSet(ClaimFlags.SECTION603_APPLICABLE)) {
            MapS603OverrideDao dao = processor.getResourceManager().getDataDaoFactory().getMapS603OverrideDao();
            for (LineItemInternal line : navigator.getLineItemList()) {
                MapS603OverrideRowInternal row;
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.isNotPackaged() || !line.getFlags().isSet(LineFlags.DATA_HCPCS_OVERRIDE_SECTION603) || !line.isHcpcsModifierPresent("PN") || (row = dao.getRow(line, (Short)claim.getVersionAsPrimitive())) == null) continue;
                Apc apc = Apc.create(row.getApc());
                OceClaimUtility.assignApc(processor, line, apc);
                line.getFlags().set(LineFlags.S603_OVERRIDDEN);
            }
        }
        return false;
    }
}

