/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ModifierFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SometimesTherapyLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(SometimesTherapyLogic.class);

    SometimesTherapyLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPATIENT_LINE, LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_SOMETIMES_THERAPY) || !line.getFlags().isSet(LineFlags.DATA_REVENUE_THERAPY) && !line.isHcpcsModifierFlagSet(ModifierFlags.DATA_MODIFIER_THERAPY)) continue;
            OceClaimUtility.setSeparatelyPayable(line);
            if (!claim.isClaimVersionAfter(73)) continue;
            line.getFlags().set(LineFlags.SEPARATELY_PAYABLE_THERAPY);
        }
        return false;
    }
}

