/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.external;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceClaimConverterResult;
import gov.cms.oce.model.external.OceClaimFactory;
import gov.cms.oce.model.external.OceClaimImpl;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceLineItemImpl;
import gov.cms.oce.model.external.OceProcessingInformation;
import gov.cms.oce.model.external.OceProcessingInformationImpl;
import gov.cms.oce.model.external.OceValueCode;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.ConditionCode;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OccurrenceCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.ProcessingInformation;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.Edit;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.util.StringUtilities;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimConverter {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimConverter.class);
    private static final String MESSAGE_NO_VALUE_NO_DEFAULT = "No value specified for \"{}\" and no default value submitted, model value will remain null.";
    private static final String MESSAGE_NO_VALUE_WITH_DEFAULT = "No value specified for \"{}\", model value will use default value \"{}\".";
    private static final String MESSAGE_INVALID_VALUE_NO_DEFAULT = "Invalid value \"{}\" specified for \"{}\" and no default value submitted, model value will remain null. Exception: {}";
    private static final String MESSAGE_INVALID_VALUE_WITH_DEFAULT = "Invalid value \"{}\" specified for \"{}\", model value will use default value \"{}\". Exception: {}";

    public final OceClaimConverterResult<String> getStringValue(String fieldName, String value, String defaultValue) {
        String stringValue = StringUtilities.toNonNullTrimmedString(value);
        OceClaimConverterResult<String> result = null;
        if ("".equals(stringValue)) {
            if (defaultValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_NO_DEFAULT, (Object)fieldName);
                }
                result = new OceClaimConverterResult<Object>(null, false, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_WITH_DEFAULT, (Object)fieldName, (Object)defaultValue);
                }
                result = new OceClaimConverterResult<String>(defaultValue, false, true);
            }
        } else {
            result = new OceClaimConverterResult<String>(stringValue, false, false);
        }
        return result;
    }

    public final OceClaimConverterResult<Byte> getByteValue(String fieldName, String value, Byte defaultValue) {
        String stringValue = StringUtilities.toNonNullTrimmedString(value);
        OceClaimConverterResult<Byte> result = null;
        if ("".equals(stringValue)) {
            if (defaultValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_NO_DEFAULT, (Object)fieldName);
                }
                result = new OceClaimConverterResult<Object>(null, false, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_WITH_DEFAULT, (Object)fieldName, (Object)defaultValue);
                }
                result = new OceClaimConverterResult<Byte>(defaultValue, false, true);
            }
        } else {
            try {
                Byte tmpValue = Byte.valueOf(stringValue);
                result = new OceClaimConverterResult<Byte>(tmpValue, false, false);
            }
            catch (NumberFormatException e) {
                if (defaultValue == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn(MESSAGE_INVALID_VALUE_NO_DEFAULT, new Object[]{value, fieldName, e.getMessage()});
                    }
                    result = new OceClaimConverterResult<Object>(null, true, false);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(MESSAGE_INVALID_VALUE_WITH_DEFAULT, new Object[]{value, fieldName, defaultValue, e.getMessage()});
                }
                result = new OceClaimConverterResult<Byte>(defaultValue, true, true);
            }
        }
        return result;
    }

    public final OceClaimConverterResult<Short> getShortValue(String fieldName, String value, Short defaultValue) {
        String stringValue = StringUtilities.toNonNullTrimmedString(value);
        OceClaimConverterResult<Short> result = null;
        if ("".equals(stringValue)) {
            if (defaultValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_NO_DEFAULT, (Object)fieldName);
                }
                result = new OceClaimConverterResult<Object>(null, false, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_WITH_DEFAULT, (Object)fieldName, (Object)defaultValue);
                }
                result = new OceClaimConverterResult<Short>(defaultValue, false, true);
            }
        } else {
            try {
                Short tmpValue = Short.valueOf(stringValue);
                result = new OceClaimConverterResult<Short>(tmpValue, false, false);
            }
            catch (NumberFormatException e) {
                if (defaultValue == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn(MESSAGE_INVALID_VALUE_NO_DEFAULT, new Object[]{value, fieldName, e.getMessage()});
                    }
                    result = new OceClaimConverterResult<Object>(null, true, false);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(MESSAGE_INVALID_VALUE_WITH_DEFAULT, new Object[]{value, fieldName, defaultValue, e.getMessage()});
                }
                result = new OceClaimConverterResult<Short>(defaultValue, true, true);
            }
        }
        return result;
    }

    public final OceClaimConverterResult<Integer> getIntegerValue(String fieldName, String value, Integer defaultValue) {
        String stringValue = StringUtilities.toNonNullTrimmedString(value);
        OceClaimConverterResult<Integer> result = null;
        if ("".equals(stringValue)) {
            if (defaultValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_NO_DEFAULT, (Object)fieldName);
                }
                result = new OceClaimConverterResult<Object>(null, false, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_WITH_DEFAULT, (Object)fieldName, (Object)defaultValue);
                }
                result = new OceClaimConverterResult<Integer>(defaultValue, false, true);
            }
        } else {
            try {
                Integer tmpValue = Integer.valueOf(stringValue);
                result = new OceClaimConverterResult<Integer>(tmpValue, false, false);
            }
            catch (NumberFormatException e) {
                if (defaultValue == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn(MESSAGE_INVALID_VALUE_NO_DEFAULT, new Object[]{value, fieldName, e.getMessage()});
                    }
                    result = new OceClaimConverterResult<Object>(null, true, false);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(MESSAGE_INVALID_VALUE_WITH_DEFAULT, new Object[]{value, fieldName, defaultValue, e.getMessage()});
                }
                result = new OceClaimConverterResult<Integer>(defaultValue, true, true);
            }
        }
        return result;
    }

    public final OceClaimConverterResult<BigDecimal> getBigDecimalValue(String fieldName, String value, BigDecimal defaultValue) {
        String stringValue = StringUtilities.toNonNullTrimmedString(value);
        OceClaimConverterResult<Object> result = null;
        if ("".equals(stringValue)) {
            if (defaultValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_NO_DEFAULT, (Object)fieldName);
                }
                result = new OceClaimConverterResult<Object>(null, false, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_WITH_DEFAULT, (Object)fieldName, (Object)defaultValue);
                }
                result = new OceClaimConverterResult<BigDecimal>(defaultValue, false, true);
            }
        } else {
            try {
                BigDecimal tmpValue = new BigDecimal(stringValue);
                result = new OceClaimConverterResult<BigDecimal>(tmpValue, false, false);
            }
            catch (NumberFormatException e) {
                if (defaultValue == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn(MESSAGE_INVALID_VALUE_NO_DEFAULT, new Object[]{value, fieldName, e.getMessage()});
                    }
                    result = new OceClaimConverterResult<Object>(null, true, false);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(MESSAGE_INVALID_VALUE_WITH_DEFAULT, new Object[]{value, fieldName, defaultValue, e.getMessage()});
                }
                result = new OceClaimConverterResult<BigDecimal>(defaultValue, true, true);
            }
        }
        return result;
    }

    public final OceClaimConverterResult<LocalDate> getClaimDateValue(String fieldName, String value, LocalDate defaultValue) {
        String stringValue = StringUtilities.toNonNullTrimmedString(value);
        OceClaimConverterResult<Object> result = null;
        if ("".equals(stringValue)) {
            if (defaultValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_NO_DEFAULT, (Object)fieldName);
                }
                result = new OceClaimConverterResult<Object>(null, false, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(MESSAGE_NO_VALUE_WITH_DEFAULT, (Object)fieldName, (Object)defaultValue);
                }
                result = new OceClaimConverterResult<LocalDate>(defaultValue, false, true);
            }
        } else {
            try {
                if (stringValue.length() != 8) {
                    throw new StringIndexOutOfBoundsException("Date string is not of the correct length.");
                }
                ClaimDate tmpValue = new ClaimDate(stringValue);
                result = new OceClaimConverterResult<LocalDate>(tmpValue.getValueAsDate(), false, false);
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException | DateTimeException e) {
                if (defaultValue == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn(MESSAGE_INVALID_VALUE_NO_DEFAULT, new Object[]{value, fieldName, e.getMessage()});
                    }
                    result = new OceClaimConverterResult<Object>(null, true, false);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(MESSAGE_INVALID_VALUE_WITH_DEFAULT, new Object[]{value, fieldName, defaultValue, e.getMessage()});
                }
                result = new OceClaimConverterResult<LocalDate>(defaultValue, true, true);
            }
        }
        return result;
    }

    public final int copyInputToInternalClaim(OceClaim oceClaimExternal, OceClaimInternal oceClaimInternal) {
        OceDiagnosisCode item;
        int i;
        OceClaimConverterResult<String> principalDiagnosisPresentOnAdmissionValue;
        OceClaimConverterResult<String> principalDiagnosisCodeValue;
        OceClaimConverterResult<Byte> oppsFlagValue;
        OceClaimConverterResult<Byte> patientStatusValue;
        OceClaimConverterResult<String> cmsCertificationNumberValue;
        OceClaimConverterResult<String> nationalProviderIdValue;
        OceClaimConverterResult<String> itemValue;
        int i2;
        OceClaimConverterResult<LocalDate> receiptDateValue;
        OceClaimConverterResult<LocalDate> dateEndedValue;
        OceClaimConverterResult<LocalDate> dateStartedValue;
        OceClaimConverterResult<Byte> sexValue;
        int errorCount = 0;
        OceProcessingInformation processingInformationExternal = oceClaimExternal.getProcessingInformation();
        ProcessingInformation processingInformationInternal = oceClaimInternal.getProcessingInformation();
        if (processingInformationExternal.getClaimId() == null) {
            processingInformationInternal.setClaimId("");
        } else {
            processingInformationInternal.setClaimId(processingInformationExternal.getClaimId().trim());
        }
        if (processingInformationExternal.getCommentData() == null) {
            processingInformationInternal.setCommentData("");
        } else {
            processingInformationInternal.setCommentData(processingInformationExternal.getCommentData().trim());
        }
        if (processingInformationExternal.getDebugFlag() == null) {
            processingInformationInternal.setDebugFlag("0");
        } else {
            processingInformationInternal.setDebugFlag(processingInformationExternal.getDebugFlag());
        }
        processingInformationInternal.setLinesProcessed(0);
        processingInformationInternal.setReturnCode(ReturnCode.UNKNOWN.getCode());
        OceClaimConverterResult<Byte> ageValue = this.getByteValue("Age", oceClaimExternal.getAge(), (byte)-1);
        if (ageValue.isErrorPresent()) {
            oceClaimInternal.getFlags().set(ClaimFlags.INPUT_INVALID_AGE);
            ++errorCount;
        }
        if (ageValue.getResult() != null) {
            oceClaimInternal.getAge().setValue(ageValue.getResult());
        }
        if ((sexValue = this.getByteValue("Sex", oceClaimExternal.getSex(), (byte)-1)).isErrorPresent()) {
            ++errorCount;
        }
        if (sexValue.getResult() != null) {
            oceClaimInternal.getSex().setValue(sexValue.getResult());
        }
        if (!sexValue.isErrorPresent() && sexValue.isDefaultApplied()) {
            oceClaimInternal.getSex().setValue((byte)0);
        }
        if ((dateStartedValue = this.getClaimDateValue("Date Started", oceClaimExternal.getDateStarted(), null)).isErrorPresent()) {
            oceClaimInternal.getFlags().set(ClaimFlags.INPUT_INVALID_DATE_STARTED);
            ++errorCount;
        }
        if (dateStartedValue.getResult() != null) {
            oceClaimInternal.getDateStarted().setValue(dateStartedValue.getResult());
        }
        if ((dateEndedValue = this.getClaimDateValue("Date Ended", oceClaimExternal.getDateEnded(), null)).isErrorPresent()) {
            oceClaimInternal.getFlags().set(ClaimFlags.INPUT_INVALID_DATE_ENDED);
            ++errorCount;
        }
        if (dateEndedValue.getResult() != null) {
            oceClaimInternal.getDateEnded().setValue(dateEndedValue.getResult());
        }
        if ((receiptDateValue = this.getClaimDateValue("Receipt Date", oceClaimExternal.getReceiptDate(), null)).isErrorPresent()) {
            oceClaimInternal.getFlags().set(ClaimFlags.INPUT_INVALID_RECEIPT_DATE);
            ++errorCount;
        }
        if (receiptDateValue.getResult() != null) {
            oceClaimInternal.getReceiptDate().setValue(receiptDateValue.getResult());
        }
        for (i2 = 0; i2 < oceClaimExternal.getConditionCodeInputListLength(); ++i2) {
            String conditionCode = oceClaimExternal.getConditionCodeInputList().get(i2);
            itemValue = this.getStringValue("ConditionCode " + i2, conditionCode, null);
            if (itemValue.isErrorPresent()) {
                ++errorCount;
            }
            if (itemValue.getResult() == null) continue;
            oceClaimInternal.getConditionCodeInputList().addValue(itemValue.getResult());
        }
        for (i2 = 0; i2 < oceClaimExternal.getOccurrenceCodeInputListLength(); ++i2) {
            String occurrenceCode = oceClaimExternal.getOccurrenceCodeInputList().get(i2);
            itemValue = this.getStringValue("OccurrenceCode " + i2, occurrenceCode, null);
            if (itemValue.isErrorPresent()) {
                ++errorCount;
            }
            if (itemValue.getResult() == null) continue;
            oceClaimInternal.getOccurrenceCodeInputList().addValue(itemValue.getResult());
        }
        for (i2 = 0; i2 < oceClaimExternal.getValueCodeInputListLength(); ++i2) {
            OceClaimConverterResult<String> valueCodeValue;
            OceValueCode item2 = oceClaimExternal.getValueCodeInputList().get(i2);
            OceClaimConverterResult<String> valueCode = this.getStringValue("Value Code " + i2, item2.getCode(), null);
            if (valueCode.isErrorPresent()) {
                ++errorCount;
            }
            if ((valueCodeValue = this.getStringValue("Value Code Value " + i2, item2.getValue(), null)).isErrorPresent()) {
                ++errorCount;
            }
            if (valueCode.getResult() == null && valueCodeValue.getResult() == null) continue;
            oceClaimInternal.getValueCodeInputList().addValue(valueCode.getResult(), valueCodeValue.getResult());
        }
        OceClaimConverterResult<String> billTypeValue = this.getStringValue("Bill Type", oceClaimExternal.getBillType(), null);
        if (billTypeValue.isErrorPresent()) {
            ++errorCount;
        }
        if (billTypeValue.getResult() != null) {
            try {
                oceClaimInternal.getBillType().setValue(billTypeValue.getResult());
            }
            catch (StringIndexOutOfBoundsException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invalid bill type passed in \"{}\" resulting in \"{}\"", (Object)oceClaimExternal.getBillType(), (Object)e.getMessage());
                }
                oceClaimInternal.getFlags().set(ClaimFlags.INPUT_INVALID_BILL_TYPE);
            }
        }
        if ((nationalProviderIdValue = this.getStringValue("National Provider ID", oceClaimExternal.getNationalProviderId(), null)).isErrorPresent()) {
            ++errorCount;
        }
        if (nationalProviderIdValue.getResult() != null) {
            oceClaimInternal.getNationalProviderId().setValue(nationalProviderIdValue.getResult());
        }
        if ((cmsCertificationNumberValue = this.getStringValue("CMS Certification Number", oceClaimExternal.getCmsCertificationNumber(), null)).isErrorPresent()) {
            ++errorCount;
        }
        if (cmsCertificationNumberValue.getResult() != null) {
            oceClaimInternal.getCmsCertificationNumber().setValue(cmsCertificationNumberValue.getResult());
        }
        if ((patientStatusValue = this.getByteValue("Patient Status", oceClaimExternal.getPatientStatus(), null)).isErrorPresent()) {
            ++errorCount;
        }
        if (patientStatusValue.getResult() != null) {
            oceClaimInternal.getPatientStatus().setValue(patientStatusValue.getResult());
        }
        if ((oppsFlagValue = this.getByteValue("OPPS Flag", oceClaimExternal.getOppsFlag(), (byte)1)).isErrorPresent()) {
            ++errorCount;
        }
        if (oppsFlagValue.getResult() != null) {
            oceClaimInternal.getOppsFlag().setValue(oppsFlagValue.getResult());
        }
        if ((principalDiagnosisCodeValue = this.getStringValue("Principal Diagnosis Code", oceClaimExternal.getPrincipalDiagnosisCode() == null ? null : oceClaimExternal.getPrincipalDiagnosisCode().getDiagnosis(), null)).isErrorPresent()) {
            ++errorCount;
        }
        if (principalDiagnosisCodeValue.getResult() != null) {
            oceClaimInternal.getPrincipalDiagnosisCode().setClaim(oceClaimInternal);
            oceClaimInternal.getPrincipalDiagnosisCode().setValue(principalDiagnosisCodeValue.getResult());
        }
        if ((principalDiagnosisPresentOnAdmissionValue = this.getStringValue("Principal Diagnosis Code Present On Admission", oceClaimExternal.getPrincipalDiagnosisCode() == null ? null : oceClaimExternal.getPrincipalDiagnosisCode().getPresentOnAdmission(), null)).isErrorPresent()) {
            ++errorCount;
        }
        if (principalDiagnosisPresentOnAdmissionValue.getResult() != null) {
            oceClaimInternal.getPrincipalDiagnosisCode().setClaim(oceClaimInternal);
            oceClaimInternal.getPrincipalDiagnosisCode().getPresentOnAdmission().setValue(principalDiagnosisPresentOnAdmissionValue.getResult());
        }
        for (i = 0; i < oceClaimExternal.getReasonForVisitDiagnosisCodeListLength(); ++i) {
            OceClaimConverterResult<String> reasonForVisitPresentOnAdmissionValue;
            item = oceClaimExternal.getReasonForVisitDiagnosisCodeList().get(i);
            OceClaimConverterResult<String> reasonForVisitDiagnosisCodeValue = this.getStringValue("Reason for Visit Diagnosis Code " + i, item.getDiagnosis(), null);
            if (reasonForVisitDiagnosisCodeValue.isErrorPresent()) {
                ++errorCount;
            }
            if ((reasonForVisitPresentOnAdmissionValue = this.getStringValue("Reason for Visit Diagnosis Code Present On Admission " + i, item.getPresentOnAdmission(), null)).isErrorPresent()) {
                ++errorCount;
            }
            if (reasonForVisitDiagnosisCodeValue.getResult() == null && reasonForVisitPresentOnAdmissionValue.getResult() == null) continue;
            oceClaimInternal.getReasonForVisitDiagnosisCodeList().addValue(oceClaimInternal, reasonForVisitDiagnosisCodeValue.getResult(), reasonForVisitPresentOnAdmissionValue.getResult());
        }
        for (i = 0; i < oceClaimExternal.getSecondaryDiagnosisCodeListLength(); ++i) {
            OceClaimConverterResult<String> secondaryPresentOnAdmissionValue;
            item = oceClaimExternal.getSecondaryDiagnosisCodeList().get(i);
            OceClaimConverterResult<String> secondaryDiagnosisCodeValue = this.getStringValue("Secondary Diagnosis Code " + i, item.getDiagnosis(), null);
            if (secondaryDiagnosisCodeValue.isErrorPresent()) {
                ++errorCount;
            }
            if ((secondaryPresentOnAdmissionValue = this.getStringValue("Secondary Diagnosis Code Present On Admission " + i, item.getPresentOnAdmission(), null)).isErrorPresent()) {
                ++errorCount;
            }
            if (secondaryDiagnosisCodeValue.getResult() == null && secondaryPresentOnAdmissionValue.getResult() == null) continue;
            oceClaimInternal.getSecondaryDiagnosisCodeList().addValue(oceClaimInternal, secondaryDiagnosisCodeValue.getResult(), secondaryPresentOnAdmissionValue.getResult());
        }
        for (i = 0; i < oceClaimExternal.getLineItemListLength(); ++i) {
            OceClaimConverterResult<Byte> contractorPaymentAdjustmentFlag02Value;
            OceClaimConverterResult<String> contractorPaymentMethodFlagValue;
            OceClaimConverterResult<Byte> contractorPaymentAdjustmentFlag01Value;
            OceClaimConverterResult<Byte> contractorPackagingFlagValue;
            OceClaimConverterResult<Byte> contractorRejectionDenialFlagValue;
            OceClaimConverterResult<Byte> contractorDiscountingFormulaValue;
            OceClaimConverterResult<Byte> contractorPaymentIndicatorValue;
            OceClaimConverterResult<String> contractorStatusIndicatorValue;
            OceClaimConverterResult<Byte> actionFlagValue;
            OceClaimConverterResult<BigDecimal> chargeValue;
            StringBuilder stringChargeValue;
            OceClaimConverterResult<String> hcpcsValue;
            OceClaimConverterResult<Short> revenueCodeValue;
            OceLineItem itemExternal = oceClaimExternal.getLineItemList().get(i);
            LineItemInternal line = LineItemInternal.create();
            oceClaimInternal.getLineItemList().getValue().add(line);
            OceClaimConverterResult<LocalDate> serviceDateValue = this.getClaimDateValue("Service Date", itemExternal.getServiceDate(), null);
            if (serviceDateValue.isErrorPresent()) {
                line.getFlags().set(LineFlags.INPUT_INVALID_SERVICE_DATE);
                ++errorCount;
            }
            if (serviceDateValue.getResult() != null) {
                line.getServiceDate().setValue(serviceDateValue.getResult());
            }
            if ((revenueCodeValue = this.getShortValue("Revenue Code", itemExternal.getRevenueCode(), null)).isErrorPresent()) {
                ++errorCount;
            }
            if (revenueCodeValue.getResult() != null) {
                line.getRevenueCode().setValue(revenueCodeValue.getResult());
            }
            if ((hcpcsValue = this.getStringValue("CPT/HCPCS/HIPPS", itemExternal.getHcpcs(), null)).isErrorPresent()) {
                ++errorCount;
            }
            if (hcpcsValue.getResult() != null) {
                line.getHcpcs().setValue(hcpcsValue.getResult());
            }
            for (int j = 0; j < itemExternal.getHcpcsModifierInputListLength(); ++j) {
                String hcpcsModifier = itemExternal.getHcpcsModifierInputList().get(j).getHcpcsModifier();
                OceClaimConverterResult<String> itemValue2 = this.getStringValue("CPT/HCPCS Modifier " + j, hcpcsModifier, null);
                if (itemValue2.isErrorPresent()) {
                    ++errorCount;
                }
                if (itemValue2.getResult() == null) continue;
                line.getHcpcsModifierInputList().addValue(line, itemValue2.getResult());
            }
            OceClaimConverterResult<Integer> unitsValue = this.getIntegerValue("Units", itemExternal.getUnitsInput(), 1);
            if (unitsValue.isErrorPresent()) {
                ++errorCount;
            }
            if (unitsValue.getResult() != null) {
                line.getUnits().setValue(unitsValue.getResult());
            }
            if ((stringChargeValue = new StringBuilder(StringUtilities.toNonNullTrimmedString(itemExternal.getCharge()))).indexOf(".") < 0) {
                if (stringChargeValue.length() < 3) {
                    StringUtilities.zeroPad(stringChargeValue, 3);
                }
                stringChargeValue.insert(stringChargeValue.length() - 2, '.');
            }
            if ((chargeValue = this.getBigDecimalValue("Charge", stringChargeValue.toString(), BigDecimal.ZERO)).isErrorPresent()) {
                ++errorCount;
            }
            if (chargeValue.getResult() != null) {
                line.getCharge().setValue(chargeValue.getResult());
            }
            if ((actionFlagValue = this.getByteValue("Action Flag", itemExternal.getActionFlagInput(), (byte)0)).isErrorPresent()) {
                ++errorCount;
            }
            if (actionFlagValue.getResult() != null) {
                line.getActionFlag().setValue(actionFlagValue.getResult());
            }
            boolean contractorOverridePresent = false;
            for (int j = 0; j < itemExternal.getContractorEditBypassListLength(); ++j) {
                String editBypass = itemExternal.getContractorEditBypassList().get(j);
                OceClaimConverterResult<Short> contractorEditBypassValue = this.getShortValue("Contractor Edit Bypass" + j, editBypass, null);
                if (contractorEditBypassValue.isErrorPresent()) {
                    ++errorCount;
                }
                if (contractorEditBypassValue.getResult() == null) continue;
                if (EditValue.isValidEditValue(contractorEditBypassValue.getResult())) {
                    EditValue edit = EditValue.getEditValue(contractorEditBypassValue.getResult());
                    line.getEditBypass().getEditBypassList().getValue().add(edit);
                    continue;
                }
                if (!line.getFlags().isNotSet(LineFlags.CONTRACTOR_OVERRIDE_EDIT_INVALID)) continue;
                line.getFlags().set(LineFlags.CONTRACTOR_OVERRIDE_EDIT_INVALID);
            }
            OceClaimConverterResult<String> contractorApcValue = this.getStringValue("Contractor APC", itemExternal.getContractorApc(), null);
            if (contractorApcValue.isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_APC_INVALID);
                ++errorCount;
            }
            if (contractorApcValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                try {
                    Integer.parseInt(contractorApcValue.getResult());
                }
                catch (NumberFormatException e) {
                    line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_APC_INVALID);
                    ++errorCount;
                }
                line.getEditBypass().getApc().setValue(contractorApcValue.getResult());
            }
            if ((contractorStatusIndicatorValue = this.getStringValue("Contractor Status Indicator", itemExternal.getContractorStatusIndicator(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_SI_INVALID);
                ++errorCount;
            }
            if (contractorStatusIndicatorValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getStatusIndicator().setValue(contractorStatusIndicatorValue.getResult());
            }
            if ((contractorPaymentIndicatorValue = this.getByteValue("Contractor Payment Indicator", itemExternal.getContractorPaymentIndicator(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_PI_INVALID);
                ++errorCount;
            }
            if (contractorPaymentIndicatorValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getPaymentIndicator().setValue(contractorPaymentIndicatorValue.getResult());
            }
            if ((contractorDiscountingFormulaValue = this.getByteValue("Contractor Discounting Formula", itemExternal.getContractorDiscountingFormula(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_DISCOUNTING_FORMULA_INVALID);
                ++errorCount;
            }
            if (contractorDiscountingFormulaValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getDiscountingFormula().setValue(contractorDiscountingFormulaValue.getResult());
            }
            if ((contractorRejectionDenialFlagValue = this.getByteValue("Contractor Rejection Denial Flag", itemExternal.getContractorRejectionDenialFlag(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_REJECTION_DENIAL_INVALID);
                ++errorCount;
            }
            if (contractorRejectionDenialFlagValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getRejectionDenialFlag().setValue(contractorRejectionDenialFlagValue.getResult());
            }
            if ((contractorPackagingFlagValue = this.getByteValue("Contractor Packaging Flag", itemExternal.getContractorPackagingFlag(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_PACKAGING_FLAG_INVALID);
                ++errorCount;
            }
            if (contractorPackagingFlagValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getPackagingFlag().setValue(contractorPackagingFlagValue.getResult());
            }
            if ((contractorPaymentAdjustmentFlag01Value = this.getByteValue("Contractor Payment Adjustment Flag 01", itemExternal.getContractorPaymentAdjustmentFlag01(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_PAYMENT_ADJUSTMENT_01_FLAG_INVALID);
                ++errorCount;
            }
            if (contractorPaymentAdjustmentFlag01Value.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getPaymentAdjustmentFlag01().setValue(contractorPaymentAdjustmentFlag01Value.getResult());
            }
            if ((contractorPaymentMethodFlagValue = this.getStringValue("Contractor Payment Method Flag", itemExternal.getContractorPaymentMethodFlag(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_PAYMENT_METHOD_FLAG_INVALID);
                ++errorCount;
            }
            if (contractorPaymentMethodFlagValue.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getPaymentMethodFlag().setValue(contractorPaymentMethodFlagValue.getResult());
            }
            if ((contractorPaymentAdjustmentFlag02Value = this.getByteValue("Contractor Payment Adjustment Flag 02", itemExternal.getContractorPaymentAdjustmentFlag02(), null)).isErrorPresent()) {
                line.getFlags().set(LineFlags.CONTRACTOR_BYPASS_PAYMENT_ADJUSTMENT_02_FLAG_INVALID);
                ++errorCount;
            }
            if (contractorPaymentAdjustmentFlag02Value.getResult() != null) {
                if (!contractorOverridePresent) {
                    contractorOverridePresent = true;
                }
                line.getEditBypass().getPaymentAdjustmentFlag02().setValue(contractorPaymentAdjustmentFlag02Value.getResult());
            }
            if (!contractorOverridePresent) continue;
            line.getFlags().set(LineFlags.CONTRACTOR_OVERRIDE_PRESENT);
        }
        processingInformationInternal.setLinesProcessed(oceClaimExternal.getLineItemListLength());
        return errorCount;
    }

    private final List<OceDiagnosisCode> getDiagnosisCodeList(List<DiagnosisCode> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OceDiagnosisCode> list = new ArrayList<OceDiagnosisCode>(sourceList.size());
        for (DiagnosisCode item : sourceList) {
            list.add(OceClaimFactory.getInstance().createDiagnosisCode(StringUtilities.toNonNullString(item.getValue()), StringUtilities.toNonNullString(item.getPresentOnAdmission().getValue())));
        }
        return Collections.unmodifiableList(list);
    }

    private final List<OceValueCode> getValueCodeList(List<ValueCode> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OceValueCode> list = new ArrayList<OceValueCode>(sourceList.size());
        for (ValueCode item : sourceList) {
            list.add(OceClaimFactory.getInstance().createValueCode(StringUtilities.toNonNullString(item.getCode()), StringUtilities.toNonNullString(item.getValue())));
        }
        return Collections.unmodifiableList(list);
    }

    private final List<String> getOccurrenceCodeList(List<OccurrenceCode> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(sourceList.size());
        for (OccurrenceCode item : sourceList) {
            list.add(StringUtilities.toNonNullString(item.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private final List<String> getConditionCodeList(List<ConditionCode> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(sourceList.size());
        for (ConditionCode item : sourceList) {
            list.add(StringUtilities.toNonNullString(item.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private final List<String> getEditList(List<Edit> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(sourceList.size());
        for (Edit item : sourceList) {
            list.add(StringUtilities.padLeft(StringUtilities.toNonNullString(item.getEditValue().getValue()), 3, '0'));
        }
        return Collections.unmodifiableList(list);
    }

    private final List<OceHcpcsModifier> getHcpcsModifierList(List<HcpcsModifier> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OceHcpcsModifier> list = new ArrayList<OceHcpcsModifier>(sourceList.size());
        for (HcpcsModifier item : sourceList) {
            list.add(OceClaimFactory.getInstance().createHcpcsModifier(StringUtilities.toNonNullString(item.getValue())));
        }
        return Collections.unmodifiableList(list);
    }

    public final int copyOutputToExternalClaim(OceClaimInternal oceClaimInternal, OceClaim oceClaim) {
        OceClaimImpl oceClaimExternal = (OceClaimImpl)oceClaim;
        ProcessingInformation processingInformation = oceClaimInternal.getProcessingInformation();
        if ("9".equals(processingInformation.getDebugFlag())) {
            this.copyDefaultsToExternalClaim(oceClaimInternal, oceClaimExternal);
            return 0;
        }
        OceProcessingInformationImpl processingInformationExternal = (OceProcessingInformationImpl)oceClaimExternal.getProcessingInformation();
        processingInformationExternal.setClaimId(processingInformation.getClaimId());
        processingInformationExternal.setDebugFlag(processingInformation.getDebugFlag());
        processingInformationExternal.setReturnCode(processingInformation.getReturnCode());
        processingInformationExternal.setLinesProcessed(processingInformation.getLinesProcessed());
        processingInformationExternal.setVersion(processingInformation.getVersion());
        processingInformationExternal.setInternalVersion(processingInformation.getInternalVersion());
        processingInformationExternal.setTimeStarted(processingInformation.getTimeStarted());
        processingInformationExternal.setTimeEnded(processingInformation.getTimeEnded());
        Byte claimProcessedFlag = oceClaimInternal.getClaimProcessedFlag().getValue();
        oceClaimExternal.setClaimProcessedFlag(StringUtilities.toNonNullString(claimProcessedFlag));
        Byte claimDisposition = oceClaimInternal.getClaimDisposition().getValue();
        oceClaimExternal.setClaimDisposition(StringUtilities.toNonNullString(claimDisposition));
        Byte claimRejectionDisposition = oceClaimInternal.getClaimRejectionDisposition().getValue();
        oceClaimExternal.setClaimRejectionDisposition(StringUtilities.toNonNullString(claimRejectionDisposition));
        Byte claimDenialDisposition = oceClaimInternal.getClaimDenialDisposition().getValue();
        oceClaimExternal.setClaimDenialDisposition(StringUtilities.toNonNullString(claimDenialDisposition));
        Byte claimSuspensionDisposition = oceClaimInternal.getClaimSuspensionDisposition().getValue();
        oceClaimExternal.setClaimSuspensionDisposition(StringUtilities.toNonNullString(claimSuspensionDisposition));
        Byte claimReturnToProviderDisposition = oceClaimInternal.getClaimReturnToProviderDisposition().getValue();
        oceClaimExternal.setClaimReturnToProviderDisposition(StringUtilities.toNonNullString(claimReturnToProviderDisposition));
        Byte lineRejectionDisposition = oceClaimInternal.getLineRejectionDisposition().getValue();
        oceClaimExternal.setLineRejectionDisposition(StringUtilities.toNonNullString(lineRejectionDisposition));
        Byte lineDenialDisposition = oceClaimInternal.getLineDenialDisposition().getValue();
        oceClaimExternal.setLineDenialDisposition(StringUtilities.toNonNullString(lineDenialDisposition));
        Byte apcReturnBufferFlag = oceClaimInternal.getApcReturnBufferFlag().getValue();
        oceClaimExternal.setApcReturnBufferFlag(StringUtilities.toNonNullString(apcReturnBufferFlag));
        Byte noppsBillFlag = oceClaimInternal.getNoppsBillFlag().getValue();
        oceClaimExternal.setNoppsBillFlag(StringUtilities.toNonNullString(noppsBillFlag));
        oceClaimExternal.setClaimRejectionEditList(this.getEditList(oceClaimInternal.getClaimRejectionEditList()));
        oceClaimExternal.setClaimDenialEditList(this.getEditList(oceClaimInternal.getClaimDenialEditList()));
        oceClaimExternal.setClaimReturnToProviderEditList(this.getEditList(oceClaimInternal.getReturnToProviderEditList()));
        oceClaimExternal.setClaimSuspensionEditList(this.getEditList(oceClaimInternal.getSuspensionEditList()));
        oceClaimExternal.setLineRejectionEditList(this.getEditList(oceClaimInternal.getLineRejectionEditList()));
        oceClaimExternal.setLineDenialEditList(this.getEditList(oceClaimInternal.getLineDenialEditList()));
        oceClaimExternal.setConditionCodeOutput(this.getConditionCodeList(oceClaimInternal.getConditionCodeOutputList().getValue()));
        oceClaimExternal.setValueCodeOutput(this.getValueCodeList(oceClaimInternal.getValueCodeOutputList().getValue()));
        List<OceLineItem> lineItemExternalList = oceClaimExternal.getLineItemList();
        List<LineItemInternal> lineList = oceClaimInternal.getLineItemList().getValue();
        for (int i = 0; i < lineList.size(); ++i) {
            LineItemInternal line = lineList.get(i);
            Iterator<DiagnosisCode> lineItemExternal = (OceLineItemImpl)lineItemExternalList.get(i);
            Byte actionFlagOutput = line.getActionFlag().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setActionFlagOutput(StringUtilities.toNonNullString(actionFlagOutput));
            String hcpcsApc = line.getHcpcsApc().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setHcpcsApc(StringUtilities.toNonNullString(hcpcsApc));
            String paymentApc = line.getPaymentApc().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setPaymentApc(StringUtilities.toNonNullString(paymentApc));
            String statusIndicator = line.getStatusIndicator().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setStatusIndicator(StringUtilities.toNonNullString(statusIndicator));
            Byte paymentIndicator = line.getPaymentIndicator().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setPaymentIndicator(StringUtilities.toNonNullString(paymentIndicator));
            Byte discountingFormula = line.getDiscountingFormula().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setDiscountingFormula(StringUtilities.toNonNullString(discountingFormula));
            Byte rejectionDenialFlag = line.getRejectionDenialFlag().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setRejectionDenialFlag(StringUtilities.toNonNullString(rejectionDenialFlag));
            Byte packagingFlag = line.getPackagingFlag().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setPackagingFlag(StringUtilities.toNonNullString(packagingFlag));
            Byte paymentAdjustmentFlag01 = line.getPaymentAdjustmentFlag01().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setPaymentAdjustmentFlag01(StringUtilities.toNonNullString(paymentAdjustmentFlag01));
            String paymentMethodFlag = line.getPaymentMethodFlag().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setPaymentMethodFlag(StringUtilities.toNonNullString(paymentMethodFlag));
            Byte paymentAdjustmentFlag02 = line.getPaymentAdjustmentFlag02().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setPaymentAdjustmentFlag02(StringUtilities.toNonNullString(paymentAdjustmentFlag02));
            Integer unitsOutput = line.getUnits().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setUnitsOutput(StringUtilities.toNonNullString(unitsOutput));
            String compositeAdjustmentFlag = line.getCompositeAdjustmentFlag().getValue();
            ((OceLineItemImpl)((Object)lineItemExternal)).setCompositeAdjustmentFlag(StringUtilities.toNonNullString(compositeAdjustmentFlag));
            ((OceLineItemImpl)((Object)lineItemExternal)).setHcpcsModifierOutputList(this.getHcpcsModifierList(line.getHcpcsModifierOutputList().getValue()));
            for (Edit edit : line.getEditList()) {
                String editValue = StringUtilities.padLeft(StringUtilities.toNonNullString(edit.getEditValue().getValue()), 3, '0');
                switch (edit.getEditValue().getEditBuffer()) {
                    case PROCEDURE: {
                        ((OceLineItemImpl)((Object)lineItemExternal)).getHcpcsEditList().add(editValue);
                        break;
                    }
                    case CLAIM: {
                        break;
                    }
                    case DATE: {
                        ((OceLineItemImpl)((Object)lineItemExternal)).getServiceDateEditList().add(editValue);
                        break;
                    }
                    case DIAGNOSIS: {
                        break;
                    }
                    case MODIFIER: {
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    case REVENUE_CODE: {
                        ((OceLineItemImpl)((Object)lineItemExternal)).getRevenueEditList().add(editValue);
                        break;
                    }
                }
            }
            int internalModIndex = 0;
            for (HcpcsModifier hcpcsModifier : line.getHcpcsModifierInputList().getValue()) {
                if (internalModIndex < ((OceLineItemImpl)((Object)lineItemExternal)).getHcpcsModifierInputListLength()) {
                    OceHcpcsModifier oceHcpcsModifier = ((OceLineItemImpl)((Object)lineItemExternal)).getHcpcsModifierInputList().get(internalModIndex);
                    for (Edit edit : hcpcsModifier.getEditList()) {
                        String editValue = StringUtilities.padLeft(StringUtilities.toNonNullString(edit.getEditValue().getValue()), 3, '0');
                        oceHcpcsModifier.getEditList().add(editValue);
                    }
                } else {
                    logger.debug("Internal/external modifier count mismatch for line {}, modifier {}", (Object)i, (Object)internalModIndex);
                }
                ++internalModIndex;
            }
        }
        DiagnosisCode principalDiagnosisCode = oceClaimInternal.getPrincipalDiagnosisCode();
        if (!principalDiagnosisCode.getEditList().isEmpty()) {
            OceDiagnosisCode oceDiagnosisCode = oceClaimExternal.getPrincipalDiagnosisCode();
            for (Edit edit : principalDiagnosisCode.getEditList()) {
                String editValue = StringUtilities.padLeft(StringUtilities.toNonNullString(edit.getEditValue().getValue()), 3, '0');
                oceDiagnosisCode.getEditList().add(editValue);
            }
        }
        int internalReasonForVisitDiagnosisIndex = 0;
        for (DiagnosisCode diagnosisCode : oceClaimInternal.getReasonForVisitDiagnosisCodeList().getValue()) {
            if (!diagnosisCode.getEditList().isEmpty()) {
                if (internalReasonForVisitDiagnosisIndex < oceClaimExternal.getReasonForVisitDiagnosisCodeListLength()) {
                    OceDiagnosisCode oceDiagnosisCode = oceClaimExternal.getReasonForVisitDiagnosisCodeList().get(internalReasonForVisitDiagnosisIndex);
                    for (Edit edit : diagnosisCode.getEditList()) {
                        String editValue = StringUtilities.padLeft(StringUtilities.toNonNullString(edit.getEditValue().getValue()), 3, '0');
                        oceDiagnosisCode.getEditList().add(editValue);
                    }
                } else {
                    logger.warn("Internal/external ReasonForVisit diagnosis count mismatch for ReasonForVisit diagnosis \"{}\"", (Object)internalReasonForVisitDiagnosisIndex);
                }
            }
            ++internalReasonForVisitDiagnosisIndex;
        }
        int internalSecondaryDiagnosisIndex = 0;
        for (DiagnosisCode diagnosisCode : oceClaimInternal.getSecondaryDiagnosisCodeList().getValue()) {
            if (!diagnosisCode.getEditList().isEmpty()) {
                if (internalSecondaryDiagnosisIndex < oceClaimExternal.getSecondaryDiagnosisCodeListLength()) {
                    OceDiagnosisCode oceDiagnosisCode = oceClaimExternal.getSecondaryDiagnosisCodeList().get(internalSecondaryDiagnosisIndex);
                    for (Edit edit : diagnosisCode.getEditList()) {
                        String editValue = StringUtilities.padLeft(StringUtilities.toNonNullString(edit.getEditValue().getValue()), 3, '0');
                        oceDiagnosisCode.getEditList().add(editValue);
                    }
                } else {
                    logger.warn("Internal/external secondary diagnosis count mismatch for secondary diagnosis \"{}\"", (Object)internalSecondaryDiagnosisIndex);
                }
            }
            ++internalSecondaryDiagnosisIndex;
        }
        return 0;
    }

    private final int copyDefaultsToExternalClaim(OceClaimInternal oceClaimInternal, OceClaimImpl oceClaimExternal) {
        ProcessingInformation processingInformation = oceClaimInternal.getProcessingInformation();
        OceProcessingInformationImpl processingInformationExternal = (OceProcessingInformationImpl)oceClaimExternal.getProcessingInformation();
        processingInformationExternal.setClaimId("FIELD-FILLER");
        processingInformationExternal.setDebugFlag("9");
        processingInformationExternal.setReturnCode(0);
        processingInformationExternal.setLinesProcessed(6);
        processingInformationExternal.setVersion("YY.Q.I");
        processingInformationExternal.setInternalVersion((short)99);
        processingInformationExternal.setTimeStarted(processingInformation.getTimeStarted());
        processingInformationExternal.setTimeEnded(processingInformation.getTimeEnded());
        oceClaimExternal.setClaimProcessedFlag("0");
        oceClaimExternal.setClaimDisposition("1");
        oceClaimExternal.setClaimRejectionDisposition("2");
        oceClaimExternal.setClaimDenialDisposition("3");
        oceClaimExternal.setClaimSuspensionDisposition("4");
        oceClaimExternal.setClaimReturnToProviderDisposition("5");
        oceClaimExternal.setLineRejectionDisposition("6");
        oceClaimExternal.setLineDenialDisposition("7");
        oceClaimExternal.setApcReturnBufferFlag("8");
        oceClaimExternal.setNoppsBillFlag("9");
        ArrayList<Edit> defaultEditList = new ArrayList<Edit>(30);
        for (int i = 0; i < 30; ++i) {
            defaultEditList.add(new Edit(EditValue.INVALID_DIAGNOSIS, oceClaimInternal));
        }
        List<String> defaultEditStringList = this.getEditList(defaultEditList);
        oceClaimExternal.setClaimRejectionEditList(defaultEditStringList);
        oceClaimExternal.setClaimDenialEditList(defaultEditStringList);
        oceClaimExternal.setClaimReturnToProviderEditList(defaultEditStringList);
        oceClaimExternal.setClaimSuspensionEditList(defaultEditStringList);
        oceClaimExternal.setLineRejectionEditList(defaultEditStringList);
        oceClaimExternal.setLineDenialEditList(defaultEditStringList);
        ArrayList<String> defaultConditionCodeList = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            defaultConditionCodeList.add("0" + i);
        }
        oceClaimExternal.setConditionCodeOutput(defaultConditionCodeList);
        ArrayList<OceValueCode> defaultValueCodeList = new ArrayList<OceValueCode>(10);
        for (int i = 0; i < 10; ++i) {
            defaultValueCodeList.add(OceClaimFactory.getInstance().createValueCode(StringUtilities.toNonNullString("0" + i), StringUtilities.toNonNullString("000000001")));
        }
        oceClaimExternal.setValueCodeOutput(defaultValueCodeList);
        List<OceLineItem> lineItemExternalList = oceClaimExternal.getLineItemList();
        List<LineItemInternal> lineList = oceClaimInternal.getLineItemList().getValue();
        for (int i = 0; i < lineList.size(); ++i) {
            int j;
            OceLineItemImpl lineItemExternal = (OceLineItemImpl)lineItemExternalList.get(i);
            lineItemExternal.setActionFlagOutput("A");
            lineItemExternal.setHcpcsApc("HAPC-");
            lineItemExternal.setPaymentApc("PAPC-");
            lineItemExternal.setStatusIndicator("SI");
            lineItemExternal.setPaymentIndicator("PI");
            lineItemExternal.setDiscountingFormula("D");
            lineItemExternal.setRejectionDenialFlag("R");
            lineItemExternal.setPackagingFlag("P");
            lineItemExternal.setPaymentAdjustmentFlag01("AA");
            lineItemExternal.setPaymentMethodFlag("M");
            lineItemExternal.setPaymentAdjustmentFlag02("BA");
            lineItemExternal.setUnitsOutput("UUUUUUUUU");
            lineItemExternal.setCompositeAdjustmentFlag("CA");
            ArrayList<OceHcpcsModifier> modifierList = new ArrayList<OceHcpcsModifier>();
            modifierList.add(OceClaimFactory.getInstance().createHcpcsModifier("M0"));
            modifierList.add(OceClaimFactory.getInstance().createHcpcsModifier("M1"));
            lineItemExternal.setHcpcsModifierOutputList(modifierList);
            for (j = 0; j < 30; ++j) {
                lineItemExternal.getHcpcsEditList().add(j < 10 ? "E0" + j : "E" + j);
            }
            for (j = 0; j < 4; ++j) {
                lineItemExternal.getServiceDateEditList().add("E0" + j);
            }
            for (j = 0; j < 5; ++j) {
                lineItemExternal.getRevenueEditList().add("E0" + j);
            }
            for (OceHcpcsModifier modifier : lineItemExternal.getHcpcsModifierInputList()) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    modifier.getEditList().add("E0" + j2);
                }
            }
        }
        return 0;
    }
}

