/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.model.internal.DiagnosisTableData;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.PresentOnAdmission;
import gov.cms.oce.model.rsc.DiagnosisFlags;
import gov.cms.oce.model.rsc.Edit;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.Editable;
import gov.cms.oce.util.FlagSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class DiagnosisCode
implements Editable {
    private final FlagSet<DiagnosisFlags> flags = new FlagSet<DiagnosisFlags>(DiagnosisFlags.class);
    private final DiagnosisTableData tableData = new DiagnosisTableData();
    private boolean contractorEditBypassed = false;
    private OceClaimInternal claim;
    private PresentOnAdmission presentOnAdmission = new PresentOnAdmission();
    private String value;
    private String description;
    private final List<Edit> editList = new ArrayList<Edit>();

    DiagnosisCode() {
        this(null, null, null);
    }

    DiagnosisCode(OceClaimInternal claim, String value) {
        this(claim, value, null);
    }

    DiagnosisCode(OceClaimInternal claim, String value, String description) {
        this.claim = claim;
        this.value = value;
        this.description = description;
    }

    DiagnosisCode(DiagnosisCode copy) {
        this(copy.claim, copy.value, copy.description);
        this.presentOnAdmission.setValue(copy.presentOnAdmission.getValue());
        this.presentOnAdmission.setDescription(copy.presentOnAdmission.getDescription());
    }

    public final FlagSet<DiagnosisFlags> getFlags() {
        return this.flags;
    }

    public final DiagnosisTableData getTableData() {
        return this.tableData;
    }

    public final OceClaimInternal getClaim() {
        return this.claim;
    }

    public final void setClaim(OceClaimInternal claim) {
        this.claim = claim;
    }

    public final PresentOnAdmission getPresentOnAdmission() {
        return this.presentOnAdmission;
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    @Override
    public final List<Edit> getEditList() {
        return this.editList;
    }

    @Override
    public final boolean isContractorEditBypassed() {
        return this.contractorEditBypassed;
    }

    @Override
    public final void setContractorEditBypassed(boolean contractorEditBypassed) {
        this.contractorEditBypassed = contractorEditBypassed;
    }

    @Override
    public final boolean isEditBypassedByContractor(EditValue editValue) {
        for (EditValue bypassEditValue : this.claim.getEditBypassEditSet()) {
            if (bypassEditValue != editValue) continue;
            return true;
        }
        return false;
    }

    public final boolean isEditBypassedByContractorPresent() {
        for (Edit edit : this.editList) {
            if (!this.isEditBypassedByContractor(edit.getEditValue())) continue;
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.flags, this.tableData, this.presentOnAdmission, this.value, this.description, this.editList);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DiagnosisCode o = (DiagnosisCode)object;
        return Objects.equals(this.flags, o.flags) && Objects.equals(this.tableData, o.tableData) && Objects.equals(this.presentOnAdmission, o.presentOnAdmission) && Objects.equals(this.value, o.value) && Objects.equals(this.description, o.description) && Objects.equals(this.editList, o.editList);
    }
}

