/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

public enum ClaimProcessedValue {
    ZERO(0, "Claim processed."),
    ONE(1, "Claim could not be processed (edits 23, 24, 46, invalid bill type)."),
    TWO(2, "Claim could not be processed (claim has no line items)."),
    THREE(3, "Claim could not be processed (edit 10 - condition code 21 is present)."),
    FOUR(4, "Fatal error; claim could not be processed as input values are not valid or are incorrectly formatted; exit immediately"),
    NINE(9, "Fatal error; OCE cannot run - the environment cannot be set up as needed; exit immediately.");

    public final byte value;
    public final String description;

    private ClaimProcessedValue(byte value, String description) {
        this.value = value;
        this.description = description;
    }

    public static final ClaimProcessedValue getDisposition(byte value) {
        for (ClaimProcessedValue processedValue : ClaimProcessedValue.values()) {
            if (processedValue.value != value) continue;
            return processedValue;
        }
        return null;
    }
}

