/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.model.internal.Hcpcs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum HardcodedHcpcsSet {
    SURGICAL_CODE_RANGE_START("10000", 0, 0),
    SURGICAL_CODE_RANGE_END("69999", 0, 0),
    COVID_19_SPECIMEN_COLLECTION("C9803", 78, 0),
    FQHC_MED_NEW_PATIENT("G0466", 57, 0),
    FQHC_MED_EST_PATIENT("G0467", 57, 0),
    FQHC_IPPE_AWE("G0468", 57, 0),
    FQHC_MH_NEW_PATIENT("G0469", 57, 0),
    FQHC_MH_EST_PATIENT("G0470", 57, 0),
    TELEHEALTH_Q3041("Q3014", 0, 0),
    TELEHEALTH_G2025("G2025", 78, 0),
    CAPC_OBS_S603_EXCLUSION("G0463", 0, 0),
    VENTRICULAR_PACING_LEAD("33225", 0, 0),
    DEFIBULATOR_WITH_LEAD("33249", 0, 0),
    CRITICAL_CARE_ADDON("99292", 0, 0),
    CRITICAL_CARE("99291", 0, 0),
    TKA("27447", 0, 0),
    TKA_ANESTHESIA("01402", 0, 0),
    DEVICE_REQ_EXCLUSION("64569", 0, 0),
    ADVANCE_CARE_PLANNING("99497", 0, 0),
    ADVANCE_CARE_PLANNING_ADDON("99498", 0, 0),
    OPIOID_USE_DISORDER_G2172("G2172", 83, 0),
    OPIOID_USE_DISORDER_G2086("G2086", 78, 0),
    OPIOID_USE_DISORDER_G2087("G2087", 78, 0),
    OPIOID_USE_DISORDER_G2088("G2088", 78, 0);

    private static Map<String, HardcodedHcpcsSet> internalMap;
    private final String hcpcs;
    private final short versionStarted;
    private final short versionEnded;

    private HardcodedHcpcsSet(String hcpcs, short versionStarted, short versionEnded) {
        this.hcpcs = hcpcs;
        this.versionStarted = versionStarted;
        this.versionEnded = versionEnded;
    }

    public final String getHcpcs() {
        return this.hcpcs;
    }

    public final short getVersionStarted() {
        return this.versionStarted;
    }

    public final short getVersionEnded() {
        return this.versionEnded;
    }

    public static final HardcodedHcpcsSet getFlag(String name) {
        return internalMap.get(name);
    }

    public static final boolean isSurgicalCode(Hcpcs hcpcs) {
        if (hcpcs.getValue() == null) {
            return false;
        }
        String hcpcsValue = hcpcs.getValue();
        block8: for (int i = 0; i < hcpcsValue.length(); ++i) {
            if (!Character.isDigit(hcpcsValue.charAt(i))) {
                return false;
            }
            if (i != 0) continue;
            switch (hcpcsValue.charAt(i)) {
                case '1': {
                    continue block8;
                }
                case '2': {
                    continue block8;
                }
                case '3': {
                    continue block8;
                }
                case '4': {
                    continue block8;
                }
                case '5': {
                    continue block8;
                }
                case '6': {
                    continue block8;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static final boolean isExtendedSurgicalCode(Hcpcs hcpcs) {
        if (hcpcs.getValue() == null) {
            return false;
        }
        int offset = hcpcs.getValue().length() - 1;
        if (hcpcs.getValue().lastIndexOf(84, offset) < offset) {
            return false;
        }
        String hcpcsValue = hcpcs.getValue();
        for (int i = 0; i < offset; ++i) {
            if (Character.isDigit(hcpcsValue.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<String, HardcodedHcpcsSet> tmp = new HashMap<String, HardcodedHcpcsSet>();
        for (HardcodedHcpcsSet flag : HardcodedHcpcsSet.values()) {
            tmp.put(flag.hcpcs, flag);
        }
        internalMap = Collections.unmodifiableMap(tmp);
    }
}

