/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.DataDaoFactory;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import java.math.BigDecimal;
import java.text.Collator;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimUtility {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimUtility.class);
    private static final LocalDate CS_MODIFIER_DATE_STARTED = LocalDate.of(2020, 3, 18);
    private static final BigDecimal TOKEN_CHARGE = BigDecimal.valueOf(1.01);

    private OceClaimUtility() {
    }

    public static final BigDecimal getTokenChargeAmount() {
        return TOKEN_CHARGE;
    }

    public static final LocalDate getCsModifierDateStarted() {
        return CS_MODIFIER_DATE_STARTED;
    }

    public static final boolean isCsModifierApplicable(OceClaimInternal claim) {
        return claim.getDateEnded().getValueAsDate() != null && !claim.getDateEnded().getValueAsDate().isBefore(CS_MODIFIER_DATE_STARTED);
    }

    public static final boolean isCsModifierApplicable(LineItemInternal line) {
        return line.getServiceDate().getValueAsDate() != null && !line.getServiceDate().getValueAsDate().isBefore(CS_MODIFIER_DATE_STARTED);
    }

    public static final void reduceUnits(LineItemInternal line) {
        if (line.isUnitsGreaterThanOne()) {
            line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_UNITS_REDUCED_TO_ONE);
        }
    }

    public static final DataApcRowInternal getApcDetails(ClaimProcessor processor, String apcValue) {
        OceClaimInternal claim;
        DataDaoFactory daoFactory = processor.getResourceManager().getDataDaoFactory();
        DataApcDao dao = daoFactory.getDataApcDao();
        DataApcRowInternal row = dao.getRow(apcValue, (Short)(claim = processor.getInternalClaim()).getVersionAsPrimitive());
        if (row == null && logger.isWarnEnabled()) {
            logger.warn("APC \"{}\" not found in data_apc table.", (Object)apcValue);
        }
        return row;
    }

    public static final void assignApc(ClaimProcessor processor, LineItemInternal line, Apc apc) {
        if (apc != null && !HardcodedApcSet.APC_ZERO.getApc().equals(apc.getValue())) {
            DataApcDao dao;
            DataApcRowInternal row;
            if (line.getFlags().isSet(LineFlags.QUALIFIES_FOR_DISCOUNT)) {
                line.getFlags().unset(LineFlags.QUALIFIES_FOR_DISCOUNT);
            }
            if ((row = (dao = processor.getResourceManager().getDataDaoFactory().getDataApcDao()).getRow(apc, (Short)processor.getInternalClaim().getVersionAsPrimitive())) == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("APC \"{}\" not found in data_apc table.", (Object)apc.getValue());
                }
            } else {
                line.setStatusIndicator(row.getStatusIndicator());
                line.setPaymentIndicator(row.getPaymentIndicator());
                line.setPaymentApc(row.getApc());
                line.getTableData().setApcPayment(row.getApcPayment());
            }
        }
    }

    public static final void assignDefaultApc(ClaimProcessor processor, LineItemInternal line) {
        OceClaimUtility.assignApc(processor, line, line.getHcpcsApc());
    }

    public static final Apc getLookupApc(LineItemInternal line) {
        if (!Objects.equals(line.getPaymentApc().getValue(), HardcodedApcSet.APC_ZERO.getApc())) {
            return line.getPaymentApc();
        }
        if (!Objects.equals(line.getTableData().getDefaultApc().getValue(), HardcodedApcSet.APC_ZERO.getApc())) {
            return line.getTableData().getDefaultApc();
        }
        return null;
    }

    public static final void assignComposite(LineItemInternal line, Apc compositeApc, StatusIndicator compositeStatusIndicator, PaymentIndicator compositePaymentIndicator, String compositeAdjustmentFlag) {
        line.setPaymentApc(compositeApc.getValue());
        line.setStatusIndicator(compositeStatusIndicator.getValue());
        line.setPaymentIndicator(compositePaymentIndicator.getValue());
        if (line.isPackaged()) {
            line.setPackagingFlag((byte)0);
        }
        OceClaimUtility.reduceUnits(line);
        if (line.getDiscountingFormula().getValue().intValue() != 1) {
            line.setDiscountingFormula((byte)1);
        }
        line.setCompositeAdjustmentFlag(compositeAdjustmentFlag);
    }

    public static final void assignConditionalApc(LineItemInternal line) {
        Apc apc = line.getTableData().getDefaultApc();
        if (apc != null && !HardcodedApcSet.APC_ZERO.getApc().equals(apc.getValue())) {
            line.setStatusIndicator(line.getTableData().getApcStatusIndicator().getValue());
            line.setPaymentIndicator(line.getTableData().getApcPaymentIndicator().getValue());
            line.setPaymentApc(apc.getValue());
            line.getTableData().setApcPayment(line.getTableData().getApcPayment());
            if (line.isPackaged() && !line.matchesStatusIndicator("N")) {
                line.setPackagingFlag((byte)0);
            }
        }
    }

    public static final void setConditionalApc(LineItemInternal line) {
        line.setStatusIndicator(line.getTableData().getApcStatusIndicator().getValue());
        line.setPaymentIndicator(line.getTableData().getApcPaymentIndicator().getValue());
        line.setPackagingFlag((byte)0);
        if (line.matchesStatusIndicatorQ()) {
            String defaultAPC = line.getTableData().getDefaultApc().getValue();
            if (!HardcodedApcSet.APC_ZERO.getApc().equals(defaultAPC)) {
                line.setHcpcsApc(defaultAPC);
                line.setPaymentApc(defaultAPC);
            }
        }
    }

    public static final void packageLine(LineItemInternal line) {
        if (line.isNotPackaged() && line.getFlags().isNotSet(LineFlags.INPUT_INVALID_HCPCS)) {
            line.setStatusIndicator("N");
            line.setPaymentIndicator((byte)9);
            line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
            line.setPackagingFlag((byte)1);
            if (line.getFlags().isSet(LineFlags.QUALIFIES_FOR_DISCOUNT)) {
                line.getFlags().unset(LineFlags.QUALIFIES_FOR_DISCOUNT);
            }
        }
    }

    public static final void setSeparatelyPayable(LineItemInternal line) {
        line.setStatusIndicator("A");
        line.setPaymentIndicator((byte)2);
        line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
        if (line.isPackaged()) {
            line.setPackagingFlag((byte)0);
        }
        if (line.getFlags().isSet(LineFlags.QUALIFIES_FOR_DISCOUNT)) {
            line.getFlags().unset(LineFlags.QUALIFIES_FOR_DISCOUNT);
        }
    }

    public static final boolean isLessThan(LineItemInternal line1, LineItemInternal line2) {
        return OceClaimUtility.isLessThan(line1.getHcpcs().getValue(), line2.getHcpcs().getValue());
    }

    public static final boolean isLessThan(Hcpcs hcpcs1, Hcpcs hcpcs2) {
        return OceClaimUtility.isLessThan(hcpcs1.getValue(), hcpcs2.getValue());
    }

    public static final boolean isLessThan(String hcpcs1, String hcpcs2) {
        if (hcpcs1 == null) {
            return hcpcs2 != null;
        }
        if (hcpcs2 == null) {
            return false;
        }
        Collator codeCollator = Collator.getInstance(Locale.US);
        codeCollator.setStrength(0);
        return codeCollator.compare(hcpcs1, hcpcs2) < 0;
    }

    public static final void print(String claimId, OceClaimInternal claim, String message, Object ... parameters) {
        if (claim.matchesClaimId(claimId)) {
            if (parameters == null) {
                logger.error(message);
            } else {
                logger.error(message, parameters);
            }
        }
    }

    public static final void print(String claimId, OceClaimInternal claim, LineItemInternal line, boolean includeFlags) {
        if (claim.matchesClaimId(claimId)) {
            logger.error("CLAIM:{}", (Object)claim.getProcessingInformation().getClaimId().trim());
            OceClaimUtility.print(claim, line, includeFlags);
        }
    }

    public static final void print(OceClaimInternal claim, LineItemInternal line, boolean includeFlags) {
        if (claim.getLineItemList().getValue().isEmpty()) {
            logger.error("No lines to print.");
        } else {
            int lineIndex = claim.getLineItemList().getValue().indexOf(line) + 1;
            int dayIndex = line.getDay().getIndex() + 1;
            logger.error("LINE:{}, DAY/DATE:{}/{}, HCPCS/RC:{}/{}, PAPC/HAPC/PAYMENT:{}/{}/{}, SI/ASI/DSI:{}/{}/{}, PI/API/DPI:{}/{}/{}, AF/PKG/REJDEN:{}/{}/{}, UNITS:{}, CHARGES:{}.", new Object[]{lineIndex, dayIndex, line.getServiceDate().getValue(), line.getHcpcs().getValue(), line.getRevenueCode().getValue(), line.getPaymentApc().getValue(), line.getHcpcsApc().getValue(), line.getTableData().getApcPayment(), line.getStatusIndicator().getValue(), line.getTableData().getApcStatusIndicator().getValue(), line.getTableData().getDefaultStatusIndicator().getValue(), line.getPaymentIndicator().getValue(), line.getTableData().getApcPaymentIndicator().getValue(), line.getTableData().getDefaultPaymentIndicator().getValue(), line.getActionFlag().getValue(), line.getPackagingFlag().getValue(), line.getRejectionDenialFlag().getValue(), line.getUnits().getValue(), line.getCharge().getValue()});
            if (includeFlags) {
                StringBuilder flagString = new StringBuilder();
                boolean first = true;
                for (LineFlags flag : LineFlags.values()) {
                    if (!line.getFlags().isSet(flag)) continue;
                    if (first) {
                        first = false;
                    } else {
                        flagString.append(',');
                    }
                    flagString.append(flag.name());
                }
                logger.error("FLAGS:{}", (Object)flagString);
            }
        }
    }
}

