/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

public enum ReturnCode {
    UNKNOWN(-2, "Unknown"),
    UNSPECIFIED(-1, "Unspecified"),
    OK(0, "Success"),
    NO_MEMORY(1, "Out of memory - all modules"),
    ALREADY_INIT(2, "OceInit - already run once"),
    CANNOT_START(3, "OceInit - run time environment setup failed"),
    BAD_ROT_OPEN(4, "OceInit - cannot open ROT file"),
    BAD_ROT_STAT(5, "OceInit - cannot start ROT file"),
    BAD_ROT_MEM(6, "OceInit - no memory for ROT"),
    BAD_ROT_READ(7, "OceInit - read error loading ROT"),
    ROT_CORRUPT(8, "OceInit - ROT file corrupted"),
    BAD_VERSION(9, "OceInit - version string mismatch"),
    BAD_ROT_LINK(10, "OceInit - error linking ROTs"),
    NOT_SETUP(11, "Run time environment not set up - all modules"),
    NO_LINE_ITEMS(12, "OceClaim - zero line items"),
    BAD_FROM_DATE(13, "OceClaim - invalid From date"),
    BAD_THRU_DATE(14, "OceClaim - invalid Thru date"),
    BAD_DATE_SEQUENCE(15, "OceClaim - dates out of sequence"),
    BAD_LINE_DATE(16, "OceClaim - at least one line has bad date"),
    DATE_VERSION(17, "OceClaim - From date not in any version range"),
    BAD_BILL_TYPE(18, "OceClaim - bill type not in PBT table"),
    BAD_USER_VERSION(19, "OceClaim - User gave bad version ID"),
    BILL_TYPE_NOT_OPPS(21, "OceClaim - bill type is not appropriate for OPPS (PBT cell 3)"),
    CC41_NA_TOB(22, "OceClaim - condition code 41 with bill type 12x or 14x"),
    LINE_LENGTH(23, "Invalid line length used with \"-fmt\" option"),
    INV_DESC_OPTION(24, "Description - description type not supported"),
    CODE_DESC_NOT_FOUND(25, "Description - no description found for code and type provided"),
    INVALID_EDIT_BYPASS(26, "Contractor Override - specified edit not present in EditBypass table"),
    INVALID_BYPASS_VALUE(27, "Contractor Override - non-numeric value specified for numeric-only field"),
    INVALID_VALUE_CODE_INPUT(28, "Contractor Override - non-numeric value specified for value code amount field"),
    INVALID_RECEIPT_DATE(29, "Receipt Date - date invalid or outside of version range");

    public final int code;
    public final String description;

    private ReturnCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getDescription() {
        return this.description;
    }
}

