/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtility {
    private static final Logger logger = LoggerFactory.getLogger(FileUtility.class);
    private byte[] buf;
    private int len;

    public FileUtility() {
        this(4096);
    }

    public FileUtility(int bufferSize) {
        this.buf = new byte[128 < bufferSize ? bufferSize : 128];
    }

    public final StringBuilder readFile(String source) {
        StringBuilder input = new StringBuilder();
        this.readFile(new File(source), input);
        return input;
    }

    public final StringBuilder readFile(File source) {
        StringBuilder input = new StringBuilder();
        this.readFile(source, input);
        return input;
    }

    public final void readFile(String source, StringBuilder input) {
        this.readFile(new File(source), input);
    }

    public final void readFile(File source, StringBuilder input) {
        if (source.exists()) {
            try (FileReader r = new FileReader(source);){
                char[] buffer = new char[256];
                while (-1 < (this.len = ((Reader)r).read(buffer, 0, buffer.length))) {
                    input.append(buffer, 0, this.len);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("File not found.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("File failed to be read.", (Throwable)e);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("File: {} failed to be loaded (does not exist).", (Object)source.getName());
        }
    }

    public final void writeFile(String destination, String output) {
        this.writeFile(new File(destination), output);
    }

    public final void writeFile(File destination, String output) {
        try (FileOutputStream os = new FileOutputStream(destination, false);){
            this.buf = output.getBytes();
            ((OutputStream)os).write(this.buf, 0, this.buf.length);
            os.flush();
        }
        catch (FileNotFoundException e) {
            logger.error("File not found.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("File failed to be read.", (Throwable)e);
        }
    }

    public final void cp(File source, File destination) {
        if (source.exists()) {
            if (source.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    logger.error("Directory:{} failed to be created for copy operation.", (Object)destination.getName());
                }
                if (destination.exists()) {
                    File[] f = source.listFiles();
                    int i = f.length;
                    while (-1 < --i) {
                        this.cp(f[i], new File(destination, f[i].getName()));
                    }
                } else {
                    logger.error("Directory:{} does not exist, could not copy files.", (Object)destination.getName());
                }
            } else {
                try (FileInputStream is = new FileInputStream(source);
                     FileOutputStream os = new FileOutputStream(destination, false);){
                    while (-1 < (this.len = ((InputStream)is).read(this.buf, 0, this.buf.length))) {
                        ((OutputStream)os).write(this.buf, 0, this.len);
                    }
                    os.flush();
                }
                catch (FileNotFoundException e) {
                    logger.error("File not found.", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("File failed to be read.", (Throwable)e);
                }
            }
        } else {
            logger.error("File:{} failed to be copied (file does not exist).", (Object)source.getName());
        }
    }

    public final void rm(File source) {
        if (source.exists()) {
            if (source.isDirectory()) {
                File[] f = source.listFiles();
                int i = f.length;
                while (-1 < --i) {
                    this.rm(f[i]);
                }
            }
            if (!source.delete()) {
                logger.error("File:{} failed to be deleted (delete() operation failed).", (Object)source.getName());
            }
        } else {
            logger.error("File:{} failed to be deleted (file does not exist).", (Object)source.getName());
        }
    }
}

