/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

public final class VersionRange {
    private final short earliestVersion;
    private final short latestVersion;

    private VersionRange() {
        this(0, 0);
    }

    public VersionRange(short earliestVersion, short latestVersion) {
        this.earliestVersion = earliestVersion;
        this.latestVersion = latestVersion;
    }

    public final short getEarliestVersion() {
        return this.earliestVersion;
    }

    public final short getLatestVersion() {
        return this.latestVersion;
    }

    public final boolean isOutsideOfRange(short version) {
        return version < this.earliestVersion || version > this.latestVersion;
    }

    public final boolean isInsideOfRange(short version) {
        return !this.isOutsideOfRange(version);
    }

    public final boolean isBeforeEarliestVersion(short version) {
        return version < this.earliestVersion;
    }

    public final boolean isAfterLatestVersion(short version) {
        return version > this.latestVersion;
    }
}

