/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimDefinitionLoader;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.FieldDefinitionLoader;
import gov.cms.oce.util.converter.rsc.InvalidRecordException;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinitionLoader;
import gov.cms.oce.util.converter.rsc.RecordModel;
import gov.cms.oce.util.converter.rsc.TestClaimFileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestCaseOutputConverter {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseOutputConverter.class);
    private String fieldDefinitionFile = "/claim-def/field.def";
    private String recordDefinitionFile = "/claim-def/record.def";
    private String claimDefinitionFile = "/claim-def/claim.def";
    private ClaimDefinition claimDefinition;

    public final void setFieldDefinitionFile(String filePath) {
        this.fieldDefinitionFile = filePath;
    }

    public final void setRecordDefinitionFile(String filePath) {
        this.recordDefinitionFile = filePath;
    }

    public final void setClaimDefinitionFile(String filePath) {
        this.claimDefinitionFile = filePath;
    }

    public final void loadClaimDefinition() throws IOException {
        this.claimDefinition = new ClaimDefinitionLoader(this.claimDefinitionFile, new RecordDefinitionLoader(this.recordDefinitionFile, new FieldDefinitionLoader(this.fieldDefinitionFile).load()).load()).load().getItem(0);
    }

    public final void printDefinitionTree(ClaimDefinition definition) {
        logger.debug("----START TREE");
        logger.debug("CLAIM ID = {}", (Object)definition.getId());
        for (RecordDefinition record : definition.getRecords()) {
            logger.debug("RECORD ID = {}", (Object)record.getId());
            for (FieldDefinition field : record.getFields()) {
                logger.debug("FIELD ID = {}", (Object)field.getId());
            }
        }
        logger.debug("----END TREE");
    }

    public final String getAggregate(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        int count = 0;
        for (String s : list) {
            ++count;
            tmp.append(s);
        }
        return count < 1 ? "" : tmp.toString();
    }

    public final void writeEdit(Writer w, String edit) throws IOException {
        if (edit.equals("   ")) {
            w.write(edit);
        } else if (edit.startsWith("  ")) {
            w.write("00");
            w.write(edit.substring(2));
        } else if (edit.startsWith(" ")) {
            w.write("0");
            w.write(edit.substring(1));
        } else {
            w.write(edit);
        }
    }

    public final void convert(String inputFilePath, String outputFilePath) throws IOException {
        this.loadClaimDefinition();
        try (FileWriter w = new FileWriter(outputFilePath);){
            int testCaseCount = 0;
            TestClaimFileReader reader = new TestClaimFileReader(inputFilePath, this.claimDefinition);
            RecordDefinition mDef = this.claimDefinition.getRecord("M", 0);
            RecordDefinition nDef = this.claimDefinition.getRecord("N", 0);
            RecordDefinition oDef = this.claimDefinition.getRecord("O", 0);
            RecordDefinition pDef = this.claimDefinition.getRecord("P", 0);
            RecordDefinition qDef = this.claimDefinition.getRecord("Q", 0);
            RecordDefinition rDef = this.claimDefinition.getRecord("R", 0);
            RecordDefinition sDef = this.claimDefinition.getRecord("S", 0);
            reader.open();
            while (true) {
                try {
                    ClaimModel claim;
                    while ((claim = reader.next()) != null) {
                        int j;
                        int j2;
                        ++testCaseCount;
                        RecordModel mRecord = claim.getRecord("M", 0);
                        RecordModel nRecord = claim.getRecord("N", 0);
                        RecordModel oRecord = claim.getRecord("O", 0);
                        RecordModel pRecord = claim.getRecord("P", 0);
                        RecordModel qRecord = claim.getRecord("Q", 0);
                        w.write(mRecord.get(mDef.getField("MId"), 0));
                        w.write(mRecord.get(mDef.getField("MClaimProcessingFlag"), 0));
                        w.write(mRecord.get(mDef.getField("MClaimDisposition"), 0));
                        w.write(mRecord.get(mDef.getField("MClaimRejectionDisposition"), 0));
                        w.write(mRecord.get(mDef.getField("MClaimDenialDisposition"), 0));
                        w.write(mRecord.get(mDef.getField("MClaimRTPDisposition"), 0));
                        w.write(mRecord.get(mDef.getField("MClaimSuspensionDisposition"), 0));
                        w.write(mRecord.get(mDef.getField("MLineItemRejectionDisposition"), 0));
                        w.write(mRecord.get(mDef.getField("MLineItemDenialDisposition"), 0));
                        String edit = null;
                        for (j2 = 0; j2 < 4; ++j2) {
                            edit = mRecord.get(mDef.getField("MClaimRejectionEdits"), j2);
                            this.writeEdit(w, edit);
                        }
                        for (j2 = 0; j2 < 8; ++j2) {
                            edit = mRecord.get(mDef.getField("MClaimDenialEdits"), j2);
                            this.writeEdit(w, edit);
                        }
                        for (j2 = 0; j2 < 30; ++j2) {
                            edit = mRecord.get(mDef.getField("MClaimRTPEdits"), j2);
                            this.writeEdit(w, edit);
                        }
                        for (j2 = 0; j2 < 16; ++j2) {
                            edit = nRecord.get(nDef.getField("NClaimSuspensionEdits"), j2);
                            this.writeEdit(w, edit);
                        }
                        for (j2 = 0; j2 < 12; ++j2) {
                            edit = nRecord.get(nDef.getField("NLineItemRejectionEdits"), j2);
                            this.writeEdit(w, edit);
                        }
                        for (j2 = 0; j2 < 6; ++j2) {
                            edit = nRecord.get(nDef.getField("NLineItemDenialEdits"), j2);
                            this.writeEdit(w, edit);
                        }
                        String apcReturnBufferFlag = nRecord.get(nDef.getField("NApcReturnBufferFlag"), 0);
                        if (apcReturnBufferFlag.equals(" ")) {
                            ((Writer)w).write(48);
                        } else {
                            w.write(apcReturnBufferFlag);
                        }
                        w.write(nRecord.get(nDef.getField("NVersion"), 0));
                        String nonOppsFlag = nRecord.get(nDef.getField("NNonOppsBillFlag"), 0);
                        if (nonOppsFlag.equals(" ")) {
                            ((Writer)w).write(48);
                        } else if (nonOppsFlag.equals("0")) {
                            ((Writer)w).write(50);
                        } else {
                            w.write(nonOppsFlag);
                        }
                        for (int i = 0; i < 10; ++i) {
                            String cc = mRecord.get(mDef.getField("MClaimValueCodes"), i);
                            if (cc.equals("  000000000")) {
                                w.write("           ");
                                continue;
                            }
                            w.write(cc);
                        }
                        w.write(this.getAggregate(nRecord.get(nDef.getField("NConditionCodes"))));
                        w.write(" 0");
                        for (int k = 1; k < 10; ++k) {
                            String editName = "ODiagnosis" + k + "Edits";
                            for (int j3 = 0; j3 < 8; ++j3) {
                                edit = oRecord.get(oDef.getField(editName), j3);
                                this.writeEdit(w, edit);
                            }
                        }
                        String dxEditFiller = "                        ";
                        if (pRecord == null || pRecord.isEmpty()) {
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                        } else {
                            for (int k = 10; k < 19; ++k) {
                                String editName = "PDiagnosis" + k + "Edits";
                                for (j = 0; j < 8; ++j) {
                                    edit = pRecord.get(pDef.getField(editName), j);
                                    this.writeEdit(w, edit);
                                }
                            }
                        }
                        if (qRecord == null || qRecord.isEmpty()) {
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                            w.write(dxEditFiller);
                        } else {
                            for (int k = 19; k < 29; ++k) {
                                String editName = "QDiagnosis" + k + "Edits";
                                for (j = 0; j < 8; ++j) {
                                    edit = qRecord.get(qDef.getField(editName), j);
                                    this.writeEdit(w, edit);
                                }
                            }
                        }
                        String lineCount = nRecord.get(nDef.getField("NLineItemCount"), 0);
                        if (lineCount.startsWith("00")) {
                            w.write("  ");
                            w.write(lineCount.substring(2));
                        } else if (lineCount.startsWith("0")) {
                            w.write(" ");
                            w.write(lineCount.substring(1));
                        } else {
                            w.write(lineCount);
                        }
                        List<RecordModel> rRecords = claim.getRecords("R");
                        List<RecordModel> sRecords = claim.getRecords("S");
                        for (int i = 0; i < rRecords.size(); ++i) {
                            int j4;
                            RecordModel rRecord = rRecords.get(i);
                            RecordModel sRecord = sRecords.get(i);
                            w.write(rRecord.get(rDef.getField("RPaymentApc"), 0));
                            w.write(rRecord.get(rDef.getField("RHcpcsApc"), 0));
                            w.write(rRecord.get(rDef.getField("RServiceIndicator"), 0));
                            String pi = rRecord.get(rDef.getField("RPaymentIndicator"), 0);
                            if (pi.startsWith(" ")) {
                                ((Writer)w).write(48);
                                w.write(pi.substring(1));
                            } else {
                                w.write(pi);
                            }
                            w.write(rRecord.get(rDef.getField("RDiscountingFormula"), 0));
                            w.write(rRecord.get(rDef.getField("RRejectionDenialFlag"), 0));
                            w.write(rRecord.get(rDef.getField("RPackagingFlag"), 0));
                            w.write(rRecord.get(rDef.getField("RPaymentAdjustmentFlag01"), 0));
                            w.write(rRecord.get(rDef.getField("RPaymentMethodFlag"), 0));
                            String units = rRecord.get(rDef.getField("RServiceUnits"), 0);
                            boolean offsetFound = false;
                            for (j4 = 0; j4 < units.length(); ++j4) {
                                int ch = units.charAt(j4);
                                if (!offsetFound) {
                                    if (ch == 48) {
                                        ch = 32;
                                    } else if (ch != 32) {
                                        offsetFound = true;
                                    }
                                }
                                ((Writer)w).write(ch);
                            }
                            for (j4 = 0; j4 < 30; ++j4) {
                                edit = rRecord.get(rDef.getField("RProcedureEdits"), j4);
                                this.writeEdit(w, edit);
                            }
                            w.write(rRecord.get(rDef.getField("RLineItemActionFlag"), 0));
                            w.write(rRecord.get(rDef.getField("RCompositeAdjustmentFlag"), 0));
                            w.write(this.getAggregate(rRecord.get(rDef.getField("RHcpcsModifier"))));
                            w.write(rRecord.get(rDef.getField("RPaymentAdjustmentFlag02"), 0));
                            for (int k = 1; k < 6; ++k) {
                                String editName = "SModifierEdits" + k;
                                for (int j5 = 0; j5 < 4; ++j5) {
                                    edit = sRecord.get(sDef.getField(editName), j5);
                                    this.writeEdit(w, edit);
                                }
                            }
                            for (j4 = 0; j4 < 4; ++j4) {
                                edit = sRecord.get(sDef.getField("SDateEdits"), j4);
                                this.writeEdit(w, edit);
                            }
                            for (j4 = 0; j4 < 5; ++j4) {
                                edit = sRecord.get(sDef.getField("SRevenueEdits"), j4);
                                this.writeEdit(w, edit);
                            }
                        }
                        String emptyLine = "                                                                                                                                                                                                                     ";
                        for (int i = rRecords.size(); i < 450; ++i) {
                            w.write(emptyLine);
                        }
                        w.write("\r\n");
                    }
                }
                catch (InvalidRecordException e) {
                    logger.error("Failed to read claim data.", (Throwable)e);
                    continue;
                }
                break;
            }
            logger.debug("{} test cases written.", (Object)testCaseCount);
        }
        catch (Exception e) {
            logger.error("Exception.", (Throwable)e);
        }
        logger.debug("...complete");
    }

    public static final void main(String[] v) throws IOException {
        TestCaseOutputConverter c = new TestCaseOutputConverter();
        c.convert(v[0], v[1]);
    }
}

