/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileRowLoader {
    private static final Logger logger = LoggerFactory.getLogger(FileRowLoader.class);
    private final LineNumberReader reader;
    private final String filePath;
    private long count;

    private FileRowLoader() throws IOException {
        this(null);
    }

    public FileRowLoader(String filePath) throws IOException {
        this.reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8));
        this.filePath = filePath;
        this.count = 0L;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final long getClaimCount() {
        return this.count;
    }

    public final ClaimModel next(ClaimDefinition claimDefinition) throws IOException {
        long lastClaim = this.count;
        ClaimModel claim = new ClaimModel(claimDefinition);
        return lastClaim < this.next(claim) ? claim : null;
    }

    public final long next(ClaimModel claim) throws IOException {
        String line;
        ClaimDefinition claimDefinition = claim.getDefinition();
        RecordDefinition startRecordDefinition = claimDefinition.getRecords().get(0);
        int lineLength = startRecordDefinition.getLength();
        int lineBuffer = lineLength * 2;
        this.reader.mark(lineBuffer);
        while ((line = this.reader.readLine()) != null) {
            if ("".equals(line.trim())) {
                logger.warn("Empty Line (Ignored). Line Number: {}", (Object)this.reader.getLineNumber());
            } else {
                RecordDefinition recordDefinition = claimDefinition.getRecord("" + line.charAt(0));
                if (recordDefinition == null) {
                    int i = -1;
                    while (++i < line.length() && Character.isWhitespace(line.charAt(i))) {
                    }
                    if ('#' == line.charAt(i)) {
                        logger.info("Comment Found (Ignored). Line Number: {}", (Object)this.reader.getLineNumber());
                    } else {
                        logger.warn("Unrecognized Record Id (Ignored). Line Number: {}", (Object)this.reader.getLineNumber());
                    }
                } else {
                    if (line.length() == lineLength) {
                        logger.info("Adding Row: {} to {} ", (Object)line, (Object)recordDefinition.getId());
                        claim.addRecord(new RecordModel(recordDefinition, line));
                        ++this.count;
                        break;
                    }
                    logger.warn("Bad Line Length. Found: {}, Expected: {}, Line Number: {}", new Object[]{line.length(), lineLength, this.reader.getLineNumber()});
                }
            }
            this.reader.mark(lineBuffer);
        }
        return this.count;
    }
}

