/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.InvalidRecordException;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestClaimFileReader {
    private static final Logger logger = LoggerFactory.getLogger(TestClaimFileReader.class);
    private final ClaimDefinition claimDefinition;
    private final String filePath;
    private long count;
    private LineNumberReader reader;

    private TestClaimFileReader() {
        this(null, null);
    }

    public TestClaimFileReader(String filePath, ClaimDefinition claimDefinition) {
        this.claimDefinition = claimDefinition;
        this.filePath = filePath;
        this.count = 0L;
    }

    public final ClaimDefinition getClaimDefinition() {
        return this.claimDefinition;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final long getCurrentClaimCount() {
        return this.count;
    }

    public final boolean open() throws IOException {
        if (this.reader == null) {
            this.reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.filePath), StandardCharsets.UTF_8));
        } else {
            logger.warn("Open method called on an already-opened reader for file \"{}\".", (Object)this.filePath);
        }
        return true;
    }

    public final boolean close() throws IOException {
        if (this.reader == null) {
            logger.warn("Close method called on an already-closed reader for file \"{}\".", (Object)this.filePath);
        } else {
            this.reader.close();
            this.reader = null;
        }
        return true;
    }

    public final ClaimModel next() throws IOException, InvalidRecordException {
        String line;
        ClaimModel claim = new ClaimModel(this.claimDefinition);
        RecordDefinition startRecordDefinition = this.claimDefinition.getRecords().get(0);
        InvalidRecordException invalidRecordException = null;
        boolean startRecordFound = false;
        int lineLength = startRecordDefinition.getLength();
        int lineBuffer = lineLength * 2;
        this.reader.mark(lineBuffer);
        while ((line = this.reader.readLine()) != null) {
            if ("".equals(line.trim())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Empty line encountered, ignoring line. Line Number: {}", (Object)this.reader.getLineNumber());
                }
            } else {
                RecordDefinition recordDefinition = this.claimDefinition.getRecord(String.valueOf(line.charAt(0)));
                if (recordDefinition == null) {
                    int i = -1;
                    while (++i < line.length() && Character.isWhitespace(line.charAt(i))) {
                    }
                    if ('#' == line.charAt(i)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Comment marker \"#\" encountered, ignoring rest of line. Line Number: {}", (Object)this.reader.getLineNumber());
                        }
                    } else {
                        logger.error("Unrecognized record ID encountered, ignoring line. Line Number: {}", (Object)this.reader.getLineNumber());
                        invalidRecordException = new InvalidRecordException("Unrecognized record ID encountered. Line Number: " + this.reader.getLineNumber());
                    }
                } else if (line.length() == lineLength) {
                    if (recordDefinition == startRecordDefinition) {
                        if (startRecordFound) {
                            this.reader.reset();
                            break;
                        }
                        startRecordFound = true;
                        ++this.count;
                    }
                    claim.addRecord(new RecordModel(recordDefinition, line));
                } else {
                    logger.error("Bad line length encountered, ignoring line. Length found: {}, but expected: {}, Line Number: {}", new Object[]{line.length(), lineLength, this.reader.getLineNumber()});
                    invalidRecordException = new InvalidRecordException("Bad line length encountered. Length found: " + line.length() + ", expected: " + lineLength + ". Line Number: " + this.reader.getLineNumber());
                }
            }
            this.reader.mark(lineBuffer);
        }
        if (invalidRecordException != null) {
            throw invalidRecordException;
        }
        return claim.getRecords() == null ? null : claim;
    }
}

